package com.digiwin.athena.aim.infrastructure.thememap.service;

import com.digiwin.athena.aim.app.env.EnvProperties;
import com.digiwin.athena.aim.common.InterfaceConstant;
import com.digiwin.athena.aim.infrastructure.thememap.dto.KmApplicationRelationDTO;
import com.digiwin.athena.aim.infrastructure.thememap.dto.KmApplicationRelationReqDTO;
import com.digiwin.athena.aim.infrastructure.thememap.dto.TmAppExpireChangeComponentDTO;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

/**
 * ThemeMapServiceImpl Description
 *
 * @author majianfu
 * @date 2022/8/23
 * @since
 */
@Service
@Slf4j
public class ThemeMapServiceImpl implements ThemeMapService {
    @Autowired
    EnvProperties envProperties;

    @Autowired
    RestTemplate restTemplate;

    @Autowired
    MessageUtils messageUtils;

    @Override
    public TmAppExpireChangeComponentDTO getAppExpireChangeComponent(TmAppExpireChangeComponentDTO appExpireChangeComponent) {
        String url = envProperties.getKnowledgegraphUri() + InterfaceConstant.KNOWLED_QUERYCOMPONENT;

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        HttpEntity<TmAppExpireChangeComponentDTO> httpEntity = new HttpEntity<>(appExpireChangeComponent, headers);
        try {
            ResponseEntity<BaseResultDTO<TmAppExpireChangeComponentDTO>> respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<TmAppExpireChangeComponentDTO>>() {
                    });
            if (null != respEntity.getBody() && respEntity.getBody().isOK()) {
                return respEntity.getBody().getResponse();
            } else {
                log.error("请求KM获取过期应用的组件列表报错，参数：{}, 响应内容：{}", appExpireChangeComponent, JsonUtils.objectToString(respEntity.getBody()));
                String errMsg = MessageFormat.format(messageUtils.getMessage("exception.KM.expired.application"),
                        JsonUtils.objectToString(appExpireChangeComponent), JsonUtils.objectToString(respEntity.getBody()));
                throw BusinessException.create(errMsg);
            }
        } catch (BusinessException ex) {
            throw ex;
        } catch (Exception ex) {
            String errMsg = MessageFormat.format(messageUtils.getMessage("exception.KM.expired.application2"), JsonUtils.objectToString(appExpireChangeComponent));
            throw BusinessException.create(errMsg, ex);
        }
    }

    @Override
    public List<KmApplicationRelationDTO> getApplicationRelation(KmApplicationRelationReqDTO relationReqDTO) {
        String url = envProperties.getKnowledgegraphUri() + InterfaceConstant.KNOWLED_APPLICATIONRELATION;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        headers.add("token", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        List<KmApplicationRelationDTO> relationDTOS = new ArrayList<>();
        HttpEntity<KmApplicationRelationReqDTO> httpEntity = new HttpEntity<>(relationReqDTO, headers);
        try {
            log.info("请求KM获取应用信息 入参:{}", JsonUtils.objectToString(httpEntity));
            ResponseEntity<BaseResultDTO<List<KmApplicationRelationDTO>>> respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<List<KmApplicationRelationDTO>>>() {
                    });
            log.info("请求KM获取应用信息，入参：{}, 响应内容：{}", JsonUtils.objectToString(relationReqDTO), JsonUtils.objectToString(respEntity.getBody()));
            if (null != respEntity.getBody() && respEntity.getBody().isOK()) {
                return  respEntity.getBody().getResponse();
            }
        } catch (BusinessException ex) {
            log.error("请求KM获取应用信息报错，入参：{}, ex：{}", JsonUtils.objectToString(relationReqDTO), ex);
        }
        return relationDTOS;
    }
}
