package com.digiwin.athena.aim.infrastructure.trans.impl;

import com.digiwin.athena.aim.app.env.EnvProperties;
import com.digiwin.athena.aim.common.Constants;
import com.digiwin.athena.aim.infrastructure.trans.TranslateService;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * DAP Translate Service
 *
 * @author sungqz
 * @date 2023/10/10
 * @since
 */
@Service
@Slf4j
public class TranslateServiceImpl implements TranslateService {

    /**
     * 繁体转为简体
     */
    public static final String TRANSLATE_TW_TO_CN = "zh2Hans";

    /**
     * 简体转为繁体
     */
    public static final String TRANSLATE_CN_TO_TW = "zh2Hant";

    @Resource
    private EnvProperties envProperties;

    @Resource
    private RestTemplate restTemplate;

    /**
     * DAP翻译接口
     */
    private static final String DAP_TRANSLATE_PATH = "/restful/service/translater/IDWTranslateService/translate";

    /**
     * 文本翻译
     *
     * @param text   文本
     * @param locale 语言别
     * @return
     */
    @Override
    public String translateText(String text, String locale) {
        if (StringUtils.isBlank(text) || Constants.EN_US_LOCALE.equals(locale)) {
            return text;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        // 请求体
        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("content", text);
        if (Constants.ZH_CN_LOCALE.equals(locale)) {
            requestMap.put("convertTypes", Collections.singletonList(TRANSLATE_TW_TO_CN));
        } else if (Constants.ZH_TW_LOCALE.equals(locale)) {
            requestMap.put("convertTypes", Collections.singletonList(TRANSLATE_CN_TO_TW));
        }
        HttpEntity<Map<String, Object>> requestEntity = new HttpEntity<>(requestMap, headers);
        StringBuilder url = new StringBuilder(envProperties.getTransUri()).append(DAP_TRANSLATE_PATH);
        try {
            ResponseEntity<JSONObject> respEntity = restTemplate.exchange(url.toString(), HttpMethod.POST, requestEntity, JSONObject.class);
            if (org.apache.http.HttpStatus.SC_OK == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
                JSONObject data = respEntity.getBody().getJSONObject("response").getJSONObject("data");
                if (Objects.nonNull(data)) {
                    return Constants.ZH_CN_LOCALE.equals(locale) ? data.getString(TRANSLATE_TW_TO_CN) : data.getString(TRANSLATE_CN_TO_TW);
                } else {
                    log.error("translate text return empty, url:{}, text:{}", url, text);
                    return text;
                }
            } else {
                log.error("translate text fail, url:{}, status:{}, response:{}", url, respEntity.getStatusCodeValue(), respEntity.getBody());
                return text;
            }
        } catch (Exception ex) {
            log.error("translate text error, url:{}", url, ex);
            return text;
        }
    }
}