package com.digiwin.athena.aim.util;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Base64;

/**
 * AES加密工具类
 *
 * @author: sungq
 * @date: 2023-12-14
 */
public class AESUtils {

    /**
     * 移动端sso链接加密key
     */
    @SuppressWarnings("java:S6418")
    public static final String MOBILE_SSO_SECRET_KEY = "550F743242C486791EDBDEDEE3498BAA";

    /**
     * 生成密钥算法
     *
     * @param seed
     * @return
     * @throws Exception
     */
    public static String generateKey(String seed) throws Exception {
        // 获取秘钥生成器
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        // 通过种子初始化
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.setSeed(seed.getBytes(StandardCharsets.UTF_8));
        keyGenerator.init(192, secureRandom);
        // 生成秘钥并返回
        SecretKey secretKey = keyGenerator.generateKey();
        byte[] enCodeFormat = secretKey.getEncoded();
        return byte2hex(enCodeFormat);
    }

    /**
     * 加密算法
     *
     * @param secretKey
     * @param content
     * @return
     * @throws Exception
     */
    public static String encrypt(String secretKey, String content) throws Exception {
        // 秘钥
        byte[] enCodeFormat = hex2byte(secretKey);
        // 创建AES秘钥
        SecretKeySpec key = new SecretKeySpec(enCodeFormat, "AES");
        // 创建密码器
        Cipher cipher = Cipher.getInstance("AES");
        // 初始化加密器
        cipher.init(Cipher.ENCRYPT_MODE, key);
        // 加密
        byte[] bytes = cipher.doFinal(content.getBytes(StandardCharsets.UTF_8));
        //10.将加密后的数据转换为字符串
//        return Base64.encodeBase64String(bytes);
        return byte2hex(bytes);
    }

    /**
     * 解密算法
     *
     * @param secretKey
     * @param content
     * @return
     * @throws Exception
     */
    public static String decrypt(String secretKey, String content) throws Exception {
        if (content == null || content.length() < 2) {
            return content;
        }
        // 秘钥
        byte[] enCodeFormat = hex2byte(secretKey);
        // 创建AES秘钥
        SecretKeySpec key = new SecretKeySpec(enCodeFormat, "AES");
        // 创建密码器
        Cipher cipher = Cipher.getInstance("AES");
        // 初始化解密器
        cipher.init(Cipher.DECRYPT_MODE, key);
        // 解密
        byte[] result = cipher.doFinal(hex2byte(content));
        return new String(result, StandardCharsets.UTF_8);
    }

    private static String byte2hex(byte[] b) {
        StringBuilder sb = new StringBuilder(b.length * 2);
        String tmp = "";
        for (byte aB : b) {
            // 整数转成十六进制表示
            tmp = (Integer.toHexString(aB & 0XFF));
            if (tmp.length() == 1) {
                sb.append("0");
            }
            sb.append(tmp);
        }
        return sb.toString().toUpperCase(); // 转成大写
    }

    private static byte[] hex2byte(String inputString) {
        if (inputString == null || inputString.length() < 2) {
            return new byte[0];
        }
        inputString = inputString.toLowerCase();
        int l = inputString.length() / 2;
        byte[] result = new byte[l];
        for (int i = 0; i < l; ++i) {
            String tmp = inputString.substring(2 * i, 2 * i + 2);
            result[i] = (byte) (Integer.parseInt(tmp, 16) & 0xFF);
        }
        return result;
    }

    /**
     * base64编码（方法二）
     * @explain Base64.java实现
     * @param str 待编码字符串
     * @return 编码字符串
     */
    public static String encode2(String str) {
        // 非空字符串才进行编码
        if (str != null && str.length() > 0) {
            // String 转 byte[]
            byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
            // 编码（base64字符串）
            return Base64.getEncoder().encodeToString(bytes);
        }
        return "";
    }

    /**
     * base64解码（方法二）
     * @explain Base64.java实现
     * @param base64Str 待解码字符串
     * @return 解码字符串
     */
    public static String decode2(String base64Str) {
        // 非空字符串才进行解码
        if (base64Str != null && base64Str.length() > 0) {
            // 编码
            byte[] base64Bytes = Base64.getDecoder().decode(base64Str);
            // byte[] 转 String（解码后的字符串）
            return new String(base64Bytes, StandardCharsets.UTF_8);
        }
        return "";
    }

    public static String encodeString(String word){
        String encodeString = null;
        try {
            encodeString = URLEncoder.encode(word, StandardCharsets.UTF_8.toString());
        } catch (UnsupportedEncodingException e) {
           return null;
        }
        return encodeString;
    }

}
