package com.digiwin.athena.aim.util;

import org.apache.commons.lang.BooleanUtils;
import org.springframework.data.redis.core.RedisTemplate;

import java.util.concurrent.TimeUnit;

public abstract class DistributeUtils {
    private static final long TOTAL_SLEEP = 200L;

    private static final long SLEEP_STEP = 50L;

    public static void tryLock30s(RedisTemplate redisTemplate, String lockName, Action action) {
        boolean isLocked = false;
        try {
            isLocked = tryLock(redisTemplate, lockName, 30L, TimeUnit.SECONDS);
        } catch (InterruptedException ex) {
            // 吃掉异常
            Thread.currentThread().interrupt();
        }

        if (isLocked) {
            try {
                action.action();
            } finally {
                releaseLock(redisTemplate, lockName);
            }
        }
    }

    public static boolean tryLock(RedisTemplate redisTemplate, String lockName, long expireTime, TimeUnit timeUnit) throws InterruptedException {
        long totalSleep = 0L;
        Boolean isLocked = redisTemplate.opsForValue().setIfAbsent(lockName, "lockV", expireTime, timeUnit);
        while ((null == isLocked || !isLocked) && totalSleep < TOTAL_SLEEP) {// 允许重试三次
            Thread.sleep(SLEEP_STEP);
            isLocked = redisTemplate.opsForValue().setIfAbsent(lockName, "lockV", expireTime, timeUnit);
            totalSleep += SLEEP_STEP;
        }

        return BooleanUtils.isTrue(isLocked);
    }

    public static void releaseLock(RedisTemplate redisTemplate, String lockName) {
        redisTemplate.delete(lockName);
    }

    public interface Action {
        void action();
    }
}
