package com.digiwin.athena.aim.util;

import java.util.Map;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class ScriptUtil {

    private ScriptEngineManager factory = new ScriptEngineManager();
    private ScriptEngine engine = factory.getEngineByName("nashorn");

    private static class ScriptEngineHolder {
        private static final ScriptUtil INSTANCE = new ScriptUtil();
    }

    private ScriptUtil() {
    }

    public static ScriptUtil getInstance() {
        return ScriptEngineHolder.INSTANCE;
    }


    /**
     *
     * @param scriptString
     * @param path  脚本路径
     * @param jsVariableMap
     * @return
     * @throws ScriptException
     */
    @SuppressWarnings("all")
    public Object JsEvaluator(String scriptString, String path, Map<String, Object> jsVariableMap) throws ScriptException {
        engine.put(path, jsVariableMap);
        return engine.eval(scriptString);
    }

}
