package com.digiwin.athena.aim.util;

import com.digiwin.athena.aim.domain.message.model.CiConstant;
import com.digiwin.athena.aim.api.dto.Page;
import com.digiwin.athena.appcore.exception.BusinessException;
import org.apache.commons.lang.StringUtils;

public abstract class ValidateUtils {
    public static void checkTenantId(String tenantId) {
        isTrue(StringUtils.isNotBlank(tenantId), "tenantId is blank");
    }

    public static void isTrue(boolean expression, String errorMsg) {
        if (!expression) {
            throw BusinessException.create(errorMsg);
        }
    }

    public static void checkPageParam(Page page) {
        if (null == page.getPageNum()) {
            page.setPageNum(CiConstant.DEFAULT_PAGE_NUM);
        } else if (0 > page.getPageNum()) {
            throw  BusinessException.create("pageNum must not be negative.");
        }

        if (null == page.getPageSize()) {
            page.setPageSize(CiConstant.DEFAULT_PAGE_SIZE);
        } else if (1 > page.getPageSize()) {
            throw BusinessException.create("pageSize must bigger than 0.");
        }
    }
}
