/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.api;

import com.digiwin.athena.aim.api.dto.AppExpireChangeDTO;
import com.digiwin.athena.aim.app.env.EnvProperties;
import com.digiwin.athena.aim.domain.message.service.AppExpireChangeService;
import com.digiwin.athena.aim.infrastructure.thememap.dto.TmAppExpireChangeComponentDTO;
import com.digiwin.athena.aim.infrastructure.thememap.service.ThemeMapService;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.stereotype.Component;

@Component
public class AppExpireChangeListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppExpireChangeListener.class);
    private static final String APP_CLEAN = "clean";
    private static final String COMPONENT_TYPE_PROJECT = "Project";
    private static final String COMPONENT_TYPE_Task = "Task";
    @Autowired
    private ThemeMapService themeMapService;
    @Autowired
    private AppExpireChangeService appExpireChangeService;
    @Autowired
    private EnvProperties envProperties;
    @Resource
    protected MongoTemplate msgMongoTemplate;
    private static final String MONGODB_COLLECTION_NAME = "AIM_ApiExpireChange_Log";

    @RabbitListener(bindings={@QueueBinding(value=@Queue(value="AIM_appExpireChangeQueue", durable="true", autoDelete="false"), exchange=@Exchange(value="appExpireChange", type="fanout"))})
    public void handleAppExpireChange(String data, Channel channel, @Header(value="amqp_deliveryTag") long tag) throws IOException {
        log.info("handleAppExpireChange-ATMC_appExpireChangeQueue-{}", (Object)data);
        Integer retryCount = 0;
        boolean successed = false;
        try {
            AppExpireChangeDTO appExpireChangeDTO;
            if (StringUtils.isNotBlank((String)data) && this.checkParam(appExpireChangeDTO = (AppExpireChangeDTO)JsonUtils.jsonToObject((String)data, AppExpireChangeDTO.class))) {
                log.info("handleAppExpireChange-{}", (Object)appExpireChangeDTO.toString());
                this.handleAppExpireChange(appExpireChangeDTO);
            }
            successed = true;
        }
        catch (Exception ex) {
            log.error("handleAppExpireChange-{}, consumer failed, error: {}", (Object)data, (Object)ex);
            successed = false;
            retryCount = this.getRetryCount(data, ex);
        }
        if (successed || retryCount >= this.envProperties.getAppExpireChangeMqRetryCount()) {
            channel.basicAck(tag, false);
        } else {
            channel.basicReject(tag, true);
        }
    }

    private Integer getRetryCount(String data, Exception exception) {
        Integer retryCount = 1;
        try {
            Object exceptionMessage = exception.toString();
            try {
                exceptionMessage = JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)exception), Map.class);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            int messageId = data.hashCode();
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"exception-message-id").is((Object)messageId));
            query.fields().include("exception-retry-count");
            Map log = (Map)this.msgMongoTemplate.findOne(query, Map.class, MONGODB_COLLECTION_NAME);
            if (log != null) {
                retryCount = (Integer)log.get("exception-retry-count");
                retryCount = retryCount + 1;
                query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is(log.get("_id")));
                Update update = new Update().set("exception-message", exceptionMessage).set("exception-retry-count", (Object)retryCount).set("exception-modify-time", (Object)LocalDateTime.now());
                this.msgMongoTemplate.updateFirst(query, (UpdateDefinition)update, MONGODB_COLLECTION_NAME);
            } else {
                log = (Map)JsonUtils.jsonToObject((String)data, Map.class);
                log.put("exception-message", exceptionMessage);
                log.put("exception-message-id", messageId);
                log.put("exception-retry-count", retryCount);
                log.put("exception-create-time", LocalDateTime.now());
                log.put("exception-modify-time", LocalDateTime.now());
                this.msgMongoTemplate.insert((Object)log, MONGODB_COLLECTION_NAME);
            }
        }
        catch (Exception ex) {
            log.error("handleAppExpireChange-{} save error log failed, error: {}", (Object)data, (Object)ex);
        }
        return retryCount;
    }

    private void handleAppExpireChange(AppExpireChangeDTO appExpireChangeDTO) {
        TmAppExpireChangeComponentDTO appExpireChangeProjectComponent = this.getAppExpireChangeProjectTaskComponent(appExpireChangeDTO);
        if (null != appExpireChangeProjectComponent) {
            log.info("handleAppExpireChange-{}", (Object)appExpireChangeProjectComponent.toString());
            switch (appExpireChangeDTO.getEventType()) {
                case "clean": {
                    this.appExpireChangeService.handleAppClean(appExpireChangeDTO.getTenantId(), appExpireChangeDTO.getAppCode(), appExpireChangeProjectComponent.getProject(), appExpireChangeProjectComponent.getTask());
                    break;
                }
                default: {
                    log.info("handleAppExpireChange-{}: Unsupported eventType", (Object)appExpireChangeDTO.toString());
                    break;
                }
            }
        } else {
            log.info("handleAppExpireChange-{}-{}", (Object)appExpireChangeDTO.toString(), (Object)"\u672a\u67e5\u8be2\u5230\u9879\u76ee\u5217\u8868");
        }
    }

    private TmAppExpireChangeComponentDTO getAppExpireChangeProjectTaskComponent(AppExpireChangeDTO appExpireChangeDTO) {
        TmAppExpireChangeComponentDTO tmAppExpireChangeComponentReq = new TmAppExpireChangeComponentDTO();
        tmAppExpireChangeComponentReq.setTenantId(appExpireChangeDTO.getTenantId());
        tmAppExpireChangeComponentReq.setEventType(appExpireChangeDTO.getEventType());
        tmAppExpireChangeComponentReq.setAppCode(appExpireChangeDTO.getAppCode());
        tmAppExpireChangeComponentReq.setComponent(Arrays.asList(COMPONENT_TYPE_PROJECT, COMPONENT_TYPE_Task));
        return this.themeMapService.getAppExpireChangeComponent(tmAppExpireChangeComponentReq);
    }

    private boolean checkParam(AppExpireChangeDTO appExpireChangeDTO) {
        return null != appExpireChangeDTO && StringUtils.isNotBlank((String)appExpireChangeDTO.getTenantId()) && StringUtils.isNotBlank((String)appExpireChangeDTO.getAppCode()) && StringUtils.isNotBlank((String)appExpireChangeDTO.getEventType());
    }
}

