/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.api;

import com.digiwin.athena.aim.api.dto.ChangeMsgStateDTO;
import com.digiwin.athena.aim.domain.message.model.MessageDO;
import com.digiwin.athena.aim.domain.message.model.MessageValidateGroup;
import com.digiwin.athena.aim.domain.message.service.MessageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/aim/v1"})
public class MessageController {
    @Autowired
    private MessageService messageService;

    @PostMapping(value={"/message", "/open/message"})
    public ResponseEntity<?> newMessage(@Validated(value={MessageValidateGroup.NewSingleMessage.class}) @RequestBody MessageDO messageDO) {
        return this.messageService.newMessage(messageDO);
    }

    @GetMapping(value={"/message/unread/count"})
    public ResponseEntity<?> getMsgUnreadCount(@RequestParam(value="importance", required=false) Integer importance, @RequestParam(value="channelType", required=false) String channelType) {
        return this.messageService.getMsgUnreadCount(importance, channelType);
    }

    @GetMapping(value={"/message/changed"})
    public ResponseEntity<?> getMsgChanged(@RequestParam(value="importance", required=false) Integer importance) {
        return this.messageService.getMsgChanged(importance);
    }

    @GetMapping(value={"/message/summary"})
    public ResponseEntity<?> getMsgSummary(@RequestParam(value="importance", required=false) Integer importance) {
        return this.messageService.getMsgSummary(importance);
    }

    @GetMapping(value={"/message/{subTypeCategory}/summary"})
    public ResponseEntity<?> getMsgSummaryBySubTypeCategory(@PathVariable(value="subTypeCategory") String subTypeCategory, @RequestParam(value="importance", required=false) Integer importance) {
        return this.messageService.getMsgSummaryBySubTypeCategory(subTypeCategory, importance);
    }

    @GetMapping(value={"/worknews/message/summary"})
    public ResponseEntity<?> getWorkNewsMsgSummary() {
        return this.messageService.getWorkNewsMsgSummary();
    }

    @PostMapping(value={"/message/read"})
    public ResponseEntity<?> changeStateToRead(@RequestBody ChangeMsgStateDTO changeMsgStateDTO) {
        return this.messageService.changeStateToRead(changeMsgStateDTO);
    }

    @PostMapping(value={"/message/read/delete"})
    public ResponseEntity<?> deleteReadMsg(@RequestBody ChangeMsgStateDTO changeMsgStateDTO) {
        return this.messageService.deleteReadMsg(changeMsgStateDTO);
    }
}

