/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.api;

import com.digiwin.athena.aim.api.dto.MessagePagingQryCommand;
import com.digiwin.athena.aim.api.dto.ReadMessageByBatchGidCommand;
import com.digiwin.athena.aim.api.dto.ReadMessageByGidCommand;
import com.digiwin.athena.aim.app.env.EnvProperties;
import com.digiwin.athena.aim.common.MessageChannelEnum;
import com.digiwin.athena.aim.domain.message.model.AppExpireMessageDO;
import com.digiwin.athena.aim.domain.message.model.ErrorCodeEnum;
import com.digiwin.athena.aim.domain.message.model.ExpireMessageReq;
import com.digiwin.athena.aim.domain.message.model.MessageBatchUserDTO;
import com.digiwin.athena.aim.domain.message.model.MsgAndEmailBatchDTO;
import com.digiwin.athena.aim.domain.message.model.SendCommonChannelMsgReq;
import com.digiwin.athena.aim.domain.message.service.MessageServiceV2;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import lombok.Generated;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/aim/v2"})
public class MessageControllerV2 {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageControllerV2.class);
    @Autowired
    private MessageServiceV2 messageServiceV2;
    @Resource
    private EnvProperties envProperties;
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    public static final int MESSAGE_PERSONNEL_COUNT_MAX = 1000;

    @GetMapping(value={"/message/removeMessageChannel"})
    public ResponseEntity<?> removeMessageChannel(String tenantId) {
        if (StringUtils.isNotBlank((String)tenantId)) {
            this.stringRedisTemplate.delete((Object)("aim:msg:channel:" + tenantId));
        }
        return ResponseEntityWrapper.wrapperOk();
    }

    @PostMapping(value={"/batch/user/message", "/open/batch/user/message"})
    public ResponseEntity<?> newMessageForBatchUsers(@Validated @RequestBody List<MessageBatchUserDTO> messageBatchUserList) {
        if (CollectionUtils.isNotEmpty(messageBatchUserList)) {
            this.messageServiceV2.newMessageForBatchUsers(messageBatchUserList);
        }
        return ResponseEntityWrapper.wrapperOk();
    }

    @PostMapping(value={"/message/summary"})
    public ResponseEntity<?> getMsgSummary(@RequestBody MessagePagingQryCommand command) {
        return this.messageServiceV2.pagingQueryMessage(command);
    }

    @GetMapping(value={"/message/summary/remove"})
    public ResponseEntity<?> summaryRemove(@RequestParam(value="channelType", required=false) String channelType) {
        return this.messageServiceV2.summaryRemove(channelType);
    }

    @PostMapping(value={"/message/read"})
    public ResponseEntity<?> readMessageByGid(@RequestBody ReadMessageByBatchGidCommand command) {
        return this.messageServiceV2.readMessageByGid(command.getGidList());
    }

    @GetMapping(value={"/message/readAll"})
    public ResponseEntity<?> readMessageAll(@RequestParam(value="channelType", required=false) String channelType) {
        return this.messageServiceV2.readMessageAll(channelType);
    }

    @PostMapping(value={"/message/read/detail"})
    public ResponseEntity<?> readMessageDetailByGid(@RequestBody ReadMessageByGidCommand command) {
        return this.messageServiceV2.readMessageDetailByGid(command.getGid());
    }

    @PostMapping(value={"/expire/message", "/open/expire/message"})
    public ResponseEntity<?> insertAppExpirationMessage(@Validated @RequestBody ExpireMessageReq expireMessageReq) {
        if (expireMessageReq.getUserIdList().stream().anyMatch(StringUtils::isBlank)) {
            return ResponseEntityWrapper.wrapperFail((int)500, (String)"userIdList cannot be empty");
        }
        this.messageServiceV2.insertAppExpirationMessage(expireMessageReq);
        return ResponseEntityWrapper.wrapperOk((Object)true);
    }

    @GetMapping(value={"/expire/list", "/open/expire/list"})
    public ResponseEntity<?> queryAppExpirationMessageList(@RequestParam(required=false) Integer platformFlag) {
        String uri = this.envProperties.getSpringProperties().getUri();
        String database = this.envProperties.getSpringProperties().getDatabase();
        log.info("MessageControllerV2 queryAppExpirationMessageList. uri:{}, database:{}", (Object)uri, (Object)database);
        return ResponseEntityWrapper.wrapperOk((Object)this.messageServiceV2.queryAppExpirationMessage(platformFlag));
    }

    @PostMapping(value={"/expire/renewal", "/open/expire/renewal"})
    public ResponseEntity<?> deleteAppExpirationMessage(@Validated @RequestBody AppExpireMessageDO appExpireMessageDO) {
        this.messageServiceV2.deleteAppExpirationMessage(appExpireMessageDO);
        return ResponseEntityWrapper.wrapperOk((Object)true);
    }

    @PostMapping(value={"/common/sendMessage", "/open/common/sendMessage"})
    @Deprecated
    public ResponseEntity<?> sendCommonChannelMsg(@Validated @RequestBody SendCommonChannelMsgReq sendCommonChannelMsgReq) {
        List dingTalkMsgList;
        List weComMsgList;
        List smsMsgList;
        List emailMsgList;
        JSONObject jsonObject = new JSONObject();
        if (CollectionUtils.isNotEmpty((Collection)sendCommonChannelMsgReq.getRemind())) {
            for (MessageBatchUserDTO messageBatchUserDTO : sendCommonChannelMsgReq.getRemind()) {
                if (messageBatchUserDTO.getUserIdList().size() <= 1000) continue;
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeEnum.FAIL.getErrCode(), (String)ErrorCodeEnum.FAIL.getErrMsg());
            }
            this.messageServiceV2.newMessageForBatchUsers(sendCommonChannelMsgReq.getRemind());
        }
        if (CollectionUtils.isNotEmpty((Collection)(emailMsgList = sendCommonChannelMsgReq.getEmail()))) {
            for (SendCommonChannelMsgReq.MsgInfoReq msgInfoReq : emailMsgList) {
                if (!(CollectionUtils.isNotEmpty((Collection)msgInfoReq.getUserIdList()) && msgInfoReq.getUserIdList().size() > 1000 || CollectionUtils.isNotEmpty((Collection)msgInfoReq.getCcUserIdList()) && msgInfoReq.getCcUserIdList().size() > 1000) && (!CollectionUtils.isNotEmpty((Collection)msgInfoReq.getBccUserIdList()) || msgInfoReq.getBccUserIdList().size() <= 1000)) continue;
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeEnum.FAIL.getErrCode(), (String)ErrorCodeEnum.FAIL.getErrMsg());
            }
            JSONObject emailJSONbject = this.messageServiceV2.sendCommonChannelMessage(MessageChannelEnum.EMAIL.getFlag(), emailMsgList);
            jsonObject.put((Object)"email", (Object)emailJSONbject);
        }
        if (CollectionUtils.isNotEmpty((Collection)(smsMsgList = sendCommonChannelMsgReq.getSms()))) {
            if (this.validNumberMax(smsMsgList)) {
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeEnum.FAIL.getErrCode(), (String)ErrorCodeEnum.FAIL.getErrMsg());
            }
            JSONObject smsJSONbject = this.messageServiceV2.sendCommonChannelMessage(MessageChannelEnum.SMS.getFlag(), smsMsgList);
            jsonObject.put((Object)"sms", (Object)smsJSONbject);
        }
        if (CollectionUtils.isNotEmpty((Collection)(weComMsgList = sendCommonChannelMsgReq.getWecom()))) {
            if (this.validNumberMax(weComMsgList)) {
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeEnum.FAIL.getErrCode(), (String)ErrorCodeEnum.FAIL.getErrMsg());
            }
            JSONObject wecomJSONbject = this.messageServiceV2.sendCommonChannelMessage(MessageChannelEnum.WECOM.getFlag(), weComMsgList);
            jsonObject.put((Object)"wecom", (Object)wecomJSONbject);
        }
        if (CollectionUtils.isNotEmpty((Collection)(dingTalkMsgList = sendCommonChannelMsgReq.getDingTalk()))) {
            if (this.validNumberMax(dingTalkMsgList)) {
                return ResponseEntityWrapper.wrapperFail((int)ErrorCodeEnum.FAIL.getErrCode(), (String)ErrorCodeEnum.FAIL.getErrMsg());
            }
            JSONObject dingTalkJSONbject = this.messageServiceV2.sendCommonChannelMessage(MessageChannelEnum.DINGTALK.getFlag(), dingTalkMsgList);
            jsonObject.put((Object)"dingTalk", (Object)dingTalkJSONbject);
        }
        return ResponseEntityWrapper.wrapperOk((Object)jsonObject);
    }

    private boolean validNumberMax(List<SendCommonChannelMsgReq.MsgInfoReq> smsMsgList) {
        for (SendCommonChannelMsgReq.MsgInfoReq msgInfoReq : smsMsgList) {
            if (!CollectionUtils.isNotEmpty((Collection)msgInfoReq.getUserIdList()) || msgInfoReq.getUserIdList().size() <= 1000) continue;
            return true;
        }
        return false;
    }

    @PostMapping(value={"/sendMsgAndEmail", "/open/sendMsgAndEmail"})
    public ResponseEntity<?> sendMsgAndEmail(@Validated @RequestBody List<MsgAndEmailBatchDTO> msgAndEmailBatchDTOList) {
        if (CollectionUtils.isNotEmpty(msgAndEmailBatchDTOList)) {
            this.messageServiceV2.sendMsgAndEmail(msgAndEmailBatchDTOList);
        }
        return ResponseEntityWrapper.wrapperOk();
    }
}

