/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.api;

import com.digiwin.athena.aim.domain.message.model.MessageBatchUserDTO;
import com.digiwin.athena.aim.domain.message.model.MessageDO;
import com.digiwin.athena.aim.domain.message.model.MessageRemindDTO;
import com.digiwin.athena.aim.domain.message.service.MessageSendService;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/aim/v2"})
public class MessageSendController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageSendController.class);
    @Autowired
    private MessageSendService messageSendService;

    @PostMapping(value={"/send/message/to/client"})
    public ResponseEntity sendToClient(@Validated @RequestBody MessageBatchUserDTO messageDTO) {
        for (String userId : messageDTO.getUserIdList()) {
            this.messageSendService.sendToClient(messageDTO.getTenantId(), userId, messageDTO.getMessage());
        }
        return ResponseEntityWrapper.wrapperOk();
    }

    @PostMapping(value={"/send/message/remind/to/client"})
    public ResponseEntity sendRemindToClient(@Validated @RequestBody MessageRemindDTO messageDTO) {
        this.messageSendService.sendMessageRemindToClient(messageDTO);
        return ResponseEntityWrapper.wrapperOk();
    }

    @PostMapping(value={"/batch/send/message/remind/to/client"})
    public ResponseEntity batchSendRemindToClient(@Validated @RequestBody List<MessageRemindDTO> messageList) {
        this.messageSendService.sendMessageRemindToClient(messageList);
        return ResponseEntityWrapper.wrapperOk();
    }

    @PostMapping(value={"/send/message/to/app/client/batch"})
    public ResponseEntity sendToAppClient(@Validated @RequestBody List<MessageBatchUserDTO> messageBatchUserList) {
        for (MessageBatchUserDTO messageBatchUserDTO : messageBatchUserList) {
            List userIdList = messageBatchUserDTO.getUserIdList();
            for (String userId : userIdList) {
                this.messageSendService.sendToAppClient(messageBatchUserDTO.getTenantId(), userId, messageBatchUserDTO.getMessage());
            }
        }
        return ResponseEntityWrapper.wrapperOk();
    }

    @PostMapping(value={"/send/message/to/app/client"})
    public ResponseEntity sendToAppClient(@Validated @RequestBody MessageDO message) {
        this.messageSendService.sendToAppClient(null, null, message);
        return ResponseEntityWrapper.wrapperOk();
    }
}

