/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.api;

import com.digiwin.athena.aim.domain.message.model.MessageTemplateDTO;
import com.digiwin.athena.aim.domain.message.service.MessageTemplateService;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/aim/template"})
public class MessageTemplateController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageTemplateController.class);
    @Autowired
    private MessageTemplateService messageTemplateService;

    @PostMapping(value={"/insert"})
    public ResponseEntity<?> insertMessageTemplate(@Validated @RequestBody MessageTemplateDTO MessageTemplateDTO2) {
        try {
            this.messageTemplateService.insertMessageTemplate(MessageTemplateDTO2);
            return ResponseEntityWrapper.wrapperOk();
        }
        catch (Exception e) {
            log.error("MessageTemplateController insert message template exception", (Throwable)e);
            return ResponseEntityWrapper.wrapperFail((int)1, (String)e.getMessage());
        }
    }

    @GetMapping(value={"/list"})
    public ResponseEntity<?> queryMessageTemplateList(@RequestParam(required=false) String templateCode) {
        try {
            List templateDTOList = this.messageTemplateService.queryMessageTemplateList(templateCode);
            return ResponseEntityWrapper.wrapperOk((Object)templateDTOList);
        }
        catch (Exception e) {
            log.error("MessageTemplateController query message template list exception", (Throwable)e);
            return ResponseEntityWrapper.wrapperFail((int)1, (String)e.getMessage());
        }
    }
}

