/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.app.config;

import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.encoder.Encoder;
import com.digiwin.dap.middleware.lmc.internal.LMCResourceUri;
import com.digiwin.dap.middleware.lmc.util.LogUtils;
import com.digiwin.dap.middleware.lmc.util.LoggingEventSizeUtil;
import com.digiwin.dap.middleware.lmc.util.ThreadPoolUtil;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.json.JSONArray;

public class DwLogbackAppender<E>
extends UnsynchronizedAppenderBase<E> {
    private SimpleDateFormat _sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static final String CUSTOM_CONTENT_KEY_SEPARATOR = ",";
    private static List<String> CUSTOM_CONTENT_KEY_LIST = new ArrayList();
    private static final int DEFAULT_PERIOD_MILL_SECONDS = 2;
    private static final int DEFAULT_BATCH_SIZE = 50;
    private static final Long DEFAULT_MAX_LOG_SIZE = 10240L;
    private static final Integer DEFAULT_THREAD_NUM = 5;
    private ScheduledExecutorService executor;
    private int consumeCount = 0;
    private Queue<Map<String, Object>> workQueue = new LinkedList();
    private CloseableHttpClient client;
    protected Encoder<E> encoder;
    private String userAgent = "logback";
    private Integer intervals;
    private Integer batchSize;
    private Long maxSingleLogSize;
    private String app;
    private String endpoint;
    private String customContentKey;

    public void start() {
        if (null == this.intervals) {
            this.intervals = 2;
        }
        if (null == this.batchSize) {
            this.batchSize = 50;
        }
        if (null == this.maxSingleLogSize) {
            this.maxSingleLogSize = DEFAULT_MAX_LOG_SIZE;
        }
        if (null != this.customContentKey && this.customContentKey.length() != 0) {
            CUSTOM_CONTENT_KEY_LIST = Arrays.asList(this.customContentKey.split(CUSTOM_CONTENT_KEY_SEPARATOR));
        }
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(5000).setSocketTimeout(5000).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setMaxTotal(4);
        connectionManager.setDefaultMaxPerRoute(4);
        connectionManager.setValidateAfterInactivity(2000);
        this.client = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)connectionManager).build();
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.executor.scheduleAtFixedRate(() -> {
            DwLogbackAppender dwLogbackAppender = this;
            synchronized (dwLogbackAppender) {
                if (!this.workQueue.isEmpty()) {
                    LinkedList<Map> logList = new LinkedList<Map>();
                    for (Map element : this.workQueue) {
                        logList.add(element);
                    }
                    this.asyncPersistence(logList);
                    this.consumeCount = 0;
                    this.workQueue.clear();
                }
            }
        }, 0L, this.intervals.intValue(), TimeUnit.SECONDS);
        super.start();
    }

    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        LinkedList<Map> logList = new LinkedList<Map>();
        for (Map element : this.workQueue) {
            logList.add(element);
        }
        this.asyncPersistence(logList);
        this.executor.shutdown();
        super.stop();
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (IOException exception) {
                this.addError(exception.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(E eventObject) {
        DwLogbackAppender dwLogbackAppender = this;
        synchronized (dwLogbackAppender) {
            while (this.workQueue.size() > this.batchSize) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            Map map = this.convertLoggingEventToMap(eventObject);
            if ((long)LoggingEventSizeUtil.getSize((Object)map) >= this.maxSingleLogSize * 1024L) {
                List<Map> log = Arrays.asList(map);
                this.asyncPersistence(log);
                this.workQueue.clear();
                this.consumeCount = 0;
            }
            if (Objects.nonNull(map)) {
                this.workQueue.offer(map);
                this.notifyAll();
                ++this.consumeCount;
            }
            if (this.consumeCount >= this.batchSize) {
                LinkedList<Map> logList = new LinkedList<Map>();
                for (Map element : this.workQueue) {
                    logList.add(element);
                }
                this.asyncPersistence(logList);
                this.workQueue.clear();
                this.consumeCount = 0;
            }
        }
    }

    private void asyncPersistence(List<Map<String, Object>> logList) {
        ThreadPoolUtil.executor(() -> {
            if (null == logList || logList.isEmpty()) {
                return;
            }
            CloseableHttpResponse hResponse = null;
            HttpPost postMethod = new HttpPost(LMCResourceUri.getSaveDevLogBatchUrl((String)this.endpoint));
            try {
                JSONArray jsonArray = new JSONArray((Collection)logList);
                String formatValue = jsonArray.toString();
                postMethod.setEntity((HttpEntity)new StringEntity(formatValue, ContentType.APPLICATION_JSON));
                hResponse = this.client.execute((HttpUriRequest)postMethod);
                HttpEntity repEntity = hResponse.getEntity();
                int statusCode = hResponse.getStatusLine().getStatusCode();
                if (statusCode != 200) {
                    postMethod.abort();
                }
            }
            catch (Exception e) {
                this.addError(e.getMessage());
            }
            finally {
                if (hResponse != null) {
                    try {
                        hResponse.close();
                    }
                    catch (IOException e) {
                        this.addError(e.getMessage());
                    }
                }
            }
        });
    }

    private Map<String, Object> convertLoggingEventToMap(E eventObject) {
        String traceId;
        if (!(eventObject instanceof LoggingEvent)) {
            return null;
        }
        LoggingEvent event = (LoggingEvent)eventObject;
        HashMap<String, Object> logMap = new HashMap<String, Object>();
        Map mdcPropertyMap = event.getMDCPropertyMap();
        if (!mdcPropertyMap.isEmpty()) {
            String ptxId = (String)mdcPropertyMap.get("PtxId");
            traceId = ptxId != null && !"".equals(ptxId) ? ptxId : LogUtils.getUUID();
            HashMap customContent = new HashMap();
            CUSTOM_CONTENT_KEY_LIST.forEach(key -> {
                if (Objects.nonNull(mdcPropertyMap.get(key))) {
                    customContent.put(key, mdcPropertyMap.get(key));
                }
            });
            logMap.put("customContent", customContent);
        } else {
            traceId = LogUtils.getUUID();
        }
        logMap.putIfAbsent("traceId", traceId);
        HashMap initMap = new HashMap();
        LogUtils.initLogMap(initMap);
        logMap.putAll(initMap);
        logMap.putIfAbsent("appId", this.getApp());
        logMap.putIfAbsent("time", this._sdf.format(new Date(event.getTimeStamp())));
        logMap.putIfAbsent("level", event.getLevel().toString());
        logMap.putIfAbsent("thread", event.getThreadName());
        logMap.putIfAbsent("loggerName", event.getLoggerName());
        String addr = LogUtils.getLocalHostIpName();
        logMap.putIfAbsent("source", addr);
        logMap.putIfAbsent("appender", "DwLogbackAppender");
        StackTraceElement[] caller = event.getCallerData();
        if (caller != null && caller.length > 0) {
            logMap.putIfAbsent("location", caller[0].toString());
        }
        String message = event.getFormattedMessage();
        logMap.putIfAbsent("message", message);
        IThrowableProxy iThrowableProxy = event.getThrowableProxy();
        if (iThrowableProxy != null) {
            StringBuilder builder = new StringBuilder();
            String throwableProxyClassName = iThrowableProxy.getClassName();
            String throwableProxyMessage = iThrowableProxy.getMessage();
            String throwable = throwableProxyMessage != null ? throwableProxyClassName + ": " + throwableProxyMessage : throwableProxyClassName;
            builder.append(throwable);
            for (StackTraceElementProxy step : event.getThrowableProxy().getStackTraceElementProxyArray()) {
                builder.append(CoreConstants.LINE_SEPARATOR);
                String string = step.toString();
                builder.append('\t').append(string);
                ThrowableProxyUtil.subjoinPackagingData((StringBuilder)builder, (StackTraceElementProxy)step);
            }
            logMap.putIfAbsent("throwable", builder.toString());
        }
        if (this.encoder != null) {
            logMap.putIfAbsent("log", new String(this.encoder.encode(eventObject)));
        }
        return logMap;
    }

    public String getApp() {
        return this.app;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public Integer getIntervals() {
        return this.intervals;
    }

    public void setIntervals(Integer intervals) {
        this.intervals = intervals;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public Long getMaxSingleLogSize() {
        return this.maxSingleLogSize;
    }

    public void setMaxSingleLogSize(Long maxSingleLogSize) {
        this.maxSingleLogSize = maxSingleLogSize;
    }

    public String getCustomContentKey() {
        return this.customContentKey;
    }

    public void setCustomContentKey(String customContentKey) {
        this.customContentKey = customContentKey;
    }

    public Encoder<E> getEncoder() {
        return this.encoder;
    }

    public void setEncoder(Encoder<E> encoder) {
        this.encoder = encoder;
    }
}

