/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.app.env;

import com.digiwin.athena.aim.infrastructure.mobile.MobileProperties;
import com.digiwin.athena.aim.infrastructure.mobile.SpringProperties;
import com.digiwin.athena.aim.infrastructure.mqtt.MqttProperties;
import com.digiwin.athena.appcore.AppCoreProperties;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Configuration
@JsonIgnoreProperties(value={"$$beanFactory"})
public class EnvProperties {
    private static final Logger logger = LoggerFactory.getLogger(EnvProperties.class);
    @Autowired
    private AppCoreProperties appCoreProperties;
    @Autowired
    private MobileProperties mobileProperties;
    @Autowired
    private SpringProperties springProperties;
    @Autowired
    private MqttProperties mqttConfiguration;
    @Value(value="${app.version:}")
    private String version;
    @Value(value="${app.build.time}")
    private String buildTime;
    @Value(value="${spring.profiles.active:dev}")
    private String active;
    @Value(value="${server.port}")
    private String port;
    @Value(value="${knowledgegraph.uri:}")
    private String knowledgegraphUri;
    private boolean espMockData;
    private boolean espGatheringESPData;
    private int appExpireChangeMqRetryCount = 10;
    @Value(value="${iam.uri:}")
    private String iamUri;
    @Value(value="${emc.uri:}")
    private String emcUri;
    @Value(value="${eoc.uri:}")
    private String eocUri;
    @Value(value="${atmc.uri:}")
    private String atmcUri;
    @Value(value="${semc.uri:}")
    private String semcUri;
    @Value(value="${athenaDd.uri:}")
    private String athenaDdUri;
    @Value(value="${athenaMobile.uri:}")
    private String athenaMobileUri;
    @Value(value="${pcAddress.uri:}")
    private String pcAddressUri;
    @Value(value="${dingding.athenaAppToken:}")
    private String appToken;
    @Value(value="${dingding.noticeEventId:}")
    private String noticeEventId;
    @Value(value="${asa.wecomNoticeSuiteId:}")
    private String nanaSuiteId;
    @Value(value="${asa.wecomNoticeEventId:}")
    private String wecomNoticeEventId;
    @Value(value="${asa.dingNoticeEventId:}")
    private String asaNoticeEventId;
    @Value(value="${ania-web.uri:}")
    private String aniaWebAddressUri;
    @Value(value="${ania.uri:}")
    private String aniaAddressUri;
    @Value(value="${asa.lineLiffUrl}")
    private String asaLineUrl;
    @Value(value="${asa.lineNoticeEventId}")
    private String lineNoticeEventId;
    @Value(value="${trans.uri:}")
    private String transUri;
    @Value(value="${language.default:}")
    private String defaultLang;
    private String host;
    private String ipAddress;
    private long freeMemory;
    private long totalMemory;
    private long maxMemory;
    private String osName;
    private long pid;
    private LocalDateTime startTime;
    private String classPath;
    private String projectPath;
    private long runtime;
    private int threadCount;

    static long byteToM(long bytes) {
        long kb = bytes / 1024L / 1024L;
        return kb;
    }

    static long tryGetPid() {
        try {
            String name = ManagementFactory.getRuntimeMXBean().getName();
            String pid = name.split("@")[0];
            return Long.parseLong(pid);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public void refresh() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        Runtime runtime = Runtime.getRuntime();
        long freeMemory = runtime.freeMemory();
        this.setFreeMemory(EnvProperties.byteToM((long)freeMemory));
        long totalMemory = runtime.totalMemory();
        this.setTotalMemory(EnvProperties.byteToM((long)totalMemory));
        long maxMemory = runtime.maxMemory();
        this.setMaxMemory(EnvProperties.byteToM((long)maxMemory));
        this.setOsName(System.getProperty("os.name"));
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            String hostName = localHost.getHostName();
            this.setHost(hostName);
            if (this.ipAddress == null) {
                this.ipAddress = localHost.getHostAddress();
            }
        }
        catch (UnknownHostException e) {
            logger.error("UnknownHostException", (Throwable)e);
            this.setHost("\u672a\u77e5");
        }
        this.setIpAddress(this.ipAddress);
        long startTime = runtimeMXBean.getStartTime();
        LocalDateTime startDate = Instant.ofEpochMilli(startTime).atZone(ZoneOffset.ofHours(8)).toLocalDateTime();
        this.setStartTime(startDate);
        this.setRuntime(runtimeMXBean.getUptime());
        this.setThreadCount(ManagementFactory.getThreadMXBean().getThreadCount());
        this.setPid(EnvProperties.tryGetPid());
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getBuildTime() {
        return this.buildTime;
    }

    public void setBuildTime(String buildTime) {
        this.buildTime = buildTime;
    }

    public String getActive() {
        return this.active;
    }

    public void setActive(String active) {
        this.active = active;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getIamUri() {
        return this.iamUri;
    }

    public void setIamUri(String iamUri) {
        this.iamUri = iamUri;
    }

    public String getNoticeEventId() {
        return this.noticeEventId;
    }

    public void setNoticeEventId(String noticeEventId) {
        this.noticeEventId = noticeEventId;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public long getFreeMemory() {
        return this.freeMemory;
    }

    public void setFreeMemory(long freeMemory) {
        this.freeMemory = freeMemory;
    }

    public long getTotalMemory() {
        return this.totalMemory;
    }

    public void setTotalMemory(long totalMemory) {
        this.totalMemory = totalMemory;
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public void setMaxMemory(long maxMemory) {
        this.maxMemory = maxMemory;
    }

    public String getOsName() {
        return this.osName;
    }

    public void setOsName(String osName) {
        this.osName = osName;
    }

    public long getPid() {
        return this.pid;
    }

    public void setPid(long pid) {
        this.pid = pid;
    }

    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(LocalDateTime startTime) {
        this.startTime = startTime;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public void setClassPath(String classPath) {
        this.classPath = classPath;
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public void setProjectPath(String projectPath) {
        this.projectPath = projectPath;
    }

    public long getRuntime() {
        return this.runtime;
    }

    public void setRuntime(long runtime) {
        this.runtime = runtime;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public String getEmcUri() {
        return this.emcUri;
    }

    public void setEmcUri(String emcUri) {
        this.emcUri = emcUri;
    }

    public String getAtmcUri() {
        return this.atmcUri;
    }

    public void setAtmcUri(String atmcUri) {
        this.atmcUri = atmcUri;
    }

    public String getAthenaDdUri() {
        return this.athenaDdUri;
    }

    public void setAthenaDdUri(String athenaDdUri) {
        this.athenaDdUri = athenaDdUri;
    }

    @Generated
    public AppCoreProperties getAppCoreProperties() {
        return this.appCoreProperties;
    }

    @Generated
    public MobileProperties getMobileProperties() {
        return this.mobileProperties;
    }

    @Generated
    public SpringProperties getSpringProperties() {
        return this.springProperties;
    }

    @Generated
    public MqttProperties getMqttConfiguration() {
        return this.mqttConfiguration;
    }

    @Generated
    public String getKnowledgegraphUri() {
        return this.knowledgegraphUri;
    }

    @Generated
    public boolean isEspMockData() {
        return this.espMockData;
    }

    @Generated
    public boolean isEspGatheringESPData() {
        return this.espGatheringESPData;
    }

    @Generated
    public int getAppExpireChangeMqRetryCount() {
        return this.appExpireChangeMqRetryCount;
    }

    @Generated
    public String getEocUri() {
        return this.eocUri;
    }

    @Generated
    public String getSemcUri() {
        return this.semcUri;
    }

    @Generated
    public String getAthenaMobileUri() {
        return this.athenaMobileUri;
    }

    @Generated
    public String getPcAddressUri() {
        return this.pcAddressUri;
    }

    @Generated
    public String getAppToken() {
        return this.appToken;
    }

    @Generated
    public String getNanaSuiteId() {
        return this.nanaSuiteId;
    }

    @Generated
    public String getWecomNoticeEventId() {
        return this.wecomNoticeEventId;
    }

    @Generated
    public String getAsaNoticeEventId() {
        return this.asaNoticeEventId;
    }

    @Generated
    public String getAniaWebAddressUri() {
        return this.aniaWebAddressUri;
    }

    @Generated
    public String getAniaAddressUri() {
        return this.aniaAddressUri;
    }

    @Generated
    public String getAsaLineUrl() {
        return this.asaLineUrl;
    }

    @Generated
    public String getLineNoticeEventId() {
        return this.lineNoticeEventId;
    }

    @Generated
    public String getTransUri() {
        return this.transUri;
    }

    @Generated
    public String getDefaultLang() {
        return this.defaultLang;
    }

    @Generated
    public void setAppCoreProperties(AppCoreProperties appCoreProperties) {
        this.appCoreProperties = appCoreProperties;
    }

    @Generated
    public void setMobileProperties(MobileProperties mobileProperties) {
        this.mobileProperties = mobileProperties;
    }

    @Generated
    public void setSpringProperties(SpringProperties springProperties) {
        this.springProperties = springProperties;
    }

    @Generated
    public void setMqttConfiguration(MqttProperties mqttConfiguration) {
        this.mqttConfiguration = mqttConfiguration;
    }

    @Generated
    public void setKnowledgegraphUri(String knowledgegraphUri) {
        this.knowledgegraphUri = knowledgegraphUri;
    }

    @Generated
    public void setEspMockData(boolean espMockData) {
        this.espMockData = espMockData;
    }

    @Generated
    public void setEspGatheringESPData(boolean espGatheringESPData) {
        this.espGatheringESPData = espGatheringESPData;
    }

    @Generated
    public void setAppExpireChangeMqRetryCount(int appExpireChangeMqRetryCount) {
        this.appExpireChangeMqRetryCount = appExpireChangeMqRetryCount;
    }

    @Generated
    public void setEocUri(String eocUri) {
        this.eocUri = eocUri;
    }

    @Generated
    public void setSemcUri(String semcUri) {
        this.semcUri = semcUri;
    }

    @Generated
    public void setAthenaMobileUri(String athenaMobileUri) {
        this.athenaMobileUri = athenaMobileUri;
    }

    @Generated
    public void setPcAddressUri(String pcAddressUri) {
        this.pcAddressUri = pcAddressUri;
    }

    @Generated
    public void setAppToken(String appToken) {
        this.appToken = appToken;
    }

    @Generated
    public void setNanaSuiteId(String nanaSuiteId) {
        this.nanaSuiteId = nanaSuiteId;
    }

    @Generated
    public void setWecomNoticeEventId(String wecomNoticeEventId) {
        this.wecomNoticeEventId = wecomNoticeEventId;
    }

    @Generated
    public void setAsaNoticeEventId(String asaNoticeEventId) {
        this.asaNoticeEventId = asaNoticeEventId;
    }

    @Generated
    public void setAniaWebAddressUri(String aniaWebAddressUri) {
        this.aniaWebAddressUri = aniaWebAddressUri;
    }

    @Generated
    public void setAniaAddressUri(String aniaAddressUri) {
        this.aniaAddressUri = aniaAddressUri;
    }

    @Generated
    public void setAsaLineUrl(String asaLineUrl) {
        this.asaLineUrl = asaLineUrl;
    }

    @Generated
    public void setLineNoticeEventId(String lineNoticeEventId) {
        this.lineNoticeEventId = lineNoticeEventId;
    }

    @Generated
    public void setTransUri(String transUri) {
        this.transUri = transUri;
    }

    @Generated
    public void setDefaultLang(String defaultLang) {
        this.defaultLang = defaultLang;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EnvProperties)) {
            return false;
        }
        EnvProperties other = (EnvProperties)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isEspMockData() != other.isEspMockData()) {
            return false;
        }
        if (this.isEspGatheringESPData() != other.isEspGatheringESPData()) {
            return false;
        }
        if (this.getAppExpireChangeMqRetryCount() != other.getAppExpireChangeMqRetryCount()) {
            return false;
        }
        if (this.getFreeMemory() != other.getFreeMemory()) {
            return false;
        }
        if (this.getTotalMemory() != other.getTotalMemory()) {
            return false;
        }
        if (this.getMaxMemory() != other.getMaxMemory()) {
            return false;
        }
        if (this.getPid() != other.getPid()) {
            return false;
        }
        if (this.getRuntime() != other.getRuntime()) {
            return false;
        }
        if (this.getThreadCount() != other.getThreadCount()) {
            return false;
        }
        AppCoreProperties this$appCoreProperties = this.getAppCoreProperties();
        AppCoreProperties other$appCoreProperties = other.getAppCoreProperties();
        if (this$appCoreProperties == null ? other$appCoreProperties != null : !this$appCoreProperties.equals(other$appCoreProperties)) {
            return false;
        }
        MobileProperties this$mobileProperties = this.getMobileProperties();
        MobileProperties other$mobileProperties = other.getMobileProperties();
        if (this$mobileProperties == null ? other$mobileProperties != null : !this$mobileProperties.equals(other$mobileProperties)) {
            return false;
        }
        SpringProperties this$springProperties = this.getSpringProperties();
        SpringProperties other$springProperties = other.getSpringProperties();
        if (this$springProperties == null ? other$springProperties != null : !this$springProperties.equals(other$springProperties)) {
            return false;
        }
        MqttProperties this$mqttConfiguration = this.getMqttConfiguration();
        MqttProperties other$mqttConfiguration = other.getMqttConfiguration();
        if (this$mqttConfiguration == null ? other$mqttConfiguration != null : !this$mqttConfiguration.equals(other$mqttConfiguration)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$buildTime = this.getBuildTime();
        String other$buildTime = other.getBuildTime();
        if (this$buildTime == null ? other$buildTime != null : !this$buildTime.equals(other$buildTime)) {
            return false;
        }
        String this$active = this.getActive();
        String other$active = other.getActive();
        if (this$active == null ? other$active != null : !this$active.equals(other$active)) {
            return false;
        }
        String this$port = this.getPort();
        String other$port = other.getPort();
        if (this$port == null ? other$port != null : !this$port.equals(other$port)) {
            return false;
        }
        String this$knowledgegraphUri = this.getKnowledgegraphUri();
        String other$knowledgegraphUri = other.getKnowledgegraphUri();
        if (this$knowledgegraphUri == null ? other$knowledgegraphUri != null : !this$knowledgegraphUri.equals(other$knowledgegraphUri)) {
            return false;
        }
        String this$iamUri = this.getIamUri();
        String other$iamUri = other.getIamUri();
        if (this$iamUri == null ? other$iamUri != null : !this$iamUri.equals(other$iamUri)) {
            return false;
        }
        String this$emcUri = this.getEmcUri();
        String other$emcUri = other.getEmcUri();
        if (this$emcUri == null ? other$emcUri != null : !this$emcUri.equals(other$emcUri)) {
            return false;
        }
        String this$eocUri = this.getEocUri();
        String other$eocUri = other.getEocUri();
        if (this$eocUri == null ? other$eocUri != null : !this$eocUri.equals(other$eocUri)) {
            return false;
        }
        String this$atmcUri = this.getAtmcUri();
        String other$atmcUri = other.getAtmcUri();
        if (this$atmcUri == null ? other$atmcUri != null : !this$atmcUri.equals(other$atmcUri)) {
            return false;
        }
        String this$semcUri = this.getSemcUri();
        String other$semcUri = other.getSemcUri();
        if (this$semcUri == null ? other$semcUri != null : !this$semcUri.equals(other$semcUri)) {
            return false;
        }
        String this$athenaDdUri = this.getAthenaDdUri();
        String other$athenaDdUri = other.getAthenaDdUri();
        if (this$athenaDdUri == null ? other$athenaDdUri != null : !this$athenaDdUri.equals(other$athenaDdUri)) {
            return false;
        }
        String this$athenaMobileUri = this.getAthenaMobileUri();
        String other$athenaMobileUri = other.getAthenaMobileUri();
        if (this$athenaMobileUri == null ? other$athenaMobileUri != null : !this$athenaMobileUri.equals(other$athenaMobileUri)) {
            return false;
        }
        String this$pcAddressUri = this.getPcAddressUri();
        String other$pcAddressUri = other.getPcAddressUri();
        if (this$pcAddressUri == null ? other$pcAddressUri != null : !this$pcAddressUri.equals(other$pcAddressUri)) {
            return false;
        }
        String this$appToken = this.getAppToken();
        String other$appToken = other.getAppToken();
        if (this$appToken == null ? other$appToken != null : !this$appToken.equals(other$appToken)) {
            return false;
        }
        String this$noticeEventId = this.getNoticeEventId();
        String other$noticeEventId = other.getNoticeEventId();
        if (this$noticeEventId == null ? other$noticeEventId != null : !this$noticeEventId.equals(other$noticeEventId)) {
            return false;
        }
        String this$nanaSuiteId = this.getNanaSuiteId();
        String other$nanaSuiteId = other.getNanaSuiteId();
        if (this$nanaSuiteId == null ? other$nanaSuiteId != null : !this$nanaSuiteId.equals(other$nanaSuiteId)) {
            return false;
        }
        String this$wecomNoticeEventId = this.getWecomNoticeEventId();
        String other$wecomNoticeEventId = other.getWecomNoticeEventId();
        if (this$wecomNoticeEventId == null ? other$wecomNoticeEventId != null : !this$wecomNoticeEventId.equals(other$wecomNoticeEventId)) {
            return false;
        }
        String this$asaNoticeEventId = this.getAsaNoticeEventId();
        String other$asaNoticeEventId = other.getAsaNoticeEventId();
        if (this$asaNoticeEventId == null ? other$asaNoticeEventId != null : !this$asaNoticeEventId.equals(other$asaNoticeEventId)) {
            return false;
        }
        String this$aniaWebAddressUri = this.getAniaWebAddressUri();
        String other$aniaWebAddressUri = other.getAniaWebAddressUri();
        if (this$aniaWebAddressUri == null ? other$aniaWebAddressUri != null : !this$aniaWebAddressUri.equals(other$aniaWebAddressUri)) {
            return false;
        }
        String this$aniaAddressUri = this.getAniaAddressUri();
        String other$aniaAddressUri = other.getAniaAddressUri();
        if (this$aniaAddressUri == null ? other$aniaAddressUri != null : !this$aniaAddressUri.equals(other$aniaAddressUri)) {
            return false;
        }
        String this$asaLineUrl = this.getAsaLineUrl();
        String other$asaLineUrl = other.getAsaLineUrl();
        if (this$asaLineUrl == null ? other$asaLineUrl != null : !this$asaLineUrl.equals(other$asaLineUrl)) {
            return false;
        }
        String this$lineNoticeEventId = this.getLineNoticeEventId();
        String other$lineNoticeEventId = other.getLineNoticeEventId();
        if (this$lineNoticeEventId == null ? other$lineNoticeEventId != null : !this$lineNoticeEventId.equals(other$lineNoticeEventId)) {
            return false;
        }
        String this$transUri = this.getTransUri();
        String other$transUri = other.getTransUri();
        if (this$transUri == null ? other$transUri != null : !this$transUri.equals(other$transUri)) {
            return false;
        }
        String this$defaultLang = this.getDefaultLang();
        String other$defaultLang = other.getDefaultLang();
        if (this$defaultLang == null ? other$defaultLang != null : !this$defaultLang.equals(other$defaultLang)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$ipAddress = this.getIpAddress();
        String other$ipAddress = other.getIpAddress();
        if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
            return false;
        }
        String this$osName = this.getOsName();
        String other$osName = other.getOsName();
        if (this$osName == null ? other$osName != null : !this$osName.equals(other$osName)) {
            return false;
        }
        LocalDateTime this$startTime = this.getStartTime();
        LocalDateTime other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        String this$classPath = this.getClassPath();
        String other$classPath = other.getClassPath();
        if (this$classPath == null ? other$classPath != null : !this$classPath.equals(other$classPath)) {
            return false;
        }
        String this$projectPath = this.getProjectPath();
        String other$projectPath = other.getProjectPath();
        return !(this$projectPath == null ? other$projectPath != null : !this$projectPath.equals(other$projectPath));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EnvProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEspMockData() ? 79 : 97);
        result = result * 59 + (this.isEspGatheringESPData() ? 79 : 97);
        result = result * 59 + this.getAppExpireChangeMqRetryCount();
        long $freeMemory = this.getFreeMemory();
        result = result * 59 + (int)($freeMemory >>> 32 ^ $freeMemory);
        long $totalMemory = this.getTotalMemory();
        result = result * 59 + (int)($totalMemory >>> 32 ^ $totalMemory);
        long $maxMemory = this.getMaxMemory();
        result = result * 59 + (int)($maxMemory >>> 32 ^ $maxMemory);
        long $pid = this.getPid();
        result = result * 59 + (int)($pid >>> 32 ^ $pid);
        long $runtime = this.getRuntime();
        result = result * 59 + (int)($runtime >>> 32 ^ $runtime);
        result = result * 59 + this.getThreadCount();
        AppCoreProperties $appCoreProperties = this.getAppCoreProperties();
        result = result * 59 + ($appCoreProperties == null ? 43 : $appCoreProperties.hashCode());
        MobileProperties $mobileProperties = this.getMobileProperties();
        result = result * 59 + ($mobileProperties == null ? 43 : $mobileProperties.hashCode());
        SpringProperties $springProperties = this.getSpringProperties();
        result = result * 59 + ($springProperties == null ? 43 : $springProperties.hashCode());
        MqttProperties $mqttConfiguration = this.getMqttConfiguration();
        result = result * 59 + ($mqttConfiguration == null ? 43 : $mqttConfiguration.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $buildTime = this.getBuildTime();
        result = result * 59 + ($buildTime == null ? 43 : $buildTime.hashCode());
        String $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : $active.hashCode());
        String $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : $port.hashCode());
        String $knowledgegraphUri = this.getKnowledgegraphUri();
        result = result * 59 + ($knowledgegraphUri == null ? 43 : $knowledgegraphUri.hashCode());
        String $iamUri = this.getIamUri();
        result = result * 59 + ($iamUri == null ? 43 : $iamUri.hashCode());
        String $emcUri = this.getEmcUri();
        result = result * 59 + ($emcUri == null ? 43 : $emcUri.hashCode());
        String $eocUri = this.getEocUri();
        result = result * 59 + ($eocUri == null ? 43 : $eocUri.hashCode());
        String $atmcUri = this.getAtmcUri();
        result = result * 59 + ($atmcUri == null ? 43 : $atmcUri.hashCode());
        String $semcUri = this.getSemcUri();
        result = result * 59 + ($semcUri == null ? 43 : $semcUri.hashCode());
        String $athenaDdUri = this.getAthenaDdUri();
        result = result * 59 + ($athenaDdUri == null ? 43 : $athenaDdUri.hashCode());
        String $athenaMobileUri = this.getAthenaMobileUri();
        result = result * 59 + ($athenaMobileUri == null ? 43 : $athenaMobileUri.hashCode());
        String $pcAddressUri = this.getPcAddressUri();
        result = result * 59 + ($pcAddressUri == null ? 43 : $pcAddressUri.hashCode());
        String $appToken = this.getAppToken();
        result = result * 59 + ($appToken == null ? 43 : $appToken.hashCode());
        String $noticeEventId = this.getNoticeEventId();
        result = result * 59 + ($noticeEventId == null ? 43 : $noticeEventId.hashCode());
        String $nanaSuiteId = this.getNanaSuiteId();
        result = result * 59 + ($nanaSuiteId == null ? 43 : $nanaSuiteId.hashCode());
        String $wecomNoticeEventId = this.getWecomNoticeEventId();
        result = result * 59 + ($wecomNoticeEventId == null ? 43 : $wecomNoticeEventId.hashCode());
        String $asaNoticeEventId = this.getAsaNoticeEventId();
        result = result * 59 + ($asaNoticeEventId == null ? 43 : $asaNoticeEventId.hashCode());
        String $aniaWebAddressUri = this.getAniaWebAddressUri();
        result = result * 59 + ($aniaWebAddressUri == null ? 43 : $aniaWebAddressUri.hashCode());
        String $aniaAddressUri = this.getAniaAddressUri();
        result = result * 59 + ($aniaAddressUri == null ? 43 : $aniaAddressUri.hashCode());
        String $asaLineUrl = this.getAsaLineUrl();
        result = result * 59 + ($asaLineUrl == null ? 43 : $asaLineUrl.hashCode());
        String $lineNoticeEventId = this.getLineNoticeEventId();
        result = result * 59 + ($lineNoticeEventId == null ? 43 : $lineNoticeEventId.hashCode());
        String $transUri = this.getTransUri();
        result = result * 59 + ($transUri == null ? 43 : $transUri.hashCode());
        String $defaultLang = this.getDefaultLang();
        result = result * 59 + ($defaultLang == null ? 43 : $defaultLang.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $ipAddress = this.getIpAddress();
        result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
        String $osName = this.getOsName();
        result = result * 59 + ($osName == null ? 43 : $osName.hashCode());
        LocalDateTime $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        String $classPath = this.getClassPath();
        result = result * 59 + ($classPath == null ? 43 : $classPath.hashCode());
        String $projectPath = this.getProjectPath();
        result = result * 59 + ($projectPath == null ? 43 : $projectPath.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EnvProperties(appCoreProperties=" + this.getAppCoreProperties() + ", mobileProperties=" + this.getMobileProperties() + ", springProperties=" + this.getSpringProperties() + ", mqttConfiguration=" + this.getMqttConfiguration() + ", version=" + this.getVersion() + ", buildTime=" + this.getBuildTime() + ", active=" + this.getActive() + ", port=" + this.getPort() + ", knowledgegraphUri=" + this.getKnowledgegraphUri() + ", espMockData=" + this.isEspMockData() + ", espGatheringESPData=" + this.isEspGatheringESPData() + ", appExpireChangeMqRetryCount=" + this.getAppExpireChangeMqRetryCount() + ", iamUri=" + this.getIamUri() + ", emcUri=" + this.getEmcUri() + ", eocUri=" + this.getEocUri() + ", atmcUri=" + this.getAtmcUri() + ", semcUri=" + this.getSemcUri() + ", athenaDdUri=" + this.getAthenaDdUri() + ", athenaMobileUri=" + this.getAthenaMobileUri() + ", pcAddressUri=" + this.getPcAddressUri() + ", appToken=" + this.getAppToken() + ", noticeEventId=" + this.getNoticeEventId() + ", nanaSuiteId=" + this.getNanaSuiteId() + ", wecomNoticeEventId=" + this.getWecomNoticeEventId() + ", asaNoticeEventId=" + this.getAsaNoticeEventId() + ", aniaWebAddressUri=" + this.getAniaWebAddressUri() + ", aniaAddressUri=" + this.getAniaAddressUri() + ", asaLineUrl=" + this.getAsaLineUrl() + ", lineNoticeEventId=" + this.getLineNoticeEventId() + ", transUri=" + this.getTransUri() + ", defaultLang=" + this.getDefaultLang() + ", host=" + this.getHost() + ", ipAddress=" + this.getIpAddress() + ", freeMemory=" + this.getFreeMemory() + ", totalMemory=" + this.getTotalMemory() + ", maxMemory=" + this.getMaxMemory() + ", osName=" + this.getOsName() + ", pid=" + this.getPid() + ", startTime=" + this.getStartTime() + ", classPath=" + this.getClassPath() + ", projectPath=" + this.getProjectPath() + ", runtime=" + this.getRuntime() + ", threadCount=" + this.getThreadCount() + ")";
    }
}

