/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.domain.message.service.impl;

import com.digiwin.athena.aim.app.env.EnvProperties;
import com.digiwin.athena.aim.common.CategoryEnum;
import com.digiwin.athena.aim.common.Constants;
import com.digiwin.athena.aim.domain.message.model.MessageBatchUserDTO;
import com.digiwin.athena.aim.domain.message.model.MessageContentDO;
import com.digiwin.athena.aim.domain.message.model.MessageDO;
import com.digiwin.athena.aim.domain.message.service.DingDingMessageService;
import com.digiwin.athena.aim.infrastructure.atmc.AtmcService;
import com.digiwin.athena.aim.infrastructure.emc.EmcService;
import com.digiwin.athena.aim.infrastructure.iam.IamService;
import com.digiwin.athena.aim.infrastructure.thememap.dto.IamDdMessageDTO;
import com.digiwin.athena.aim.infrastructure.thememap.dto.IamDdMessageDataDTO;
import com.digiwin.athena.aim.infrastructure.thememap.dto.KmApplicationRelationDTO;
import com.digiwin.athena.aim.infrastructure.thememap.dto.KmApplicationRelationReqDTO;
import com.digiwin.athena.aim.infrastructure.thememap.service.ThemeMapService;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import lombok.Generated;
import net.sf.json.JSONObject;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DingDingMessageServiceImpl
implements DingDingMessageService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DingDingMessageServiceImpl.class);
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Resource
    private EnvProperties envProperties;
    @Resource
    private EmcService emcService;
    @Autowired
    private ThemeMapService themeMapService;
    @Autowired
    private AtmcService atmcService;
    @Autowired
    private IamService iamService;
    @Autowired
    private MessageUtils messageUtils;

    private void sendAsaDingDingMessage(MessageBatchUserDTO messageBatchUserDTO) throws UnsupportedEncodingException {
        String encode;
        String dingding = this.iamService.getUserMetadataAllTenant((String)messageBatchUserDTO.getUserIdList().get(0), 2, 2);
        if (StringUtils.isBlank((String)dingding)) {
            return;
        }
        MessageDO message = messageBatchUserDTO.getMessage();
        JSONObject param = new JSONObject();
        param.put((Object)"tenantId", (Object)messageBatchUserDTO.getTenantId());
        param.put((Object)"appType", (Object)"dingTalk");
        param.put((Object)"sysId", (Object)"Athena");
        param.put((Object)"appCategory", (Object)"outsource");
        Map appConfig = this.emcService.getAppConfig(param);
        String redirect_uri = String.format("%s/ania/dingrouter/routingDistribution", this.envProperties.getAniaAddressUri());
        String messageUri = this.getNaNaPcShareUrl(messageBatchUserDTO, "Athena", MapUtils.getString((Map)appConfig, (Object)"corpId"));
        String urlPath = redirect_uri + "?" + messageUri;
        String dingDingUrl = encode = URLEncoder.encode(urlPath, "utf-8");
        JSONObject msgJson = new JSONObject();
        JSONObject dataJsonObject = new JSONObject();
        dataJsonObject.put((Object)"appId", (Object)"Athena");
        dataJsonObject.put((Object)"userList", (Object)messageBatchUserDTO.getUserIdList());
        dataJsonObject.put((Object)"tenantId", (Object)messageBatchUserDTO.getTenantId());
        if (appConfig != null && appConfig.size() > 0) {
            StringBuilder sb = new StringBuilder("dingtalk://dingtalkclient/action/openapp?corpid=").append(MapUtils.getString((Map)appConfig, (Object)"corpId")).append("&container_type=work_platform&app_id=0_").append(MapUtils.getString((Map)appConfig, (Object)"agentId")).append("&redirect_type=jump&redirect_url=").append(dingDingUrl);
            dingDingUrl = sb.toString();
        }
        dataJsonObject.put((Object)"messageData", (Object)this.buildMessageData(messageBatchUserDTO, dingDingUrl));
        msgJson.put((Object)"message", (Object)new com.alibaba.fastjson.JSONObject().fluentPut("data", (Object)dataJsonObject));
        msgJson.put((Object)"types", (Object)Lists.newArrayList((Object[])new String[]{"dingTalkInner"}));
        msgJson.put((Object)"eventId", (Object)this.envProperties.getAsaNoticeEventId());
        this.emcService.sendCommonChannelMsg(messageBatchUserDTO.getMessage().getLocale(), msgJson);
        log.info("message send success");
    }

    public void senDingDingMessage(MessageBatchUserDTO messageBatchUser) throws UnsupportedEncodingException {
        String reminderMsg;
        MessageDO message = messageBatchUser.getMessage();
        if (message == null) {
            return;
        }
        ImmutableMap typeMap = ImmutableMap.of((Object)"activity", (Object)"task", (Object)"project", (Object)"reminder");
        if ("ASA".equalsIgnoreCase(message.getSource()) && "text".equalsIgnoreCase(message.getType()) || "AGILE_DATA".equalsIgnoreCase(message.getSource())) {
            this.sendAsaDingDingMessage(messageBatchUser);
            return;
        }
        if (!typeMap.containsKey(message.getType().toLowerCase())) {
            log.info("senDingDingMessage \u53d1\u9001\u6d88\u606ftype\u4e0d\u5728\u8303\u56f4\u5185,type:{}", (Object)message.getType());
            return;
        }
        KmApplicationRelationDTO applicationRelationDTO = this.getAppCode(message.getSubType(), (String)typeMap.get(message.getType().toLowerCase()));
        if (null == applicationRelationDTO) {
            log.info("senDingDingMessage \u8bf7\u6c42KM\u83b7\u53d6\u5e94\u7528\u4fe1\u606fappCode\u4e3a\u7a7a MessageDO:{}", (Object)JsonUtils.objectToString((Object)message));
            return;
        }
        MessageContentDO messageContentDO = (MessageContentDO)JsonUtils.jsonToObject((String)message.getContent().toString(), MessageContentDO.class);
        if (null == messageContentDO) {
            log.info("senDingDingMessage \u6d88\u606f\u5185\u5bb9\u4e3a\u7a7a,message:{}", (Object)JsonUtils.objectToString((Object)message));
            return;
        }
        String msg = this.getSendMsg(messageContentDO);
        if ("reminder".equals(message.getType()) && StringUtils.isNotBlank((String)(reminderMsg = this.assembleTaskReminder(messageBatchUser)))) {
            msg = reminderMsg;
        }
        if (StringUtils.isNotBlank((String)messageContentDO.getTitle()) && StringUtils.isNotBlank((String)message.getCategory()) && (CategoryEnum.SHARE_NOTICE.name().equals(message.getCategory()) || CategoryEnum.SIGN_NOTICE.name().equals(message.getCategory()) || "task".equals(message.getType()) && CategoryEnum.EXCEPTION.name().equals(message.getCategory()))) {
            msg = messageContentDO.getTitle() + msg;
        }
        if (StringUtils.isEmpty((String)msg)) {
            log.info("senDingDingMessage \u53d1\u9001\u9489\u9489\u6d88\u606f\u5185\u5bb9\u4e3a\u7a7a");
            return;
        }
        String corpid = this.iamService.getTenantCorpid();
        if (StringUtils.isEmpty((String)corpid)) {
            corpid = messageBatchUser.getTenantId();
        }
        IamDdMessageDTO iamDdMessageDTO = new IamDdMessageDTO();
        iamDdMessageDTO.setAppId(applicationRelationDTO.getAppCode());
        iamDdMessageDTO.setLocale(message.getLocale());
        iamDdMessageDTO.setCorpId(corpid);
        iamDdMessageDTO.setTenantId(messageBatchUser.getTenantId());
        iamDdMessageDTO.setUserList(messageBatchUser.getUserIdList());
        IamDdMessageDataDTO messageDataDTO = new IamDdMessageDataDTO();
        messageDataDTO.setDataUrl(msg);
        String appUri = this.getAppShareUrl(messageContentDO.getId(), applicationRelationDTO.getAppName(), applicationRelationDTO.getAppCode(), messageBatchUser.getTenantId(), corpid);
        messageDataDTO.setAppUri(appUri);
        String messageUri = this.getPcShareUrl(messageContentDO.getId(), "reminder".equalsIgnoreCase(message.getType()) ? "activity" : message.getType(), applicationRelationDTO.getAppCode(), corpid);
        messageDataDTO.setMessageUri(messageUri);
        messageDataDTO.setTenantId(corpid);
        iamDdMessageDTO.setMessageData(messageDataDTO);
        this.emcService.senDdMessage(iamDdMessageDTO);
    }

    public String getAppShareUrl(String taskId, String appName, String appId, String tenantId, String corpid) {
        String messageUrl = String.format("%s/#/?appId=%s&appName=%s&corpId=%s&sourceType=ding_talk&dataId=%s&targetTenantId=%s", this.envProperties.getAthenaMobileUri(), appId, appName, corpid, taskId, tenantId);
        try {
            messageUrl = URLEncoder.encode(messageUrl, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("getAppShareUrl URLEncoder\u62a5\u9519\uff0c e\uff1a{}", (Throwable)e);
        }
        return messageUrl;
    }

    public String getPcShareUrl(String taskId, String msgType, String appId, String corpId) {
        String shareUrl = "";
        String messageUrl = String.format("%s/login/dingtalk-login?appId=%s&corpId=%s&dingLog=0&routerLink=", this.envProperties.getAthenaDdUri(), appId, corpId);
        String shareMsgType = (msgType = msgType.toLowerCase()).equals("activity") ? "task" : "project";
        String shareCode = this.atmcService.getShareCode(taskId, shareMsgType);
        if (msgType.equals("task")) {
            shareUrl = String.format("/project/share/%s/%s?engineType=TaskEngine", taskId, shareCode);
        }
        if (msgType.equals("activity")) {
            shareUrl = String.format("task/detail/%s?shareCode=%s", taskId, shareCode);
        }
        messageUrl = messageUrl + shareUrl;
        try {
            messageUrl = URLEncoder.encode(messageUrl, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("senDingDingMessage URLEncoder\u62a5\u9519\uff0c e\uff1a{}", (Throwable)e);
        }
        return messageUrl;
    }

    public String getNaNaAppShareUrl() {
        String messageUrl = String.format("%s/#/?NANA=%s", this.envProperties.getAthenaMobileUri(), 1);
        try {
            messageUrl = URLEncoder.encode(messageUrl, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("getAppShareUrl URLEncoder\u62a5\u9519\uff0c e\uff1a{}", (Throwable)e);
        }
        return messageUrl;
    }

    public String getNaNaPcShareUrl(MessageBatchUserDTO messageBatchUserDTO, String appCode, String corpId) {
        MessageDO message = messageBatchUserDTO.getMessage();
        String messageUrl = String.format("appId=%s&corpId=%s&dingLog=2", appCode, corpId);
        StringBuilder urlPath = new StringBuilder().append(messageUrl).append("&");
        List urlParams = message.getAction().getUrlParams();
        for (int j = 0; j < urlParams.size(); ++j) {
            urlPath.append(((MessageDO.TargetAction.Param)urlParams.get(j)).getKey()).append("=").append(((MessageDO.TargetAction.Param)urlParams.get(j)).getValue());
            if (j >= urlParams.size() - 1) continue;
            urlPath.append("&");
        }
        return urlPath.toString();
    }

    public String getSendMsg(MessageContentDO messageContentDO) {
        if (StringUtils.isNotEmpty((String)messageContentDO.getEmailMsg())) {
            return messageContentDO.getEmailMsg();
        }
        if (StringUtils.isNotEmpty((String)messageContentDO.getMsg())) {
            return messageContentDO.getMsg();
        }
        if (StringUtils.isNotEmpty((String)messageContentDO.getTitle())) {
            return messageContentDO.getTitle();
        }
        if (StringUtils.isNotEmpty((String)messageContentDO.getName())) {
            return messageContentDO.getName();
        }
        return "";
    }

    public KmApplicationRelationDTO getAppCode(String subType, String type) {
        KmApplicationRelationDTO appInfo = null;
        if (StringUtils.isEmpty((String)subType)) {
            return appInfo;
        }
        String cacheKey = "aim:message:dd:appInfo:" + subType;
        String appInfoJson = (String)this.stringRedisTemplate.opsForValue().get((Object)cacheKey);
        if (StringUtils.isNotEmpty((String)appInfoJson)) {
            appInfo = (KmApplicationRelationDTO)JsonUtils.jsonToObject((String)appInfoJson, KmApplicationRelationDTO.class);
            return appInfo;
        }
        KmApplicationRelationReqDTO relationReqDTO = new KmApplicationRelationReqDTO();
        relationReqDTO.setType(type);
        ArrayList<String> codeList = new ArrayList<String>();
        codeList.add(subType);
        relationReqDTO.setCodes(codeList);
        List relationDTOList = this.themeMapService.getApplicationRelation(relationReqDTO);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)relationDTOList)) {
            appInfo = (KmApplicationRelationDTO)relationDTOList.get(0);
            this.stringRedisTemplate.opsForValue().set((Object)cacheKey, (Object)JsonUtils.objectToString(relationDTOList.get(0)), (long)Constants.APP_CODE_VALIDITY.intValue(), TimeUnit.DAYS);
        }
        return appInfo;
    }

    private JSONObject buildMessageData(MessageBatchUserDTO messageBatchUserDTO, String dingidngChatUrl) {
        MessageDO message = messageBatchUserDTO.getMessage();
        JSONObject content = message.getContent();
        String msg = content.getString("msg");
        String locale = StringUtils.isNotBlank((String)message.getLocale()) && message.getLocale().equals("zh_CN") ? "zh_CN" : "zh_TW";
        String title = this.messageUtils.getMessageByLangName("meesage.wecom.title", locale);
        String description = "AGILE_DATA".equalsIgnoreCase(message.getSource()) ? "\u3010" + content.getString("title") + "\u3011\n" + msg : (StringUtils.isNotBlank((String)content.getString("msg")) ? msg : this.messageUtils.getMessageByLangName("meesage.wecom.description", locale));
        return this.buildTaskButtonsMsg(title, description, dingidngChatUrl, this.messageUtils.getMessageByLangName("message.line.button", locale));
    }

    private JSONObject buildTaskButtonsMsg(String title, String description, String url, String btntxt) {
        JSONObject taskMsg = new JSONObject();
        taskMsg.put((Object)"title", (Object)title);
        taskMsg.put((Object)"markdown", (Object)description);
        taskMsg.put((Object)"single_title", (Object)btntxt);
        taskMsg.put((Object)"single_url", (Object)url);
        return taskMsg;
    }

    private String assembleTaskReminder(MessageBatchUserDTO messageBatchUserDTO) {
        List userIdList = messageBatchUserDTO.getUserIdList();
        if (CollectionUtils.isEmpty((Collection)userIdList)) {
            return "";
        }
        JSONObject content = messageBatchUserDTO.getMessage().getContent();
        if (CollectionUtils.isEmpty((Map)content)) {
            return "";
        }
        String userId = (String)userIdList.get(0);
        String langName = this.iamService.getUserMetadataAllTenant(userId, 1, 0);
        String projectName = MapUtils.getString((Map)content, (Object)"projectName", (String)"");
        String taskName = MapUtils.getString((Map)content, (Object)"taskName", (String)"");
        String personInChargeName = MapUtils.getString((Map)content, (Object)"personInChargeName", (String)"");
        String performerId = MapUtils.getString((Map)content, (Object)"performerId", (String)"");
        String planEndTime = MapUtils.getString((Map)content, (Object)"planEndTime", (String)"");
        if (StringUtils.isNotBlank((String)projectName)) {
            projectName = MessageUtils.getMessageByLanguage((Object)projectName, (String)langName);
        }
        if (StringUtils.isNotBlank((String)taskName)) {
            taskName = MessageUtils.getMessageByLanguage((Object)taskName, (String)langName);
        }
        if (StringUtils.isNotBlank((String)personInChargeName)) {
            personInChargeName = MessageUtils.getMessageByLanguage((Object)personInChargeName, (String)langName);
        }
        if (performerId.equals(userId)) {
            return MessageFormat.format(this.messageUtils.getMessageByLangName("task.reminder.executor.msg", langName), planEndTime, taskName);
        }
        return MessageFormat.format(this.messageUtils.getMessageByLangName("task.reminder.no.executor.msg", langName), taskName, projectName, personInChargeName);
    }
}

