/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.domain.message.service.impl;

import com.digiwin.athena.aim.app.env.EnvProperties;
import com.digiwin.athena.aim.domain.message.model.MessageBatchUserDTO;
import com.digiwin.athena.aim.domain.message.model.MessageContentDO;
import com.digiwin.athena.aim.domain.message.model.MessageDO;
import com.digiwin.athena.aim.domain.message.service.LineMessageService;
import com.digiwin.athena.aim.infrastructure.emc.EmcService;
import com.digiwin.athena.aim.infrastructure.iam.IamService;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import javax.annotation.Resource;
import lombok.Generated;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LineMessageServiceImpl
implements LineMessageService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LineMessageServiceImpl.class);
    @Resource
    private EmcService emcService;
    @Autowired
    private IamService iamService;
    @Resource
    private EnvProperties envProperties;
    @Autowired
    private MessageUtils messageUtils;

    public void sendLineMessage(MessageBatchUserDTO messageBatchUserDTO) throws UnsupportedEncodingException {
        String altText;
        String buttonName;
        String messageText;
        String messageByLangName;
        MessageDO message = messageBatchUserDTO.getMessage();
        if (message == null) {
            return;
        }
        MessageContentDO messageContentDO = (MessageContentDO)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)message.getContent()), MessageContentDO.class);
        if (null == messageContentDO) {
            log.info("sendLineMessage | content is empty, message:{}", (Object)JsonUtils.objectToString((Object)message));
            return;
        }
        String lineKey = this.iamService.getUserMetadataAllTenant((String)messageBatchUserDTO.getUserIdList().get(0), 2, 1);
        if (StringUtils.isBlank((String)lineKey)) {
            return;
        }
        JSONObject content = message.getContent();
        String msg = content.getString("msg");
        if (StringUtils.isNotBlank((String)message.getLocale()) && message.getLocale().equals("zh_TW")) {
            messageByLangName = "AGILE_DATA".equalsIgnoreCase(message.getSource()) ? "\u3010" + content.getString("title") + "\u3011\n" + msg : this.messageUtils.getMessageByLangName("message.line.urge", "zh_TW");
            messageText = String.format(messageByLangName, msg);
            buttonName = this.messageUtils.getMessageByLangName("message.line.button", "zh_TW");
            altText = this.messageUtils.getMessageByLangName("message.line.altText", "zh_TW");
        } else {
            messageByLangName = "AGILE_DATA".equalsIgnoreCase(message.getSource()) ? "\u3010" + content.getString("title") + "\u3011\n" + msg : this.messageUtils.getMessageByLangName("message.line.urge", "zh_CN");
            messageText = String.format(messageByLangName, msg);
            buttonName = this.messageUtils.getMessageByLangName("message.line.button", "zh_CN");
            altText = this.messageUtils.getMessageByLangName("message.line.altText", "zh_CN");
        }
        StringBuilder urlPath = new StringBuilder();
        List urlParams = message.getAction().getUrlParams();
        for (int i = 0; i < urlParams.size(); ++i) {
            urlPath.append(((MessageDO.TargetAction.Param)urlParams.get(i)).getKey()).append("=").append(((MessageDO.TargetAction.Param)urlParams.get(i)).getValue());
            if (i >= urlParams.size() - 1) continue;
            urlPath.append("&");
        }
        String encode = URLEncoder.encode(urlPath.toString(), "utf-8").replace("+", "%20");
        JSONObject messageData = this.buildTaskUrgeButtonsMsg(messageText, this.envProperties.getAsaLineUrl() + "?" + encode, buttonName, altText);
        JSONObject msgJson = new JSONObject();
        JSONObject dataJsonObject = new JSONObject();
        dataJsonObject.put((Object)"appId", (Object)"Athena");
        dataJsonObject.put((Object)"userList", (Object)messageBatchUserDTO.getUserIdList());
        dataJsonObject.put((Object)"thirdUserList", (Object)new String[0]);
        dataJsonObject.put((Object)"messageData", (Object)messageData);
        JSONObject data = new JSONObject();
        data.put((Object)"data", (Object)dataJsonObject);
        msgJson.put((Object)"message", (Object)data);
        msgJson.put((Object)"types", (Object)Lists.newArrayList((Object[])new String[]{"line"}));
        msgJson.put((Object)"eventId", (Object)this.envProperties.getLineNoticeEventId());
        this.emcService.sendCommonChannelMsg(message.getLocale(), msgJson);
    }

    private JSONObject buildTaskUrgeButtonsMsg(String text, String url, String buttonName, String altText) {
        JSONObject taskUrgeMsg = new JSONObject();
        taskUrgeMsg.put((Object)"text", (Object)text);
        taskUrgeMsg.put((Object)"url", (Object)url);
        taskUrgeMsg.put((Object)"buttonName", (Object)buttonName);
        taskUrgeMsg.put((Object)"altText", (Object)altText);
        return taskUrgeMsg;
    }
}

