/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.domain.message.service.impl;

import com.digiwin.athena.aim.domain.message.event.NoticeMobileAppEvent;
import com.digiwin.athena.aim.domain.message.model.MessageDO;
import com.digiwin.athena.aim.domain.message.model.MessageRemindDTO;
import com.digiwin.athena.aim.domain.message.model.MessageTemplateDTO;
import com.digiwin.athena.aim.domain.message.model.TemplateVariableDTO;
import com.digiwin.athena.aim.domain.message.model.TenantRouteChangeMessageDO;
import com.digiwin.athena.aim.domain.message.service.MessageSendService;
import com.digiwin.athena.aim.domain.message.service.MessageTemplateService;
import com.digiwin.athena.aim.infrastructure.mqtt.MqttGateway;
import com.digiwin.athena.aim.infrastructure.mqtt.MqttProperties;
import com.digiwin.athena.aim.infrastructure.trans.TranslateService;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.google.common.eventbus.AsyncEventBus;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import lombok.Generated;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MessageSendServiceImpl
implements MessageSendService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageSendServiceImpl.class);
    private String[] locals = new String[]{"zh_CN", "zh_TW", "en_US"};
    @Autowired
    private MqttGateway mqttGateway;
    @Autowired
    private MqttProperties mqttConfiguration;
    @Autowired
    private MessageTemplateService messageTemplateService;
    @Resource
    private TranslateService translateService;
    @Resource
    private AsyncEventBus asyncEventBus;
    public static final String VARIABLE = "$%s$";

    public void sendToClient(String tenantId, String userId, MessageDO payload) {
        log.info("\u3010sendToClient-payload\u3011\uff1a{}", (Object)payload);
        for (String local : this.locals) {
            String message = payload.getMessageByLanguage(local);
            String topic = this.mqttConfiguration.getServerName() + "/" + tenantId + "/" + userId + "/" + local;
            this.mqttGateway.sendToMqtt(topic, 1, message);
            LogDto logDto = new LogDto("\u3010sendToClient\u3011\u53d1\u9001\u5ba2\u6237\u7aef\u6d88\u606f\u5904\u7406\uff0c\u6d88\u606f\u5185\u5bb9\uff1a" + JsonUtils.objectToString((Object)payload), tenantId + ";" + userId);
            log.info(logDto.toString());
            log.info("\u3010sendToClient-sendToClient\u53d1\u9001\u6d88\u606f\u6210\u529f\u3011topic\uff1a{}\uff0cmessage\uff1a{}", (Object)topic, (Object)message);
        }
    }

    public void sendTenantRouteChange(String tenantId, String app, TenantRouteChangeMessageDO payload) {
        String message = JsonUtils.objectToString((Object)payload);
        String topic = this.mqttConfiguration.getServerName() + "/" + tenantId + "/" + app;
        log.info("\u3010sendToClient-TenantRouteChangeMessageDO\u3011\uff1a{}, topic: {}", (Object)message, (Object)topic);
        this.mqttGateway.sendToMqtt(topic, 1, message);
        log.info("\u3010sendToClient-TenantRouteChangeMessageDO\u53d1\u9001\u6d88\u606f\u6210\u529f\u3011topic\uff1a{}", (Object)topic);
    }

    public void sendMessageRemindToClient(MessageRemindDTO messageRemindDTO) {
        log.info("\u3010sendMessageRemindToClient-messageRemindDTO\u3011\uff1a{}", (Object)messageRemindDTO);
        for (Map receiverMap : messageRemindDTO.getReceivers()) {
            for (String locale : this.locals) {
                String key = this.mqttConfiguration.getServerName() + "/" + receiverMap.get("tenantId") + "/" + receiverMap.get("userId") + "/" + locale;
                log.info("\u3010sendMessageRemindToClient-topic-receiver\u3011\uff1a{}\uff0c{}", (Object)key, (Object)receiverMap);
                this.mqttGateway.sendToMqtt(key, 1, JsonUtils.objectToString((Object)messageRemindDTO));
                String tenantId = receiverMap.get("tenantId") == null ? "" : receiverMap.get("tenantId").toString();
                LogDto logDto = new LogDto("\u3010sendToClient\u3011\u5ba2\u6237\u7aef\u6d88\u606f\u53d1\u9001\u6210\u529f\uff0creceiverMap\uff1a" + receiverMap, tenantId);
                log.info(logDto.toString());
                log.info("\u3010sendMessageRemindToClient\u53d1\u9001\u6d88\u606f\u6210\u529f\uff1atopic\uff1a{}\uff0cmessageRemindDTO\uff1a{}\u3011", (Object)key, (Object)JsonUtils.objectToString((Object)messageRemindDTO));
            }
        }
    }

    public void sendMessageRemindToClient(List<MessageRemindDTO> messageList) {
        log.info("\u3010sendMessageRemindToClient-messageRemindDTO\u3011\uff1a{}", messageList);
        for (MessageRemindDTO messageRemindDTO : messageList) {
            this.sendMessageRemindToClient(messageRemindDTO);
        }
    }

    public void sendToAppClient(String tenantId, String userId, MessageDO message) {
        message.setGid(String.valueOf(SnowflakeIdWorker.getInstance().newId()));
        message.setUserId(StringUtils.isNotBlank((String)userId) ? userId : message.getUserId());
        message.setTenantId(StringUtils.isNotBlank((String)tenantId) ? tenantId : message.getTenantId());
        String msg = this.replaceVariable(message.getTemplate(), message.getLocale());
        if (StringUtils.isNotBlank((String)msg)) {
            JSONObject content = message.getContent();
            content.put((Object)"msg", (Object)msg);
        }
        NoticeMobileAppEvent event = new NoticeMobileAppEvent(Collections.singletonList(message), MDC.getCopyOfContextMap());
        this.asyncEventBus.post((Object)event);
    }

    private String replaceVariable(TemplateVariableDTO template, String locale) {
        List templateDTOList;
        String msg = "";
        if (template != null && StringUtils.isNotBlank((String)template.getCode()) && CollectionUtils.isNotEmpty((Collection)template.getVariableList()) && CollectionUtils.isNotEmpty((Collection)(templateDTOList = this.messageTemplateService.queryMessageTemplateList(template.getCode())))) {
            msg = ((MessageTemplateDTO)templateDTOList.get(0)).getContent();
            for (TemplateVariableDTO.VariableDTO variableDTO : template.getVariableList()) {
                msg = msg.replace(String.format(VARIABLE, variableDTO.getKey()), variableDTO.getValue());
            }
            if (StringUtils.isNotBlank((String)locale) && locale.equals("zh_TW")) {
                msg = this.translateService.translateText(msg, "zh_TW");
            }
        }
        return msg;
    }
}

