/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.domain.message.service.impl;

import com.digiwin.athena.aim.api.dto.ChangeMsgStateDTO;
import com.digiwin.athena.aim.api.dto.MsgSummaryDTO;
import com.digiwin.athena.aim.domain.message.event.DingDingMessageEvent;
import com.digiwin.athena.aim.domain.message.event.NoticeMobileAppEvent;
import com.digiwin.athena.aim.domain.message.event.WecomMessageEvent;
import com.digiwin.athena.aim.domain.message.model.MessageBatchUserDTO;
import com.digiwin.athena.aim.domain.message.model.MessageDO;
import com.digiwin.athena.aim.domain.message.model.MsgSubTypeCategoryEnum;
import com.digiwin.athena.aim.domain.message.service.MessageService;
import com.digiwin.athena.aim.infrastructure.iam.IamService;
import com.digiwin.athena.aim.infrastructure.mongo.MongoMessageMapper;
import com.digiwin.athena.aim.infrastructure.semc.SemcService;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.eventbus.AsyncEventBus;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import lombok.Generated;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class MessageServiceImpl
implements MessageService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageServiceImpl.class);
    @Autowired
    private MongoMessageMapper messageMapper;
    @Resource
    private SemcService semcService;
    @Resource
    private AsyncEventBus asyncEventBus;
    @Autowired
    private IamService iamService;
    @Autowired
    private MessageUtils messageUtils;

    public ResponseEntity<?> newMessage(MessageDO messageDO) {
        log.info("\u3010\u63d0\u4ea4\u65f6\u6d88\u606f\u63d0\u9192newMessage\u3011\uff1a{}", (Object)messageDO);
        if (StringUtils.isBlank((String)messageDO.getGid())) {
            messageDO.setGid(String.valueOf(SnowflakeIdWorker.getInstance().newId()));
        }
        MessageDO insertedMsg = this.messageMapper.insert(messageDO);
        if (BooleanUtils.isTrue((Boolean)messageDO.getNoticeMobileApp())) {
            NoticeMobileAppEvent event = new NoticeMobileAppEvent(Collections.singletonList(messageDO), MDC.getCopyOfContextMap());
            this.asyncEventBus.post((Object)event);
        }
        try {
            this.rebuildMsg(messageDO);
        }
        catch (Exception e) {
            log.warn("aim\u91cd\u88c5msg\u5185\u5bb9\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        ArrayList<MessageBatchUserDTO> messageBatchUserList = new ArrayList<MessageBatchUserDTO>();
        MessageBatchUserDTO batchUserDTO = new MessageBatchUserDTO();
        ArrayList<String> userIds = new ArrayList<String>();
        batchUserDTO.setTenantId(messageDO.getTenantId());
        userIds.add(messageDO.getUserId());
        batchUserDTO.setUserIdList(userIds);
        batchUserDTO.setMessage(messageDO);
        messageBatchUserList.add(batchUserDTO);
        DingDingMessageEvent dingDingEvent = new DingDingMessageEvent(messageBatchUserList, MDC.getCopyOfContextMap());
        this.asyncEventBus.post((Object)dingDingEvent);
        WecomMessageEvent wecomMessageEvent = new WecomMessageEvent(messageBatchUserList, MDC.getCopyOfContextMap());
        this.asyncEventBus.post((Object)wecomMessageEvent);
        return ResponseEntityWrapper.wrapperOk((Object)insertedMsg);
    }

    private void rebuildMsg(MessageDO messageDO) {
        JSONObject messageFiled;
        String langName = this.iamService.getUserMetadataAllTenant(messageDO.getUserId(), 1, 0);
        JSONObject content = messageDO.getContent();
        if (content != null && !content.isEmpty() && "activity".equals(messageDO.getType()) && (messageFiled = content.getJSONObject("messageFiled")) != null && !messageFiled.isEmpty()) {
            String summaryTag = MapUtils.getString((Map)messageFiled, (Object)"summaryTag", (String)"");
            String tmActivityName = MapUtils.getString((Map)messageFiled, (Object)"tmActivityName", (String)"");
            String endTime = MapUtils.getString((Map)messageFiled, (Object)"endTime", (String)"");
            String projectName = MapUtils.getString((Map)messageFiled, (Object)"projectName", (String)"");
            String summaryLayout = MapUtils.getString((Map)messageFiled, (Object)"summaryLayout", (String)"");
            tmActivityName = StringUtils.isNotEmpty((String)tmActivityName) ? MessageUtils.getMessageByLanguage((Object)tmActivityName, (String)langName) : "";
            projectName = StringUtils.isNotEmpty((String)projectName) ? MessageUtils.getMessageByLanguage((Object)projectName, (String)langName) : "";
            summaryLayout = StringUtils.isNotEmpty((String)summaryLayout) ? MessageUtils.getMessageByLanguage((Object)summaryLayout, (String)langName) : "";
            String msg = MessageFormat.format(this.messageUtils.getMessageByLangName("message.content.msg", langName), endTime, "\u3010" + tmActivityName + "\u3011 " + projectName);
            if ("0".equals(summaryTag)) {
                if (StringUtils.isNotEmpty((String)summaryLayout) && summaryLayout.length() > 60) {
                    summaryLayout = summaryLayout.substring(0, 60) + "...";
                }
                summaryLayout = summaryLayout.replaceAll("<br>", " ");
                String msgSummary = MessageFormat.format(this.messageUtils.getMessageByLangName("message.content.summary", langName), summaryLayout);
                msg = msg + msgSummary;
            }
            messageDO.getContent().put((Object)"msg", (Object)msg);
            messageDO.getContent().put((Object)"emailMsg", (Object)msg);
        }
    }

    public ResponseEntity<?> getMsgUnreadCount(Integer importance, String channelType) {
        MessageDO condition = this.buildQryMessageDO();
        condition.setImportance(importance);
        condition.setChannelType(channelType);
        return ResponseEntityWrapper.wrapperOk((Object)this.messageMapper.selectUnreadCount(condition));
    }

    public ResponseEntity<?> getMsgChanged(Integer importance) {
        return ResponseEntityWrapper.wrapperOk();
    }

    public ResponseEntity<?> getMsgSummary(Integer importance) {
        MessageDO condition = this.buildQryMessageDO();
        condition.setImportance(importance);
        List unreadCountList = this.messageMapper.selectUnreadCountGroupBySubTypeCategory(condition);
        if (null == unreadCountList) {
            unreadCountList = Lists.newArrayList();
        }
        List latestMessageList = this.messageMapper.selectLatestGroupBySubTypeCategory(condition);
        ArrayList msgSummaryList = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)latestMessageList)) {
            return ResponseEntityWrapper.wrapperOk((Object)msgSummaryList);
        }
        for (MessageDO messageDO : latestMessageList) {
            Map msgUnreadMap = Maps.newHashMap();
            for (Map map : unreadCountList) {
                if (!StringUtils.equals((String)messageDO.getSubTypeCategory(), (String)String.valueOf(map.get("subTypeCategory")))) continue;
                msgUnreadMap = map;
                break;
            }
            MsgSummaryDTO msgSummaryDTO = new MsgSummaryDTO();
            if (MapUtils.isNotEmpty((Map)msgUnreadMap)) {
                int unreadCount = Integer.parseInt(String.valueOf(msgUnreadMap.get("unreadCount")));
                msgSummaryDTO.setUnreadCount(Integer.valueOf(unreadCount));
            } else {
                msgSummaryDTO.setUnreadCount(Integer.valueOf(0));
            }
            msgSummaryDTO.setType(messageDO.getType());
            msgSummaryDTO.setSubType(messageDO.getSubType());
            msgSummaryDTO.setSubTypeCategory(messageDO.getSubTypeCategory());
            msgSummaryDTO.setCategory(messageDO.getCategory());
            msgSummaryDTO.setMessage(messageDO);
            msgSummaryList.add(msgSummaryDTO);
        }
        Collections.sort(msgSummaryList, (obj1, obj2) -> {
            if (MsgSubTypeCategoryEnum.customValueOf((String)obj1.getSubTypeCategory()).getOrder() <= MsgSubTypeCategoryEnum.customValueOf((String)obj2.getSubTypeCategory()).getOrder()) {
                return -1;
            }
            return 1;
        });
        return ResponseEntityWrapper.wrapperOk((Object)msgSummaryList);
    }

    public ResponseEntity<?> getMsgSummaryBySubTypeCategory(String subTypeCategory, Integer importance) {
        MessageDO condition = this.buildQryMessageDO();
        condition.setSubTypeCategory(subTypeCategory);
        condition.setImportance(importance);
        return ResponseEntityWrapper.wrapperOk((Object)this.messageMapper.selectMsgSummaryBySubTypeCategory(condition));
    }

    public ResponseEntity<?> getWorkNewsMsgSummary() {
        MessageDO condition = this.buildQryMessageDO();
        return ResponseEntityWrapper.wrapperOk((Object)this.messageMapper.selectWorkNewsMsgSummary(condition));
    }

    public ResponseEntity<?> changeStateToRead(ChangeMsgStateDTO changeMsgStateDTO) {
        MessageDO condition = this.buildQryMessageDO();
        condition.setImportance(changeMsgStateDTO.getImportance());
        condition.setSubTypeCategory(changeMsgStateDTO.getSubTypeCategory());
        return ResponseEntityWrapper.wrapperOk((Object)this.messageMapper.changeStateToRead(condition));
    }

    public ResponseEntity<?> deleteReadMsg(ChangeMsgStateDTO changeMsgStateDTO) {
        MessageDO condition = this.buildQryMessageDO();
        condition.setImportance(changeMsgStateDTO.getImportance());
        condition.setSubTypeCategory(changeMsgStateDTO.getSubTypeCategory());
        return ResponseEntityWrapper.wrapperOk((Object)this.messageMapper.deleteReadMsg(condition));
    }

    private MessageDO buildQryMessageDO() {
        AuthoredUser user = AppAuthContextHolder.getContext().getAuthoredUser();
        MessageDO condition = new MessageDO();
        condition.setUserId(user.getUserId());
        condition.setTenantId(user.getTenantId());
        return condition;
    }
}

