/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.domain.message.service.impl;

import com.digiwin.athena.aim.api.dto.MessagePagingQryCommand;
import com.digiwin.athena.aim.api.dto.Page;
import com.digiwin.athena.aim.common.Constants;
import com.digiwin.athena.aim.common.MessageChannelEnum;
import com.digiwin.athena.aim.domain.message.event.DingDingMessageEvent;
import com.digiwin.athena.aim.domain.message.event.LineMessageEvent;
import com.digiwin.athena.aim.domain.message.event.NoticeMobileAppEvent;
import com.digiwin.athena.aim.domain.message.event.WecomMessageEvent;
import com.digiwin.athena.aim.domain.message.model.AppExpireMessageDO;
import com.digiwin.athena.aim.domain.message.model.ExpireMessageReq;
import com.digiwin.athena.aim.domain.message.model.MessageBatchUserDTO;
import com.digiwin.athena.aim.domain.message.model.MessageDO;
import com.digiwin.athena.aim.domain.message.model.MessageRemindDTO;
import com.digiwin.athena.aim.domain.message.model.MessageTemplateDTO;
import com.digiwin.athena.aim.domain.message.model.MsgAndEmailBatchDTO;
import com.digiwin.athena.aim.domain.message.model.MsgSendTypeEnum;
import com.digiwin.athena.aim.domain.message.model.SendCommonChannelMsgReq;
import com.digiwin.athena.aim.domain.message.model.TemplateVariableDTO;
import com.digiwin.athena.aim.domain.message.model.UserMsgAndEmailDTO;
import com.digiwin.athena.aim.domain.message.repository.MessageMapperV2;
import com.digiwin.athena.aim.domain.message.service.MessageSendService;
import com.digiwin.athena.aim.domain.message.service.MessageServiceV2;
import com.digiwin.athena.aim.domain.message.service.MessageTemplateService;
import com.digiwin.athena.aim.infrastructure.emc.EmcService;
import com.digiwin.athena.aim.infrastructure.iam.IamService;
import com.digiwin.athena.aim.infrastructure.iam.dto.IamUserDTO;
import com.digiwin.athena.aim.infrastructure.iam.dto.PersonalizedDto;
import com.digiwin.athena.aim.infrastructure.semc.SemcService;
import com.digiwin.athena.aim.infrastructure.semc.dto.GetSsoUrlReq;
import com.digiwin.athena.aim.infrastructure.semc.dto.GetSsoUrlResp;
import com.digiwin.athena.aim.infrastructure.semc.dto.QueryBlackWhiteListResp;
import com.digiwin.athena.aim.infrastructure.semc.dto.QueryTemplateListResp;
import com.digiwin.athena.aim.infrastructure.semc.dto.QueryTemplateRelResp;
import com.digiwin.athena.aim.infrastructure.trans.TranslateService;
import com.digiwin.athena.aim.util.ValidateUtils;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.eventbus.AsyncEventBus;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class MessageServiceV2Impl
implements MessageServiceV2 {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageServiceV2Impl.class);
    @Autowired
    private MessageMapperV2 messageMapperV2;
    @Resource
    private AsyncEventBus asyncEventBus;
    @Resource
    private TranslateService translateService;
    @Resource
    private SemcService semcService;
    @Resource
    private IamService iamService;
    @Resource
    private EmcService emcService;
    @Autowired
    private MessageTemplateService messageTemplateService;
    @Autowired
    private MessageSendService messageSendService;
    public static final String VARIABLE = "$%s$";
    @Autowired
    private MessageUtils messageUtils;

    public ResponseEntity<?> pagingQueryMessage(MessagePagingQryCommand command) {
        ValidateUtils.checkPageParam((Page)command);
        MessageDO condition = this.buildQryMessageDO();
        condition.setType(command.getType());
        condition.setSubType(command.getSubType());
        condition.setSubTypeCategory(command.getSubTypeCategory());
        condition.setCategory(command.getCategory());
        condition.setImportance(command.getImportance());
        condition.setSource(command.getSource());
        condition.setState(command.getState());
        condition.setUnterminate(command.getUnterminate());
        condition.setChannelType(command.getChannelType());
        condition.setStartTimeStr(command.getStartTimeStr());
        condition.setEndTimeStr(command.getEndTimeStr());
        condition.setKey(command.getKey());
        return ResponseEntityWrapper.wrapperOk((Object)this.messageMapperV2.pagingQuery(condition, (Page)command));
    }

    public ResponseEntity<?> summaryRemove(String channelType) {
        return ResponseEntityWrapper.wrapperOk((Object)this.messageMapperV2.updateDeleted(channelType, AppAuthContextHolder.getContext().getAuthoredUser()));
    }

    public ResponseEntity<?> readMessageByGid(List<String> gidList) {
        if (CollectionUtils.isEmpty(gidList)) {
            return ResponseEntityWrapper.wrapperOk((Object)0);
        }
        List tmpGidList = gidList.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(tmpGidList)) {
            return ResponseEntityWrapper.wrapperOk((Object)0);
        }
        return ResponseEntityWrapper.wrapperOk((Object)this.messageMapperV2.readMessageByGid(null, gidList, AppAuthContextHolder.getContext().getAuthoredUser()));
    }

    public ResponseEntity<?> readMessageAll(String channelType) {
        return ResponseEntityWrapper.wrapperOk((Object)this.messageMapperV2.readMessageByGid(channelType, null, AppAuthContextHolder.getContext().getAuthoredUser()));
    }

    public ResponseEntity<?> readMessageDetailByGid(String gid) {
        if (StringUtils.isBlank((String)gid)) {
            return ResponseEntityWrapper.wrapperOk();
        }
        return ResponseEntityWrapper.wrapperOk((Object)this.messageMapperV2.readMessageDetailByGid(gid, AppAuthContextHolder.getContext().getAuthoredUser()));
    }

    public void newMessageForBatchUsers(List<MessageBatchUserDTO> messageBatchUserList) {
        ArrayList<MessageDO> newMessageList = new ArrayList<MessageDO>();
        ArrayList<MessageDO> mobileMsgList = new ArrayList<MessageDO>();
        ArrayList<MessageRemindDTO> onlineMsgList = new ArrayList<MessageRemindDTO>();
        for (MessageBatchUserDTO messageBatchUser : messageBatchUserList) {
            MessageDO message = messageBatchUser.getMessage();
            String msg = this.replaceVariable(message.getTemplate(), message.getLocale());
            for (String userId : messageBatchUser.getUserIdList()) {
                MessageDO newMessage = new MessageDO();
                BeanUtils.copyProperties((Object)message, (Object)newMessage);
                newMessage.setGid(String.valueOf(SnowflakeIdWorker.getInstance().newId()));
                newMessage.setUserId(userId);
                newMessage.setTenantId(messageBatchUser.getTenantId());
                if (StringUtils.isNotBlank((String)msg)) {
                    JSONObject content = newMessage.getContent();
                    content.put((Object)"msg", (Object)msg);
                }
                newMessageList.add(newMessage);
                if (!BooleanUtils.isTrue((Boolean)message.getNoticeMobileApp())) continue;
                mobileMsgList.add(newMessage);
            }
            if (!BooleanUtils.isTrue((Boolean)message.getNoticeOnlineUser())) continue;
            MessageRemindDTO remindDTO = new MessageRemindDTO();
            remindDTO.setType("task");
            remindDTO.setSource(message.getSource());
            JSONObject content = message.getContent();
            remindDTO.setTitle(StringUtils.isNotBlank((String)content.getString("title")) ? content.getString("title") : "");
            remindDTO.setMsg(StringUtils.isNotBlank((String)content.getString("msg")) ? content.getString("msg") : "");
            List userList = messageBatchUser.getUserIdList().stream().map(x -> {
                HashMap map = Maps.newHashMap();
                map.put("userId", x);
                map.put("tenantId", messageBatchUser.getTenantId());
                return map;
            }).collect(Collectors.toList());
            remindDTO.setReceivers(userList);
            onlineMsgList.add(remindDTO);
        }
        this.messageMapperV2.batchInsert(newMessageList);
        log.info("\u3010\u63d0\u4ea4\u65f6\u6d88\u606f\u63d0\u9192needNotifyMsgList\u3011:{}", (Object)mobileMsgList.size());
        if (CollectionUtils.isNotEmpty(mobileMsgList)) {
            NoticeMobileAppEvent event = new NoticeMobileAppEvent(mobileMsgList, MDC.getCopyOfContextMap());
            this.asyncEventBus.post((Object)event);
        }
        if (CollectionUtils.isNotEmpty(onlineMsgList)) {
            this.messageSendService.sendMessageRemindToClient(onlineMsgList);
        }
        DingDingMessageEvent dingDingEvent = new DingDingMessageEvent(messageBatchUserList, MDC.getCopyOfContextMap());
        this.asyncEventBus.post((Object)dingDingEvent);
        WecomMessageEvent wecomMessageEvent = new WecomMessageEvent(messageBatchUserList, MDC.getCopyOfContextMap());
        this.asyncEventBus.post((Object)wecomMessageEvent);
        if ("ASA".equalsIgnoreCase(messageBatchUserList.get(0).getMessage().getSource()) && "text".equalsIgnoreCase(messageBatchUserList.get(0).getMessage().getType()) || "AGILE_DATA".equalsIgnoreCase(messageBatchUserList.get(0).getMessage().getSource())) {
            LineMessageEvent lineMessageEvent = new LineMessageEvent(messageBatchUserList, MDC.getCopyOfContextMap());
            this.asyncEventBus.post((Object)lineMessageEvent);
        }
    }

    private String replaceVariable(TemplateVariableDTO template, String locale) {
        List templateDTOList;
        String msg = "";
        if (template != null && StringUtils.isNotBlank((String)template.getCode()) && CollectionUtils.isNotEmpty((Collection)template.getVariableList()) && CollectionUtils.isNotEmpty((Collection)(templateDTOList = this.messageTemplateService.queryMessageTemplateList(template.getCode())))) {
            msg = ((MessageTemplateDTO)templateDTOList.get(0)).getContent();
            for (TemplateVariableDTO.VariableDTO variableDTO : template.getVariableList()) {
                msg = msg.replace(String.format(VARIABLE, variableDTO.getKey()), variableDTO.getValue());
            }
            if (StringUtils.isNotBlank((String)locale) && locale.equals("zh_TW")) {
                msg = this.translateService.translateText(msg, "zh_TW");
            }
        }
        return msg;
    }

    private MessageDO buildQryMessageDO() {
        AuthoredUser user = AppAuthContextHolder.getContext().getAuthoredUser();
        MessageDO condition = new MessageDO();
        condition.setUserId(user.getUserId());
        condition.setTenantId(user.getTenantId());
        return condition;
    }

    public void insertAppExpirationMessage(ExpireMessageReq expireMessageReq) {
        ExpireMessageReq.MessageDTO message = expireMessageReq.getMessage();
        String msg = this.replaceVariable(message.getTemplate(), message.getLocale());
        ArrayList messageDOList = Lists.newArrayList();
        for (String userId : expireMessageReq.getUserIdList()) {
            ExpireMessageReq.MessageDTO newMessage = new ExpireMessageReq.MessageDTO();
            BeanUtils.copyProperties((Object)message, (Object)newMessage);
            newMessage.setGid(String.valueOf(SnowflakeIdWorker.getInstance().newId()));
            newMessage.setUserId(userId);
            newMessage.setTenantId(expireMessageReq.getTenantId());
            if (StringUtils.isNotBlank((String)msg)) {
                JSONObject content = new JSONObject();
                content.put((Object)"msg", (Object)msg);
                newMessage.setContent(content);
            }
            messageDOList.add(newMessage);
        }
        this.messageMapperV2.insertAppExpirationMessage((List)messageDOList);
    }

    public List<MessageDO> queryAppExpirationMessage(Integer platformFlag) {
        MessageDO condition = this.buildQryMessageDO();
        List messageDOList = this.messageMapperV2.queryAppExpirationMessage(condition);
        if (platformFlag != null && platformFlag.equals(Constants.INVOKE_PLATFORM_FLAG)) {
            String locale = LocaleContextHolder.getLocale().toString();
            messageDOList.forEach(x -> {
                JSONObject content = x.getContent();
                if (content != null && StringUtils.isNotBlank((String)content.getString("msg"))) {
                    String msg = this.translateService.translateText(content.getString("msg"), locale);
                    content.put((Object)"msg", (Object)msg);
                }
            });
        }
        return messageDOList;
    }

    public void deleteAppExpirationMessage(AppExpireMessageDO appExpireMessageDO) {
        this.messageMapperV2.deleteAppExpirationMessage(appExpireMessageDO);
    }

    public JSONObject sendCommonChannelMessage(String channelFlag, List<SendCommonChannelMsgReq.MsgInfoReq> msgInfoReqList) {
        JSONObject result = new JSONObject();
        if (MessageChannelEnum.EMAIL.getFlag().equals(channelFlag)) {
            result = this.sendCommonEmailMessage(channelFlag, msgInfoReqList);
        } else if (MessageChannelEnum.SMS.getFlag().equals(channelFlag)) {
            result = this.sendCommonSmsMessage(channelFlag, msgInfoReqList);
        } else if (MessageChannelEnum.WECOM.getFlag().equals(channelFlag)) {
            result = this.sendCommonWeComMessage(channelFlag, msgInfoReqList);
        } else if (MessageChannelEnum.DINGTALK.getFlag().equals(channelFlag)) {
            result = this.sendCommonDingTalkMessage(channelFlag, msgInfoReqList);
        }
        return result;
    }

    private JSONObject sendCommonEmailMessage(String channelFlag, List<SendCommonChannelMsgReq.MsgInfoReq> msgInfoReqList) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"errorCount", (Object)0);
        jsonObject.put((Object)"errorMessage", (Object)"");
        for (int i = 0; i < msgInfoReqList.size(); ++i) {
            SendCommonChannelMsgReq.MsgInfoReq msgInfoReq = msgInfoReqList.get(i);
            try {
                Map emailMap;
                JSONObject emailMsg;
                String msg = this.validRequiredParam(msgInfoReq, channelFlag);
                if (StringUtils.isNotBlank((String)msg)) {
                    jsonObject.put((Object)"errorCount", (Object)(msgInfoReqList.size() - i));
                    jsonObject.put((Object)"errorMessage", (Object)msg);
                    break;
                }
                if (StringUtils.isBlank((String)msgInfoReq.getTenantId())) {
                    jsonObject.put((Object)"errorCount", (Object)(msgInfoReqList.size() - i));
                    jsonObject.put((Object)"errorMessage", (Object)"send email message param of tenantId is missing");
                    break;
                }
                if (CollectionUtils.isEmpty((Collection)msgInfoReq.getUserIdList()) && CollectionUtils.isEmpty((Collection)msgInfoReq.getCcUserIdList()) && CollectionUtils.isEmpty((Collection)msgInfoReq.getBccUserIdList())) {
                    jsonObject.put((Object)"errorCount", (Object)(msgInfoReqList.size() - i));
                    jsonObject.put((Object)"errorMessage", (Object)"send email message param of userIdList is empty");
                    break;
                }
                JSONObject msgJson = new JSONObject();
                msgJson.put((Object)"types", Collections.singletonList(channelFlag));
                if (CollectionUtils.isNotEmpty((Collection)msgInfoReq.getFileIdList())) {
                    msgJson.put((Object)"dmcAttachments", (Object)msgInfoReq.getFileIdList());
                    msgJson.put((Object)"dmcBucket", (Object)"intelligententry");
                }
                List blackWhiteList = this.semcService.queryBlackWhiteUserList(msgInfoReq.getTenantId(), null, null);
                if (msgInfoReq.getEvent() != null && StringUtils.isNotBlank((String)msgInfoReq.getEvent().getEventId())) {
                    List templateList = this.semcService.queryTemplateList(channelFlag, msgInfoReq.getEvent().getEventId(), msgInfoReq.getEvent().getRemark(), msgInfoReq.getTenantId());
                    if (CollectionUtils.isEmpty((Collection)templateList)) {
                        log.error("MessageControllerV2 | send common message eventId is not exist:{}, channelFlag:{}", (Object)msgInfoReq, (Object)channelFlag);
                        jsonObject.put((Object)"errorCount", (Object)(msgInfoReqList.size() - i));
                        jsonObject.put((Object)"errorMessage", (Object)("send common message eventId is not exist:" + msgInfoReq.getEvent().getEventId() + ", channelFlag:" + channelFlag));
                        break;
                    }
                    if (((QueryTemplateListResp)templateList.get(0)).getValidStatus().equals(Constants.VALID_STATUS_UNUSABLE)) {
                        log.error("MessageControllerV2 | send common message eventId is disabled:{}, channelFlag:{}", (Object)msgInfoReq, (Object)channelFlag);
                        jsonObject.put((Object)"errorCount", (Object)(msgInfoReqList.size() - i));
                        jsonObject.put((Object)"errorMessage", (Object)("send common message eventId is disabled:" + msgInfoReq.getEvent().getEventId() + ", channelFlag:" + channelFlag));
                        break;
                    }
                    msgJson.put((Object)"eventId", (Object)msgInfoReq.getEvent().getEventId());
                    emailMsg = new JSONObject();
                    emailMsg.put((Object)"data", (Object)msgInfoReq.getEvent().getVariableData());
                    msgJson.put((Object)"message", (Object)emailMsg);
                    emailMap = this.buildMessageReceiver(channelFlag, msgInfoReq, blackWhiteList, ((QueryTemplateListResp)templateList.get(0)).getId());
                } else {
                    msgJson.put((Object)"eventId", (Object)"ATHENA_SEMC_MESSAGE_DEFAULT");
                    JSONObject defaultJson = new JSONObject();
                    defaultJson.put((Object)"defaultVarKey", (Object)msgInfoReq.getText());
                    emailMsg = new JSONObject();
                    emailMsg.put((Object)"data", (Object)defaultJson);
                    msgJson.put((Object)"message", (Object)emailMsg);
                    emailMap = this.buildEmail(channelFlag, msgInfoReq, blackWhiteList);
                }
                this.sendGroupEmail(msgJson, emailMap);
                continue;
            }
            catch (Exception e) {
                jsonObject.put((Object)"errorCount", (Object)(msgInfoReqList.size() - i));
                jsonObject.put((Object)"errorMessage", (Object)e.getMessage());
                break;
            }
        }
        return jsonObject;
    }

    private void sendGroupEmail(JSONObject msgJson, Map<String, Map<String, List<String>>> emailMap) {
        for (Map.Entry<String, Map<String, List<String>>> stringMapEntry : emailMap.entrySet()) {
            List email;
            String language = stringMapEntry.getKey();
            Map<String, List<String>> emailUserList = stringMapEntry.getValue();
            if (CollectionUtils.isNotEmpty((Collection)emailUserList.get("email"))) {
                email = emailUserList.get("email").stream().distinct().collect(Collectors.toList());
                msgJson.put((Object)"contacts", (Object)StringUtils.join(email, (String)";"));
            } else {
                msgJson.put((Object)"contacts", (Object)";");
            }
            if (CollectionUtils.isNotEmpty((Collection)emailUserList.get("ccEmail"))) {
                email = emailUserList.get("ccEmail").stream().distinct().collect(Collectors.toList());
                msgJson.put((Object)"ccContacts", (Object)StringUtils.join(email, (String)";"));
            } else {
                msgJson.put((Object)"ccContacts", (Object)";");
            }
            if (CollectionUtils.isNotEmpty((Collection)emailUserList.get("bccEmail"))) {
                email = emailUserList.get("bccEmail").stream().distinct().collect(Collectors.toList());
                msgJson.put((Object)"bccContacts", (Object)StringUtils.join(email, (String)";"));
            } else {
                msgJson.put((Object)"bccContacts", (Object)";");
            }
            this.emcService.sendCommonChannelMsg(language, msgJson);
        }
    }

    private JSONObject sendCommonSmsMessage(String channelFlag, List<SendCommonChannelMsgReq.MsgInfoReq> msgInfoReqList) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"errorCount", (Object)0);
        jsonObject.put((Object)"errorMessage", (Object)"");
        for (int i = 0; i < msgInfoReqList.size(); ++i) {
            SendCommonChannelMsgReq.MsgInfoReq msgInfoReq = msgInfoReqList.get(i);
            try {
                if (msgInfoReq == null || StringUtils.isBlank((String)msgInfoReq.getEvent().getEventId())) {
                    jsonObject.put((Object)"errorCount", (Object)(msgInfoReqList.size() - i));
                    jsonObject.put((Object)"errorMessage", (Object)"send sms message param of eventId is missing");
                    break;
                }
                if (StringUtils.isBlank((String)msgInfoReq.getTenantId())) {
                    jsonObject.put((Object)"errorCount", (Object)(msgInfoReqList.size() - i));
                    jsonObject.put((Object)"errorMessage", (Object)"send sms message param of tenantId is missing");
                    break;
                }
                if (CollectionUtils.isEmpty((Collection)msgInfoReq.getUserIdList())) {
                    jsonObject.put((Object)"errorCount", (Object)(msgInfoReqList.size() - i));
                    jsonObject.put((Object)"errorMessage", (Object)"send sms message param of userIdList is empty");
                    break;
                }
                String msg = this.validEvent(channelFlag, msgInfoReq);
                if (StringUtils.isNotBlank((String)msg)) {
                    jsonObject.put((Object)"errorCount", (Object)(msgInfoReqList.size() - i));
                    jsonObject.put((Object)"errorMessage", (Object)msg);
                    break;
                }
                List blackWhiteList = this.semcService.queryBlackWhiteUserList(msgInfoReq.getTenantId(), null, null);
                Map emailMap = this.buildMessageReceiver(channelFlag, msgInfoReq, blackWhiteList, null);
                JSONObject msgJson = new JSONObject();
                JSONObject dataJsonObject = new JSONObject();
                dataJsonObject.put((Object)"data", (Object)msgInfoReq.getEvent().getVariableData());
                msgJson.put((Object)"message", (Object)dataJsonObject);
                msgJson.put((Object)"types", Collections.singletonList(channelFlag));
                msgJson.put((Object)"eventId", (Object)msgInfoReq.getEvent().getEventId());
                for (Map.Entry stringMapEntry : emailMap.entrySet()) {
                    String language = (String)stringMapEntry.getKey();
                    Map telephoneMap = (Map)stringMapEntry.getValue();
                    if (CollectionUtils.isNotEmpty((Collection)((Collection)telephoneMap.get("telephone")))) {
                        List telephoneList = ((List)telephoneMap.get("telephone")).stream().distinct().collect(Collectors.toList());
                        msgJson.put((Object)"telephone", (Object)StringUtils.join(telephoneList, (String)";"));
                    } else {
                        msgJson.put((Object)"telephone", (Object)";");
                    }
                    this.emcService.sendCommonChannelMsg(language, msgJson);
                }
                continue;
            }
            catch (Exception e) {
                jsonObject.put((Object)"errorCount", (Object)(msgInfoReqList.size() - i));
                jsonObject.put((Object)"errorMessage", (Object)e.getMessage());
                break;
            }
        }
        return jsonObject;
    }

    private JSONObject sendCommonWeComMessage(String channelFlag, List<SendCommonChannelMsgReq.MsgInfoReq> msgInfoReqList) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"errorCount", (Object)0);
        jsonObject.put((Object)"errorMessage", (Object)"");
        for (int i = 0; i < msgInfoReqList.size(); ++i) {
            SendCommonChannelMsgReq.MsgInfoReq msgInfoReq = msgInfoReqList.get(i);
            try {
                String msg = this.validRequiredParam(msgInfoReq, channelFlag);
                if (StringUtils.isNotBlank((String)msg)) {
                    jsonObject.put((Object)"errorCount", (Object)(msgInfoReqList.size() - i));
                    jsonObject.put((Object)"errorMessage", (Object)msg);
                    break;
                }
                if (StringUtils.isBlank((String)msgInfoReq.getTenantId())) {
                    jsonObject.put((Object)"errorCount", (Object)(msgInfoReqList.size() - i));
                    jsonObject.put((Object)"errorMessage", (Object)"send wecom message param of tenantId is missing");
                    break;
                }
                if (CollectionUtils.isEmpty((Collection)msgInfoReq.getUserIdList())) {
                    jsonObject.put((Object)"errorCount", (Object)(msgInfoReqList.size() - i));
                    jsonObject.put((Object)"errorMessage", (Object)"send wecom message param of userIdList is empty");
                    break;
                }
                List blackWhiteList = this.semcService.queryBlackWhiteUserList(msgInfoReq.getTenantId(), null, null);
                JSONObject msgJson = new JSONObject();
                msgJson.put((Object)"types", Collections.singletonList("weCom"));
                if (msgInfoReq.getEvent() != null && StringUtils.isNotBlank((String)msgInfoReq.getEvent().getEventId())) {
                    msg = this.validEvent(channelFlag, msgInfoReq);
                    if (StringUtils.isNotBlank((String)msg)) {
                        jsonObject.put((Object)"errorCount", (Object)(msgInfoReqList.size() - i));
                        jsonObject.put((Object)"errorMessage", (Object)msg);
                        break;
                    }
                    Map userMap = this.buildMessageReceiver(channelFlag, msgInfoReq, blackWhiteList, null);
                    msgJson.put((Object)"eventId", (Object)msgInfoReq.getEvent().getEventId());
                    JSONObject dataJson = new JSONObject();
                    dataJson.put((Object)"messageData", (Object)msgInfoReq.getEvent().getVariableData());
                    for (Map.Entry stringMapEntry : userMap.entrySet()) {
                        String language = (String)stringMapEntry.getKey();
                        Map map = (Map)stringMapEntry.getValue();
                        if (CollectionUtils.isNotEmpty((Collection)((Collection)map.get("userList")))) {
                            List userIdList = ((List)map.get("userList")).stream().distinct().collect(Collectors.toList());
                            dataJson.put((Object)"userList", userIdList);
                        } else {
                            dataJson.put((Object)"userList", (Object)Lists.newArrayList());
                        }
                        JSONObject dataJsonObject = new JSONObject();
                        dataJsonObject.put((Object)"data", (Object)dataJson);
                        msgJson.put((Object)"message", (Object)dataJsonObject);
                        this.emcService.sendCommonChannelMsg(language, msgJson);
                    }
                    continue;
                }
                msgJson.put((Object)"eventId", (Object)"ATHENA_SEMC_MESSAGE_DEFAULT");
                JSONObject defaultJson = new JSONObject();
                JSONObject varData = new JSONObject();
                varData.put((Object)"defaultVarKey", (Object)msgInfoReq.getText());
                defaultJson.put((Object)"messageData", (Object)varData);
                Map userMap = this.buildUserIdOrTelephone(channelFlag, msgInfoReq, blackWhiteList);
                for (Map.Entry stringMapEntry : userMap.entrySet()) {
                    String language = (String)stringMapEntry.getKey();
                    Map map = (Map)stringMapEntry.getValue();
                    if (CollectionUtils.isNotEmpty((Collection)((Collection)map.get("userList")))) {
                        List userIdList = ((List)map.get("userList")).stream().distinct().collect(Collectors.toList());
                        defaultJson.put((Object)"userList", userIdList);
                    } else {
                        defaultJson.put((Object)"userList", (Object)Lists.newArrayList());
                    }
                    JSONObject dataJsonObject = new JSONObject();
                    dataJsonObject.put((Object)"data", (Object)defaultJson);
                    msgJson.put((Object)"message", (Object)dataJsonObject);
                    this.emcService.sendCommonChannelMsg(language, msgJson);
                }
                continue;
            }
            catch (Exception e) {
                jsonObject.put((Object)"errorCount", (Object)(msgInfoReqList.size() - i));
                jsonObject.put((Object)"errorMessage", (Object)e.getMessage());
                break;
            }
        }
        return jsonObject;
    }

    private JSONObject sendCommonDingTalkMessage(String channelFlag, List<SendCommonChannelMsgReq.MsgInfoReq> msgInfoReqList) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"errorCount", (Object)0);
        jsonObject.put((Object)"errorMessage", (Object)"");
        for (int i = 0; i < msgInfoReqList.size(); ++i) {
            SendCommonChannelMsgReq.MsgInfoReq msgInfoReq = msgInfoReqList.get(i);
            try {
                if (msgInfoReq.getEvent() == null || StringUtils.isBlank((String)msgInfoReq.getEvent().getEventId())) {
                    jsonObject.put((Object)"errorCount", (Object)(msgInfoReqList.size() - i));
                    jsonObject.put((Object)"errorMessage", (Object)"send dingTalk message param of eventId is missing");
                    break;
                }
                if (StringUtils.isBlank((String)msgInfoReq.getTenantId())) {
                    jsonObject.put((Object)"errorCount", (Object)(msgInfoReqList.size() - i));
                    jsonObject.put((Object)"errorMessage", (Object)"send dingTalk message param of tenantId is missing");
                    break;
                }
                if (StringUtils.isBlank((String)msgInfoReq.getAppId())) {
                    jsonObject.put((Object)"errorCount", (Object)(msgInfoReqList.size() - i));
                    jsonObject.put((Object)"errorMessage", (Object)"send dingTalk message param of appId is missing");
                    break;
                }
                if (CollectionUtils.isEmpty((Collection)msgInfoReq.getUserIdList())) {
                    jsonObject.put((Object)"errorCount", (Object)(msgInfoReqList.size() - i));
                    jsonObject.put((Object)"errorMessage", (Object)"send dingTalk message param of userIdList is empty");
                    break;
                }
                String msg = this.validEvent(channelFlag, msgInfoReq);
                if (StringUtils.isNotBlank((String)msg)) {
                    jsonObject.put((Object)"errorCount", (Object)(msgInfoReqList.size() - i));
                    jsonObject.put((Object)"errorMessage", (Object)msg);
                    break;
                }
                List blackWhiteList = this.semcService.queryBlackWhiteUserList(msgInfoReq.getTenantId(), null, null);
                Map userMap = this.buildMessageReceiver(channelFlag, msgInfoReq, blackWhiteList, null);
                JSONObject msgJson = new JSONObject();
                msgJson.put((Object)"types", Collections.singletonList(channelFlag));
                msgJson.put((Object)"eventId", (Object)msgInfoReq.getEvent().getEventId());
                JSONObject dataJson = new JSONObject();
                dataJson.put((Object)"appId", (Object)msgInfoReq.getAppId());
                dataJson.put((Object)"corpId", (Object)msgInfoReq.getTenantId());
                dataJson.put((Object)"tenantId", (Object)msgInfoReq.getTenantId());
                dataJson.put((Object)"messageData", (Object)msgInfoReq.getEvent().getVariableData());
                for (Map.Entry stringMapEntry : userMap.entrySet()) {
                    String language = (String)stringMapEntry.getKey();
                    Map map = (Map)stringMapEntry.getValue();
                    if (CollectionUtils.isNotEmpty((Collection)((Collection)map.get("userList")))) {
                        List userIdList = ((List)map.get("userList")).stream().distinct().collect(Collectors.toList());
                        dataJson.put((Object)"userList", userIdList);
                    } else {
                        dataJson.put((Object)"userList", (Object)Lists.newArrayList());
                    }
                    JSONObject dataJsonObject = new JSONObject();
                    dataJsonObject.put((Object)"data", (Object)dataJson);
                    msgJson.put((Object)"message", (Object)dataJsonObject);
                    this.emcService.sendCommonChannelMsg(language, msgJson);
                }
                continue;
            }
            catch (Exception e) {
                jsonObject.put((Object)"errorCount", (Object)(msgInfoReqList.size() - i));
                jsonObject.put((Object)"errorMessage", (Object)e.getMessage());
                break;
            }
        }
        return jsonObject;
    }

    private String validRequiredParam(SendCommonChannelMsgReq.MsgInfoReq msgInfoReq, String channelFlag) {
        if ((msgInfoReq.getEvent() == null || StringUtils.isBlank((String)msgInfoReq.getEvent().getEventId())) && StringUtils.isBlank((String)msgInfoReq.getText())) {
            log.error("MessageControllerV2 | send common message param is missing:{}, channelFlag:{}", (Object)msgInfoReq, (Object)channelFlag);
            return "send common message param is missing : [event|text]";
        }
        return "";
    }

    private String validEvent(String channelFlag, SendCommonChannelMsgReq.MsgInfoReq msgInfoReq) {
        List templateList = this.semcService.queryTemplateList(channelFlag, msgInfoReq.getEvent().getEventId(), msgInfoReq.getEvent().getRemark(), msgInfoReq.getTenantId());
        if (CollectionUtils.isEmpty((Collection)templateList)) {
            log.error("MessageControllerV2 | send common message eventId is not exist:{}, channelFlag:{}", (Object)msgInfoReq, (Object)channelFlag);
            return "send common message eventId is not exist:" + msgInfoReq.getEvent().getEventId() + ", channelFlag:" + channelFlag;
        }
        if (((QueryTemplateListResp)templateList.get(0)).getValidStatus().equals(Constants.VALID_STATUS_UNUSABLE)) {
            log.error("MessageControllerV2 | send common message eventId is disabled:{}, channelFlag:{}", (Object)msgInfoReq, (Object)channelFlag);
            return "send common message eventId is disabled:" + msgInfoReq.getEvent().getEventId() + ", channelFlag:" + channelFlag;
        }
        return "";
    }

    private Map<String, Map<String, List<String>>> buildMessageReceiver(String channelFlag, SendCommonChannelMsgReq.MsgInfoReq msgInfoReq, List<QueryBlackWhiteListResp> blackWhiteList, String templateId) {
        Map<String, HashMap> receiverMap;
        block17: {
            QueryTemplateRelResp queryTemplateRelResp;
            block18: {
                block16: {
                    receiverMap = Maps.newHashMap();
                    queryTemplateRelResp = this.semcService.queryRelPerson(msgInfoReq.getTenantId(), msgInfoReq.getEvent().getEventId(), channelFlag, templateId, null);
                    if (!MessageChannelEnum.EMAIL.getFlag().equals(channelFlag)) break block16;
                    if (CollectionUtils.isEmpty((Collection)queryTemplateRelResp.getContactList()) && CollectionUtils.isEmpty((Collection)queryTemplateRelResp.getCcContactList()) && CollectionUtils.isEmpty((Collection)queryTemplateRelResp.getBccContactList())) {
                        receiverMap = this.buildEmail(channelFlag, msgInfoReq, blackWhiteList);
                    } else {
                        queryTemplateRelResp.setContactList(CollectionUtils.isNotEmpty((Collection)queryTemplateRelResp.getContactList()) ? queryTemplateRelResp.getContactList() : Lists.newArrayList());
                        queryTemplateRelResp.setCcContactList(CollectionUtils.isNotEmpty((Collection)queryTemplateRelResp.getCcContactList()) ? queryTemplateRelResp.getCcContactList() : Lists.newArrayList());
                        queryTemplateRelResp.setBccContactList(CollectionUtils.isNotEmpty((Collection)queryTemplateRelResp.getBccContactList()) ? queryTemplateRelResp.getBccContactList() : Lists.newArrayList());
                        if (CollectionUtils.isNotEmpty(blackWhiteList)) {
                            ArrayList blackEmailList = Lists.newArrayList();
                            ArrayList whiteList = Lists.newArrayList();
                            this.buildBlackWhiteParamList(channelFlag, blackWhiteList, (List)blackEmailList, (List)whiteList);
                            queryTemplateRelResp.getContactList().removeIf(x -> blackEmailList.contains(x.getValue()));
                            whiteList.forEach(x -> {
                                QueryTemplateRelResp.RelPersonDTO personDTO = new QueryTemplateRelResp.RelPersonDTO();
                                personDTO.setValue(x.getEmail());
                                personDTO.setLanguage(x.getLanguage());
                                queryTemplateRelResp.getContactList().add(personDTO);
                            });
                            queryTemplateRelResp.getCcContactList().removeIf(x -> blackEmailList.contains(x.getValue()));
                            queryTemplateRelResp.getBccContactList().removeIf(x -> blackEmailList.contains(x.getValue()));
                        }
                        ArrayList userList = Lists.newArrayList();
                        userList.addAll(queryTemplateRelResp.getContactList());
                        userList.addAll(queryTemplateRelResp.getCcContactList());
                        userList.addAll(queryTemplateRelResp.getBccContactList());
                        List emailRespList = queryTemplateRelResp.getContactList().stream().map(QueryTemplateRelResp.RelPersonDTO::getValue).collect(Collectors.toList());
                        List list = queryTemplateRelResp.getCcContactList().stream().map(QueryTemplateRelResp.RelPersonDTO::getValue).collect(Collectors.toList());
                        List bccEmailRespList = queryTemplateRelResp.getBccContactList().stream().map(QueryTemplateRelResp.RelPersonDTO::getValue).collect(Collectors.toList());
                        ArrayList emailList = Lists.newArrayList();
                        ArrayList ccEmailList = Lists.newArrayList();
                        ArrayList bccEmailList = Lists.newArrayList();
                        Map<String, List<QueryTemplateRelResp.RelPersonDTO>> languageMap = userList.stream().collect(Collectors.groupingBy(QueryTemplateRelResp.RelPersonDTO::getLanguage));
                        for (Map.Entry<String, List<QueryTemplateRelResp.RelPersonDTO>> entry : languageMap.entrySet()) {
                            String language = entry.getKey();
                            List<QueryTemplateRelResp.RelPersonDTO> personList = entry.getValue();
                            HashMap typeMap = Maps.newHashMap();
                            for (QueryTemplateRelResp.RelPersonDTO userDTO : personList) {
                                if (CollectionUtils.isNotEmpty(emailRespList) && emailRespList.contains(userDTO.getValue())) {
                                    emailList.add(userDTO.getValue());
                                    continue;
                                }
                                if (CollectionUtils.isNotEmpty(list) && list.contains(userDTO.getValue())) {
                                    ccEmailList.add(userDTO.getValue());
                                    continue;
                                }
                                if (!CollectionUtils.isNotEmpty(bccEmailRespList) || !bccEmailRespList.contains(userDTO.getValue())) continue;
                                bccEmailList.add(userDTO.getValue());
                            }
                            typeMap.put("email", emailList.stream().distinct().collect(Collectors.toList()));
                            typeMap.put("ccEmail", ccEmailList.stream().distinct().collect(Collectors.toList()));
                            typeMap.put("bccEmail", bccEmailList.stream().distinct().collect(Collectors.toList()));
                            receiverMap.put(language, typeMap);
                        }
                    }
                    break block17;
                }
                if (!MessageChannelEnum.SMS.getFlag().equals(channelFlag)) break block18;
                if (CollectionUtils.isEmpty((Collection)queryTemplateRelResp.getContactList())) {
                    receiverMap = this.buildUserIdOrTelephone(channelFlag, msgInfoReq, blackWhiteList);
                } else {
                    if (CollectionUtils.isNotEmpty(blackWhiteList)) {
                        ArrayList blackTelephoneList = Lists.newArrayList();
                        ArrayList whiteList = Lists.newArrayList();
                        this.buildBlackWhiteParamList(channelFlag, blackWhiteList, (List)blackTelephoneList, (List)whiteList);
                        queryTemplateRelResp.getContactList().removeIf(x -> blackTelephoneList.contains(x.getValue()));
                        whiteList.forEach(x -> {
                            QueryTemplateRelResp.RelPersonDTO personDTO = new QueryTemplateRelResp.RelPersonDTO();
                            personDTO.setValue(x.getTelephone());
                            personDTO.setLanguage(x.getLanguage());
                            queryTemplateRelResp.getContactList().add(personDTO);
                        });
                    }
                    Map<String, List<QueryTemplateRelResp.RelPersonDTO>> languageMap = queryTemplateRelResp.getContactList().stream().collect(Collectors.groupingBy(QueryTemplateRelResp.RelPersonDTO::getLanguage));
                    for (Map.Entry entry : languageMap.entrySet()) {
                        String language = (String)entry.getKey();
                        List personList = (List)entry.getValue();
                        HashMap typeMap = Maps.newHashMap();
                        List telephoneList = personList.stream().map(QueryTemplateRelResp.RelPersonDTO::getValue).distinct().collect(Collectors.toList());
                        typeMap.put("telephone", telephoneList);
                        receiverMap.put(language, typeMap);
                    }
                }
                break block17;
            }
            if (!MessageChannelEnum.WECOM.getFlag().equals(channelFlag) && !MessageChannelEnum.DINGTALK.getFlag().equals(channelFlag)) break block17;
            if (CollectionUtils.isEmpty((Collection)queryTemplateRelResp.getContactList())) {
                receiverMap = this.buildUserIdOrTelephone(channelFlag, msgInfoReq, blackWhiteList);
            } else {
                if (CollectionUtils.isNotEmpty(blackWhiteList)) {
                    List whiteIdList = blackWhiteList.stream().filter(x -> x.getType().equals(Constants.WHITE_TYPE)).map(QueryBlackWhiteListResp::getUserId).collect(Collectors.toList());
                    List userInfoList = this.queryUserInfo(whiteIdList, channelFlag);
                    for (IamUserDTO iamUserDTO : userInfoList) {
                        QueryTemplateRelResp.RelPersonDTO personDTO = new QueryTemplateRelResp.RelPersonDTO();
                        personDTO.setValue(iamUserDTO.getUserId());
                        personDTO.setLanguage(iamUserDTO.getLanguage());
                        queryTemplateRelResp.getContactList().add(personDTO);
                    }
                    List list = blackWhiteList.stream().filter(x -> x.getType().equals(Constants.BLACK_TYPE)).map(QueryBlackWhiteListResp::getUserId).collect(Collectors.toList());
                    queryTemplateRelResp.getContactList().removeIf(x -> blackUserIdList.contains(x.getValue()));
                }
                Map<String, List<QueryTemplateRelResp.RelPersonDTO>> languageMap = queryTemplateRelResp.getContactList().stream().collect(Collectors.groupingBy(QueryTemplateRelResp.RelPersonDTO::getLanguage));
                for (Map.Entry<String, List<QueryTemplateRelResp.RelPersonDTO>> entry : languageMap.entrySet()) {
                    String language = entry.getKey();
                    List<QueryTemplateRelResp.RelPersonDTO> personList = entry.getValue();
                    HashMap typeMap = Maps.newHashMap();
                    List userIdList = personList.stream().map(QueryTemplateRelResp.RelPersonDTO::getValue).distinct().collect(Collectors.toList());
                    typeMap.put("userList", userIdList);
                    receiverMap.put(language, typeMap);
                }
            }
        }
        return receiverMap;
    }

    private void buildBlackWhiteParamList(String channelFlag, List<QueryBlackWhiteListResp> blackWhiteList, List<String> blackEmailList, List<IamUserDTO> whiteList) {
        List blackWhiteIdList = blackWhiteList.stream().map(QueryBlackWhiteListResp::getUserId).collect(Collectors.toList());
        List userInfoList = this.queryUserInfo(blackWhiteIdList, channelFlag);
        List blackIdList = blackWhiteList.stream().filter(x -> x.getType().equals(Constants.BLACK_TYPE)).map(QueryBlackWhiteListResp::getUserId).collect(Collectors.toList());
        for (IamUserDTO iamUserDTO : userInfoList) {
            if (blackIdList.contains(iamUserDTO.getUserId())) {
                if (MessageChannelEnum.EMAIL.getFlag().equals(channelFlag)) {
                    blackEmailList.add(iamUserDTO.getEmail());
                    continue;
                }
                if (!MessageChannelEnum.SMS.getFlag().equals(channelFlag)) continue;
                blackEmailList.add(iamUserDTO.getTelephone());
                continue;
            }
            whiteList.add(iamUserDTO);
        }
    }

    private Map<String, Map<String, List<String>>> buildUserIdOrTelephone(String channelFlag, SendCommonChannelMsgReq.MsgInfoReq msgInfoReq, List<QueryBlackWhiteListResp> blackWhiteList) {
        HashMap receiverMap = Maps.newHashMap();
        List<Object> blackIdList = Lists.newArrayList();
        List<Object> whiteIdList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(blackWhiteList)) {
            blackIdList = blackWhiteList.stream().filter(x -> x.getType().equals(Constants.BLACK_TYPE)).map(QueryBlackWhiteListResp::getUserId).collect(Collectors.toList());
            whiteIdList = blackWhiteList.stream().filter(x -> x.getType().equals(Constants.WHITE_TYPE)).map(QueryBlackWhiteListResp::getUserId).collect(Collectors.toList());
        }
        msgInfoReq.getUserIdList().removeIf(blackIdList::contains);
        msgInfoReq.getUserIdList().addAll(whiteIdList);
        List userInfoList = this.queryUserInfo(msgInfoReq.getUserIdList(), channelFlag);
        Map<String, List<IamUserDTO>> languageMap = userInfoList.stream().collect(Collectors.groupingBy(IamUserDTO::getLanguage));
        languageMap.forEach((k, v) -> {
            HashMap typeMap = Maps.newHashMap();
            if (MessageChannelEnum.SMS.getFlag().equals(channelFlag)) {
                List telephoneList = v.stream().map(IamUserDTO::getTelephone).collect(Collectors.toList());
                typeMap.put("telephone", telephoneList);
            } else if (MessageChannelEnum.WECOM.getFlag().equals(channelFlag) || MessageChannelEnum.DINGTALK.getFlag().equals(channelFlag)) {
                List userList = v.stream().map(IamUserDTO::getUserId).collect(Collectors.toList());
                typeMap.put("userList", userList);
            }
            receiverMap.put(k, typeMap);
        });
        return receiverMap;
    }

    private Map<String, Map<String, List<String>>> buildEmail(String channelFlag, SendCommonChannelMsgReq.MsgInfoReq msgInfoReq, List<QueryBlackWhiteListResp> blackWhiteList) {
        ConcurrentMap emailMap = Maps.newConcurrentMap();
        List<Object> blackIdList = Lists.newArrayList();
        List<Object> whiteIdList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(blackWhiteList)) {
            blackIdList = blackWhiteList.stream().filter(x -> x.getType().equals(Constants.BLACK_TYPE)).map(QueryBlackWhiteListResp::getUserId).collect(Collectors.toList());
            whiteIdList = blackWhiteList.stream().filter(x -> x.getType().equals(Constants.WHITE_TYPE)).map(QueryBlackWhiteListResp::getUserId).collect(Collectors.toList());
        }
        ArrayList userIdList = Lists.newArrayList();
        userIdList.addAll(CollectionUtils.isNotEmpty((Collection)msgInfoReq.getUserIdList()) ? msgInfoReq.getUserIdList() : Lists.newArrayList());
        userIdList.addAll(CollectionUtils.isNotEmpty((Collection)msgInfoReq.getCcUserIdList()) ? msgInfoReq.getCcUserIdList() : Lists.newArrayList());
        userIdList.addAll(CollectionUtils.isNotEmpty((Collection)msgInfoReq.getBccUserIdList()) ? msgInfoReq.getBccUserIdList() : Lists.newArrayList());
        userIdList.removeIf(blackIdList::contains);
        userIdList.addAll(whiteIdList);
        List userInfoList = this.queryUserInfo((List)userIdList, channelFlag);
        Map<String, List<IamUserDTO>> languageMap = userInfoList.stream().collect(Collectors.groupingBy(IamUserDTO::getLanguage));
        for (Map.Entry<String, List<IamUserDTO>> entry : languageMap.entrySet()) {
            String language = entry.getKey();
            List<IamUserDTO> valueList = entry.getValue();
            HashMap typeMap = Maps.newHashMap();
            ArrayList emailList = Lists.newArrayList();
            ArrayList ccEmailList = Lists.newArrayList();
            ArrayList bccEmailList = Lists.newArrayList();
            for (IamUserDTO userDTO : valueList) {
                if (StringUtils.isNotBlank((String)userDTO.getEmail()) && (CollectionUtils.isNotEmpty((Collection)msgInfoReq.getUserIdList()) && msgInfoReq.getUserIdList().contains(userDTO.getUserId()) || whiteIdList.contains(userDTO.getUserId()))) {
                    emailList.add(userDTO.getEmail());
                    continue;
                }
                if (StringUtils.isNotBlank((String)userDTO.getEmail()) && CollectionUtils.isNotEmpty((Collection)msgInfoReq.getCcUserIdList()) && msgInfoReq.getCcUserIdList().contains(userDTO.getUserId())) {
                    ccEmailList.add(userDTO.getEmail());
                    continue;
                }
                if (!StringUtils.isNotBlank((String)userDTO.getEmail()) || !CollectionUtils.isNotEmpty((Collection)msgInfoReq.getBccUserIdList()) || !msgInfoReq.getBccUserIdList().contains(userDTO.getUserId())) continue;
                bccEmailList.add(userDTO.getEmail());
            }
            typeMap.put("email", emailList);
            typeMap.put("ccEmail", ccEmailList);
            typeMap.put("bccEmail", bccEmailList);
            emailMap.put(language, typeMap);
        }
        return emailMap;
    }

    private List<IamUserDTO> queryUserInfo(List<String> userIdList, String channelFlag) {
        List<IamUserDTO> userInfoList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(userIdList)) {
            log.error("MessageControllerV2 | send common message query user info param userId is empty, channelFlag:{}", (Object)channelFlag);
            return userInfoList;
        }
        userInfoList = this.iamService.queryUserInfoList(userIdList);
        if (CollectionUtils.isEmpty((Collection)userInfoList)) {
            return userInfoList;
        }
        userInfoList.forEach(x -> {
            if (StringUtils.isBlank((String)x.getLanguage()) || "zh_CN".equals(x.getLanguage())) {
                x.setLanguage("zh-CN");
            }
            if (StringUtils.isNotBlank((String)x.getLanguage()) && "zh_TW".equals(x.getLanguage())) {
                x.setLanguage("zh-TW");
            }
            if (StringUtils.isNotBlank((String)x.getLanguage()) && "en_US".equals(x.getLanguage())) {
                x.setLanguage("en-US");
            }
        });
        return userInfoList;
    }

    public void sendMsgAndEmail(List<MsgAndEmailBatchDTO> msgAndEmailBatchDTOList) {
        log.info("\u3010\u53d1\u9001\u6d88\u606f/\u90ae\u4ef6\u3011\uff1a{}", (Object)JsonUtils.objectToString(msgAndEmailBatchDTOList));
        for (MsgAndEmailBatchDTO msgAndEmail : msgAndEmailBatchDTOList) {
            List recivers = msgAndEmail.getRecivers();
            List userInfoList = this.iamService.queryUserInfoList(recivers);
            List userMetadataList = this.iamService.queryUserMetadataList(recivers);
            if (CollectionUtils.isEmpty((Collection)userInfoList) || null == msgAndEmail.getContent() || MapUtils.isEmpty((Map)msgAndEmail.getContent().getTitle()) || MapUtils.isEmpty((Map)msgAndEmail.getContent().getMsg())) continue;
            ArrayList<UserMsgAndEmailDTO> userMsgAndEmailDTOList = new ArrayList<UserMsgAndEmailDTO>();
            for (IamUserDTO user : userInfoList) {
                UserMsgAndEmailDTO userMsgAndEmail = new UserMsgAndEmailDTO();
                userMsgAndEmail.setUserId(user.getUserId());
                userMsgAndEmail.setLocale(user.getLanguage());
                userMsgAndEmail.setEmail(user.getEmail());
                Optional<PersonalizedDto> optional = userMetadataList.stream().filter(x -> x.getUserId().equals(user.getUserId())).findFirst();
                if (optional.isPresent()) {
                    userMsgAndEmail.setMessageSendType(optional.get().getValue());
                }
                userMsgAndEmailDTOList.add(userMsgAndEmail);
            }
            Map<String, List<UserMsgAndEmailDTO>> langUserMap = userMsgAndEmailDTOList.stream().collect(Collectors.groupingBy(UserMsgAndEmailDTO::getLocale));
            for (String lang : langUserMap.keySet()) {
                String ssoUrl = this.getSsoUrl(msgAndEmail);
                String mobileDetailUrl = this.getDetailUrl(msgAndEmail, ssoUrl, "mobile");
                String emailDetailUrl = this.getDetailUrl(msgAndEmail, ssoUrl, "email");
                List userList = langUserMap.get(lang).stream().filter(x -> MsgSendTypeEnum.IM.getName().equals(x.getMessageSendType()) || MsgSendTypeEnum.IM_AND_EMAIL.getName().equals(x.getMessageSendType())).map(UserMsgAndEmailDTO::getUserId).distinct().collect(Collectors.toList());
                this.sendImMessage(msgAndEmail, lang, userList, mobileDetailUrl);
                List userMsgAndEmailDTOS = langUserMap.get(lang).stream().filter(x -> MsgSendTypeEnum.EMAIL.getName().equals(x.getMessageSendType()) || MsgSendTypeEnum.MAIL.getName().equals(x.getMessageSendType()) || MsgSendTypeEnum.IM_AND_EMAIL.getName().equals(x.getMessageSendType())).collect(Collectors.toList());
                this.sendEmail(msgAndEmail, lang, userMsgAndEmailDTOS, emailDetailUrl);
            }
        }
    }

    private void sendImMessage(MsgAndEmailBatchDTO msgAndEmail, String lang, List<String> userList, String detailUrl) {
        try {
            MessageDO messageDO = new MessageDO();
            messageDO.setGid(UUID.randomUUID().toString());
            messageDO.setSource(msgAndEmail.getSource());
            messageDO.setType("linkUrl");
            if (null != msgAndEmail.getNoticeMobileApp()) {
                messageDO.setNoticeMobileApp(msgAndEmail.getNoticeMobileApp());
            } else {
                messageDO.setNoticeMobileApp(Boolean.valueOf(true));
            }
            messageDO.setTenantId(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            messageDO.setSendDate(LocalDateTime.now());
            messageDO.setDetailUrl(detailUrl);
            JSONObject contentMap = new JSONObject();
            contentMap.put((Object)"title", msgAndEmail.getContent().getTitle().get(lang));
            contentMap.put((Object)"msg", msgAndEmail.getContent().getMsg().get(lang));
            contentMap.put((Object)"linkUrl", (Object)msgAndEmail.getLinkUrl());
            contentMap.put((Object)"config", (Object)JSONObject.fromObject((Object)msgAndEmail.getConfig()));
            contentMap.put((Object)"status", (Object)0);
            messageDO.setContent(contentMap);
            messageDO.setTitle((String)msgAndEmail.getContent().getTitle().get(lang));
            MessageBatchUserDTO messageBatchUserDTO = new MessageBatchUserDTO();
            messageBatchUserDTO.setMessage(messageDO);
            messageBatchUserDTO.setTenantId(messageDO.getTenantId());
            messageBatchUserDTO.setUserIdList(userList);
            ArrayList<MessageBatchUserDTO> messageList = new ArrayList<MessageBatchUserDTO>();
            messageList.add(messageBatchUserDTO);
            log.info("MessageServiceV2Impl-sendImMessage-messageList:{}", (Object)JsonUtils.objectToString(messageList));
            this.newMessageForBatchUsers(messageList);
            ArrayList<MessageRemindDTO> appMessageList = new ArrayList<MessageRemindDTO>();
            MessageRemindDTO appMessageDTO = MessageRemindDTO.convert((MessageDO)messageDO);
            ArrayList receiverDTOS = new ArrayList();
            userList.forEach(userId -> {
                HashMap<String, String> receiverDTO = new HashMap<String, String>();
                receiverDTO.put("tenantId", messageDO.getTenantId());
                receiverDTO.put("userId", (String)userId);
                receiverDTOS.add(receiverDTO);
            });
            appMessageDTO.setReceivers(receiverDTOS);
            appMessageList.add(appMessageDTO);
            this.messageSendService.sendMessageRemindToClient(appMessageList);
        }
        catch (Exception e) {
            log.error("sendImMessage,error:{}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void sendEmail(MsgAndEmailBatchDTO msgAndEmail, String lang, List<UserMsgAndEmailDTO> userList, String detailLinkUrl) {
        try {
            log.info("sendEmail-langName:{}", (Object)lang);
            HashMap contentMap = new HashMap();
            contentMap.put("title", msgAndEmail.getContent().getTitle().get(lang));
            contentMap.put("msg", msgAndEmail.getContent().getMsg().get(lang));
            contentMap.put("linkUrl", detailLinkUrl);
            JSONObject emailMsg = new JSONObject();
            emailMsg.put((Object)"data", contentMap);
            List contacts = userList.stream().map(UserMsgAndEmailDTO::getEmail).distinct().collect(Collectors.toList());
            JSONObject emailJson = new JSONObject();
            if (StringUtils.isEmpty((String)msgAndEmail.getEmailTemplateId())) {
                emailJson.put((Object)"eventId", (Object)"ATHENA_NOTICE_LINK");
            } else {
                emailJson.put((Object)"eventId", (Object)msgAndEmail.getEmailTemplateId());
            }
            emailJson.put((Object)"message", (Object)emailMsg);
            emailJson.put((Object)"contacts", (Object)StringUtils.join(contacts, (String)";"));
            log.info("[MessageServiceV2Impl_sendEmail emailJson]:{}", (Object)emailJson);
            this.emcService.sendEmail(lang, emailJson);
        }
        catch (Exception e) {
            log.error("sendEmail,error:{}", (Throwable)e);
        }
    }

    private String getDetailUrl(MsgAndEmailBatchDTO msgAndEmail, String ssoUrl, String msgSendType) {
        String detailUrl = "";
        if (msgAndEmail.getConfig() == null || msgAndEmail.getConfig().getSsoLogin() == null || !msgAndEmail.getConfig().getSsoLogin().booleanValue()) {
            return msgAndEmail.getLinkUrl();
        }
        if (StringUtils.isEmpty((String)ssoUrl)) {
            return detailUrl;
        }
        if (StringUtils.isEmpty((String)msgAndEmail.getLinkUrl())) {
            return ssoUrl;
        }
        if ("email".equals(msgSendType)) {
            detailUrl = ssoUrl + "/" + msgAndEmail.getLinkUrl();
        } else if ("mobile".equals(msgSendType)) {
            detailUrl = String.format("%s/sso-login?userToken=${mobile_user_token}&dwLang=${locale}", ssoUrl);
            detailUrl = detailUrl + "&routerLink=" + msgAndEmail.getLinkUrl();
        }
        return detailUrl;
    }

    private String getSsoUrl(MsgAndEmailBatchDTO msgAndEmail) {
        String ssoUrl = "";
        GetSsoUrlReq req = new GetSsoUrlReq();
        req.setSsoLogin(Boolean.FALSE);
        req.setAppType(msgAndEmail.getConfig().getAppType());
        req.setSsoAppCode(msgAndEmail.getConfig().getSsoAppCode());
        GetSsoUrlResp resp = this.semcService.getSsoUrl(req);
        if (null != resp) {
            ssoUrl = resp.getAddress();
        }
        return ssoUrl;
    }
}

