/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.domain.message.subscriber;

import com.digiwin.athena.aim.domain.message.event.WecomMessageEvent;
import com.digiwin.athena.aim.domain.message.model.MessageBatchUserDTO;
import com.digiwin.athena.aim.domain.message.service.WecomMessageService;
import com.digiwin.athena.aim.infrastructure.semc.SemcService;
import com.google.common.eventbus.Subscribe;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class WecomMessageSubscriber {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WecomMessageSubscriber.class);
    @Resource
    private WecomMessageService wecomMessageService;
    @Resource
    private SemcService semcService;
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    public static final String CACHE_KEY = "aim:msg:channel:";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    public void handle(WecomMessageEvent event) {
        if (MapUtils.isNotEmpty((Map)event.getMdcContext())) {
            MDC.setContextMap((Map)event.getMdcContext());
        }
        log.info("send wecom message event\uff1a{}", (Object)(CollectionUtils.isNotEmpty((Collection)event.getMessageBatchUserList()) ? event.getMessageBatchUserList().size() : 0));
        long start = System.currentTimeMillis();
        try {
            for (MessageBatchUserDTO message : event.getMessageBatchUserList()) {
                String messageChannelKey = CACHE_KEY + message.getTenantId();
                String messageChannel = (String)this.stringRedisTemplate.opsForValue().get((Object)messageChannelKey);
                if (StringUtils.isBlank((String)messageChannel) && StringUtils.isBlank((String)(messageChannel = this.semcService.queryMessageChannel(message.getTenantId())))) {
                    this.stringRedisTemplate.opsForValue().set((Object)messageChannelKey, (Object)"noExist", 1L, TimeUnit.DAYS);
                }
                log.info("send wecom message for batch users | message channel:{}, message:{}", (Object)messageChannel, (Object)message);
                if (!StringUtils.isNotBlank((String)messageChannel) || !messageChannel.contains("wecom")) continue;
                this.wecomMessageService.sendWecomMessage(message);
            }
        }
        catch (Exception ex) {
            log.error("send wecom message occur error", (Throwable)ex);
        }
        finally {
            log.info("send wecom message event\u7ed3\u675f\u65f6\u95f4\uff1a{}", (Object)(System.currentTimeMillis() - start));
            try {
                if (MapUtils.isNotEmpty((Map)event.getMdcContext())) {
                    MDC.clear();
                }
            }
            catch (Exception e) {
                log.error("logMdcRemoveEx", (Throwable)e);
            }
        }
    }
}

