/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.infrastructure.atmc.impl;

import com.digiwin.athena.aim.app.env.EnvProperties;
import com.digiwin.athena.aim.infrastructure.atmc.AtmcService;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import lombok.Generated;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class AtmcServiceImpl
implements AtmcService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AtmcServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;

    public String getShareCode(String taskId, String taskType) {
        String url = this.envProperties.getAtmcUri() + "/api/atmc/v1/share/code?taskType=%s&taskId=%s";
        url = String.format(url, taskType, taskId);
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        headers.add("token", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        JSONObject reqObject = JSONObject.fromObject((Object)this);
        HttpEntity httpEntity = new HttpEntity((Object)reqObject, (MultiValueMap)headers);
        try {
            log.info("\u8bf7\u6c42ATMC\u83b7\u53d6\u5206\u4eab\u7801 \u5165\u53c2:{}", (Object)JsonUtils.objectToString((Object)httpEntity));
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            log.info("\u8bf7\u6c42ATMC\u83b7\u53d6\u5206\u4eab\u7801\uff0c\u5165\u53c2url\uff1a{}, \u54cd\u5e94\u5185\u5bb9\uff1a{}", (Object)url, ((BaseResultDTO)respEntity.getBody()).getResponse());
            if (null != respEntity.getBody() && ((BaseResultDTO)respEntity.getBody()).isOK()) {
                return (String)((BaseResultDTO)respEntity.getBody()).getResponse();
            }
        }
        catch (BusinessException ex) {
            log.error("\u8bf7\u6c42ATMC\u83b7\u53d6\u5206\u4eab\u7801\u62a5\u9519\uff0c\u5165\u53c2url\uff1a{}, ex\uff1a{}", (Object)url, (Object)ex);
        }
        return "";
    }
}

