/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.infrastructure.concurrent.pool;

import com.digiwin.athena.aim.infrastructure.concurrent.pool.AbstractDynamicThreadPool;
import com.digiwin.athena.aim.infrastructure.concurrent.pool.DynamicThreadPoolBean;
import com.jugg.agile.framework.core.config.JaPropertyListener;
import com.jugg.agile.framework.core.util.concurrent.migration.JaTtlExecutors;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractDynamicThreadPool
implements InitializingBean,
ExecutorService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractDynamicThreadPool.class);
    protected ExecutorService executorService;
    protected DynamicThreadPoolBean threadPoolExecutor;

    public void afterPropertiesSet() throws Exception {
        this.initializeThreadPool();
        this.configureChangeListener();
        this.addShutdownHook();
    }

    private void configureChangeListener() {
        try {
            JaPropertyListener.addCommonListener(() -> {
                DynamicParam dynamicParam = this.transferParameter();
                this.changeThreadPoolConfig(dynamicParam.getCoreSize().intValue(), dynamicParam.getMaxSize().intValue());
                String chanageAfterLogStr = this.threadPoolExecutor.printThreadPoolStatus();
                log.info("changeThreadPool:" + chanageAfterLogStr);
            });
        }
        catch (Throwable e) {
            log.error("refresh DynamicThreadPool config", e);
        }
    }

    private void initializeThreadPool() {
        this.threadPoolExecutor = this.buildThreadPool();
        this.executorService = JaTtlExecutors.getTtlExecutorService((ExecutorService)this.threadPoolExecutor);
        String chanageBeforeLogStr = this.threadPoolExecutor.printThreadPoolStatus();
        log.info("initializeThreadPool:" + chanageBeforeLogStr);
    }

    protected abstract DynamicThreadPoolBean buildThreadPool();

    public abstract DynamicParam transferParameter();

    private void changeThreadPoolConfig(int coreSize, int maxSize) {
        this.threadPoolExecutor.changeThreadPoolConfig(Integer.valueOf(coreSize), Integer.valueOf(maxSize));
    }

    protected void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (this.executorService != null && !this.executorService.isShutdown()) {
                this.executorService.shutdown();
            }
        }));
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.executorService.submit(task);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.executorService.submit(task);
    }

    @Override
    public void execute(Runnable command) {
        this.executorService.execute(command);
    }

    @Override
    public void shutdown() {
        this.executorService.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.executorService.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.executorService.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.executorService.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executorService.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.executorService.submit(task, result);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.executorService.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.executorService.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.executorService.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.executorService.invokeAny(tasks, timeout, unit);
    }
}

