/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.infrastructure.eoc.impl;

import com.digiwin.athena.aim.app.env.EnvProperties;
import com.digiwin.athena.aim.infrastructure.eoc.EocService;
import com.digiwin.athena.aim.infrastructure.eoc.dto.EmpDTO;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.iam.sdk.meta.dto.IamResultDTO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class EocServiceImpl
implements EocService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EocServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;

    public List<EmpDTO> getEmpByIds(List<String> userIds, List<String> empIds) {
        String uri = this.envProperties.getEocUri() + "/api/eoc/v2/emp/infos";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c");
        headers.add("digi-middleware-auth-user", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        HashMap<String, List<String>> param = new HashMap<String, List<String>>();
        param.put("userIds", userIds);
        param.put("empIds", empIds);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        try {
            log.info("[getEmpByIds]\u8bf7\u6c42EOC \u67e5\u8be2\u5458\u5de5\u4fe1\u606f \u5165\u53c2:userIds = {}, empIds = {}", userIds, empIds);
            ResponseEntity respEntity = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, param);
            if (null != respEntity.getBody() && ((IamResultDTO)respEntity.getBody()).getSuccess().booleanValue()) {
                return (List)((IamResultDTO)respEntity.getBody()).data();
            }
        }
        catch (Exception e) {
            log.info("[getEmpByIds]\u8bf7\u6c42EOC \u67e5\u8be2\u5458\u5de5\u4fe1\u606f\u5931\u8d25 \u5165\u53c2:userIds = {}, empIds = {},e = {}", new Object[]{userIds, empIds, e});
        }
        return new ArrayList<EmpDTO>();
    }

    public List<EmpDTO> getEmpByDutyIds(List<String> dutyIds) {
        String uri = this.envProperties.getEocUri() + "/api/eoc/v2/duty/emps/batch?dutyIds={dutyIds}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c");
        headers.add("digi-middleware-auth-user", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("dutyIds", String.join((CharSequence)",", dutyIds));
        try {
            HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
            log.info("[getEmpByIds]\u8bf7\u6c42EOC \u67e5\u8be2\u5458\u5de5\u4fe1\u606f \u5165\u53c2:dutyIds = {}", dutyIds);
            ResponseEntity respEntity = this.restTemplate.exchange(uri, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, params);
            if (null != respEntity.getBody() && ((IamResultDTO)respEntity.getBody()).getSuccess().booleanValue()) {
                return (List)((IamResultDTO)respEntity.getBody()).data();
            }
        }
        catch (Exception e) {
            log.info("[getEmpByIds]\u8bf7\u6c42EOC \u67e5\u8be2\u5458\u5de5\u4fe1\u606f\u5931\u8d25 \u5165\u53c2:dutyIds = {},e = {}", dutyIds, (Object)e);
        }
        return new ArrayList<EmpDTO>();
    }
}

