/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.infrastructure.mobile;

import com.digiwin.athena.aim.infrastructure.mobile.AppOauthService;
import com.digiwin.athena.aim.infrastructure.mobile.MobileProperties;
import com.digiwin.athena.aim.infrastructure.mobile.entity.AppTokenDTO;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class AppOauthServiceImpl
implements AppOauthService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppOauthServiceImpl.class);
    private static final String TOKEN_CACHE_KEY_FORMAT = "aim:mobile:accessToken:%s";
    private static final long TOKEN_CACHE_TTL_HOURS = 48L;
    @Resource
    private RestTemplate restTemplate;
    @Resource
    private StringRedisTemplate stringRedisTemplate;

    public AppTokenDTO getAccessToken(MobileProperties.OauthProperties oauthProperties, boolean flushCache) {
        String cacheKey = String.format(TOKEN_CACHE_KEY_FORMAT, oauthProperties.getClientId());
        if (flushCache) {
            this.stringRedisTemplate.delete((Object)cacheKey);
        } else {
            String cacheValue = (String)this.stringRedisTemplate.opsForValue().get((Object)cacheKey);
            if (StringUtils.isNotBlank((String)cacheValue)) {
                log.info("[AppOauthServiceImpl.getAccessToken] get access_token(clientId: {}) from cache.", (Object)oauthProperties.getClientId());
                return (AppTokenDTO)JsonUtils.jsonToObject((String)cacheValue, AppTokenDTO.class);
            }
        }
        AppTokenDTO appTokenDTO = this.getAccessToken(oauthProperties);
        if (null != appTokenDTO) {
            this.stringRedisTemplate.opsForValue().set((Object)cacheKey, (Object)JsonUtils.objectToString((Object)appTokenDTO), 48L, TimeUnit.HOURS);
        }
        return appTokenDTO;
    }

    public AppTokenDTO getAccessToken(MobileProperties.OauthProperties oauthProperties) {
        log.info("[AppOauthServiceImpl.getAccessToken] get access_token(clientId: {}) by http request.", (Object)oauthProperties.getClientId());
        String uri = UriComponentsBuilder.fromUriString((String)oauthProperties.getUri()).queryParam("grant_type", new Object[]{oauthProperties.getGrantType()}).queryParam("client_id", new Object[]{oauthProperties.getClientId()}).queryParam("client_secret", new Object[]{oauthProperties.getClientSecret()}).toUriString();
        ResponseEntity respEntity = this.restTemplate.getForEntity(uri, AppTokenDTO.class, new Object[0]);
        if (HttpStatus.OK.value() == respEntity.getStatusCodeValue()) {
            return (AppTokenDTO)respEntity.getBody();
        }
        throw BusinessException.create((Integer)respEntity.getStatusCodeValue(), (String)String.valueOf(respEntity.getBody()));
    }
}

