/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.infrastructure.mongo;

import com.digiwin.athena.aim.api.dto.Page;
import com.digiwin.athena.aim.domain.message.model.AppExpireMessageDO;
import com.digiwin.athena.aim.domain.message.model.CiConstant;
import com.digiwin.athena.aim.domain.message.model.ExpireMessageReq;
import com.digiwin.athena.aim.domain.message.model.MessageDO;
import com.digiwin.athena.aim.domain.message.model.MessageRemoveDTO;
import com.digiwin.athena.aim.domain.message.model.MsgStateEnum;
import com.digiwin.athena.aim.domain.message.repository.MessageMapperV2;
import com.digiwin.athena.aim.infrastructure.mongo.AbstractMongoMessageMapper;
import com.digiwin.athena.aim.util.DateUtils;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.google.common.collect.Lists;
import com.mongodb.client.result.UpdateResult;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Repository;

@Repository
public class MongoMessageMapperV2
extends AbstractMongoMessageMapper
implements MessageMapperV2 {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MongoMessageMapperV2.class);

    public PageImpl<MessageDO> pagingQuery(MessageDO condition, Page page) {
        PageRequest pageable = PageRequest.of((int)page.getPageNum(), (int)page.getPageSize());
        if (StringUtils.isEmpty((String)condition.getTenantId())) {
            return new PageImpl(new ArrayList(), (Pageable)PageRequest.of((int)page.getPageNum(), (int)page.getPageSize()), 0L);
        }
        Criteria criteria = Criteria.where((String)"userId").is((Object)condition.getUserId());
        criteria.and("deleted").ne((Object)Boolean.TRUE);
        if (StringUtils.isNotBlank((String)condition.getType())) {
            criteria.and("type").is((Object)condition.getType());
        }
        if (StringUtils.isNotBlank((String)condition.getSubType())) {
            criteria.and("subType").is((Object)condition.getSubType());
        }
        if (StringUtils.isNotBlank((String)condition.getSubTypeCategory())) {
            criteria.and("subTypeCategory").is((Object)condition.getSubTypeCategory());
        }
        if (StringUtils.isNotBlank((String)condition.getCategory())) {
            criteria.and("category").is((Object)condition.getCategory());
        }
        if (null != condition.getImportance()) {
            criteria.and("importance").is((Object)condition.getImportance());
        }
        if (StringUtils.isNotBlank((String)condition.getSource())) {
            criteria.and("source").is((Object)condition.getSource());
        }
        if (null != condition.getState()) {
            criteria.and("state").is((Object)condition.getState());
        }
        if (StringUtils.isNotBlank((String)condition.getChannelType())) {
            Criteria channelTypeCriteria = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"channelType").is((Object)condition.getChannelType()), Criteria.where((String)"channelType").exists(false)});
            criteria.andOperator(new Criteria[]{channelTypeCriteria});
        }
        if (StringUtils.isNotBlank((String)condition.getStartTimeStr()) || StringUtils.isNotBlank((String)condition.getEndTimeStr())) {
            if (StringUtils.isNotBlank((String)condition.getStartTimeStr()) && StringUtils.isNotBlank((String)condition.getEndTimeStr())) {
                criteria.and("createDate").gte((Object)DateUtils.StringToDate((String)(condition.getStartTimeStr() + " 00:00:00"))).lte((Object)DateUtils.StringToDate((String)(condition.getEndTimeStr() + " 23:59:59")));
            } else if (StringUtils.isNotBlank((String)condition.getStartTimeStr())) {
                criteria.and("createDate").gte((Object)DateUtils.StringToDate((String)(condition.getStartTimeStr() + " 00:00:00")));
            } else if (StringUtils.isNotBlank((String)condition.getEndTimeStr())) {
                criteria.and("createDate").lte((Object)DateUtils.StringToDate((String)(condition.getEndTimeStr() + " 23:59:59")));
            }
        }
        if (StringUtils.isNotBlank((String)condition.getKey())) {
            List gidList = this.filterByKey(criteria, condition);
            if (CollectionUtils.isEmpty((Collection)gidList)) {
                return new PageImpl(new ArrayList(), (Pageable)pageable, 0L);
            }
            criteria.and("gid").in((Collection)gidList);
        }
        long count = this.countByCondition(this.getCollectionName(condition), criteria, 2000L, new String[]{"createDate"});
        if (BooleanUtils.isTrue((Boolean)condition.getUnterminate())) {
            criteria.and("category").ne((Object)"TERMINATE");
        }
        List messageList = this.msgMongoTemplate.find(new Query().addCriteria((CriteriaDefinition)criteria).with((Pageable)pageable).with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createDate"})), MessageDO.class, this.getCollectionName(condition));
        return new PageImpl(messageList, (Pageable)pageable, count);
    }

    public MessageRemoveDTO updateDeleted(String channelType, AuthoredUser authoredUser) {
        Criteria criteria = Criteria.where((String)"userId").is((Object)authoredUser.getUserId()).and("state").is((Object)MsgStateEnum.READ.getState()).and("deleted").ne((Object)Boolean.TRUE);
        if (StringUtils.isNotBlank((String)channelType)) {
            Criteria channelTypeCriteria = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"channelType").is((Object)channelType), Criteria.where((String)"channelType").exists(false)});
            criteria.andOperator(new Criteria[]{channelTypeCriteria});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createDate"}));
        query.limit(1000);
        List messageList = this.msgMongoTemplate.find(query, MessageDO.class, this.getCollectionName(authoredUser.getTenantId()));
        int size = messageList.size();
        if (size != 0) {
            List gids = messageList.stream().map(MessageDO::getGid).collect(Collectors.toList());
            log.error("\u63d0\u793a\u8be6\u7ec6\u6e05\u9664\u7f13\u5b58\u603b\u6761\u6570:{}", (Object)gids.size());
            List parts = Lists.partition(gids, (int)100);
            log.error("\u63d0\u793a\u8be6\u7ec6\u6e05\u9664\u7f13\u5b58parts\u6761\u6570:{}", (Object)parts.size());
            parts.stream().forEach(list -> {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date now = new Date();
                String formattedDate = sdf.format(now);
                log.error("\u63d0\u793a\u8be6\u7ec6\u6e05\u9664\u7f13\u5b58\u6761\u6570:{},\u65f6\u95f4\u662f:{}", (Object)list.size(), (Object)formattedDate);
                Query updateQuery = new Query((CriteriaDefinition)Criteria.where((String)"gid").in((Collection)list));
                Update update = new Update();
                update.set("deleted", (Object)Boolean.TRUE);
                this.msgMongoTemplate.updateMulti(updateQuery, (UpdateDefinition)update, this.getCollectionName(authoredUser.getTenantId()));
            });
        }
        MessageRemoveDTO messageRemoveDTO = new MessageRemoveDTO();
        messageRemoveDTO.setRemoveNum(Integer.valueOf(size));
        return messageRemoveDTO;
    }

    public List<String> filterByKey(Criteria criteria, MessageDO condition) {
        ArrayList<String> gidList = new ArrayList<String>();
        List messageListAll = this.msgMongoTemplate.find(new Query().addCriteria((CriteriaDefinition)criteria).with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createDate"})), MessageDO.class, this.getCollectionName(condition));
        if (CollectionUtils.isEmpty((Collection)messageListAll)) {
            return gidList;
        }
        for (MessageDO message : messageListAll) {
            String content = JsonUtils.objectToString((Object)message.getContent());
            if (!content.contains(condition.getKey())) continue;
            gidList.add(message.getGid());
        }
        return gidList;
    }

    public long readMessageByGid(String channelType, List<String> gidList, AuthoredUser authoredUser) {
        if (StringUtils.isEmpty((String)authoredUser.getTenantId())) {
            return 0L;
        }
        ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
        criteriaList.add(Criteria.where((String)"userId").is((Object)authoredUser.getUserId()));
        Criteria stateCriteria = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"state").is((Object)MsgStateEnum.UNREAD.getState()), Criteria.where((String)"state").is(null)});
        if (CollectionUtils.isNotEmpty(gidList)) {
            criteriaList.add(new Criteria().andOperator(new Criteria[]{Criteria.where((String)"gid").in(gidList), stateCriteria}));
        } else {
            criteriaList.add(stateCriteria);
        }
        if (StringUtils.isNotBlank((String)channelType)) {
            criteriaList.add(new Criteria().orOperator(new Criteria[]{Criteria.where((String)"channelType").is((Object)channelType), Criteria.where((String)"channelType").exists(false)}));
        }
        Criteria finalCriteria = new Criteria().andOperator(criteriaList.toArray(new Criteria[0]));
        Query query = new Query((CriteriaDefinition)finalCriteria);
        Update update = new Update();
        update.set("state", (Object)MsgStateEnum.READ.getState()).set("modifyDate", (Object)LocalDateTime.now());
        UpdateResult result = this.msgMongoTemplate.updateMulti(query, (UpdateDefinition)update, this.getCollectionName(authoredUser.getTenantId()));
        return result.getModifiedCount();
    }

    public long readMessageDetailByGid(String gid, AuthoredUser authoredUser) {
        if (StringUtils.isEmpty((String)authoredUser.getTenantId())) {
            return 0L;
        }
        Criteria criteria = Criteria.where((String)"userId").is((Object)authoredUser.getUserId()).and("gid").is((Object)gid);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("hasReadDetail", (Object)Boolean.TRUE).set("modifyDate", (Object)LocalDateTime.now());
        UpdateResult result = this.msgMongoTemplate.updateMulti(query, (UpdateDefinition)update, this.getCollectionName(authoredUser.getTenantId()));
        return result.getModifiedCount();
    }

    public void batchInsert(List<MessageDO> messageList) {
        if (CollectionUtils.isEmpty(messageList)) {
            return;
        }
        String collectionName = this.getCollectionName(messageList.get(0));
        this.createCollectionNecessary(collectionName, null);
        LocalDateTime createDate = LocalDateTime.now();
        messageList.forEach(message -> {
            message.setCreateDate(createDate);
            message.setModifyDate(createDate);
            message.setHasReadDetail(Boolean.FALSE);
            message.setState(Integer.valueOf(MsgStateEnum.UNREAD.getState()));
        });
        BulkOperations operations = this.msgMongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, collectionName);
        operations.insert(messageList);
        operations.execute();
    }

    public void clearProjectAndTaskMessage(String tenantId, List<String> projectCodeList, List<String> taskCodeList) {
        if (CollectionUtils.isNotEmpty(projectCodeList)) {
            Criteria projectCri = Criteria.where((String)"type").is((Object)"task").and("subType").in(projectCodeList);
            this.msgMongoTemplate.remove(new Query((CriteriaDefinition)projectCri), this.getCollectionName(tenantId));
        }
        if (CollectionUtils.isNotEmpty(taskCodeList)) {
            Criteria taskCri = Criteria.where((String)"type").is((Object)"activity").and("subType").in(taskCodeList);
            this.msgMongoTemplate.remove(new Query((CriteriaDefinition)taskCri), this.getCollectionName(tenantId));
        }
    }

    public void insertAppExpirationMessage(List<ExpireMessageReq.MessageDTO> messageList) {
        if (CollectionUtils.isEmpty(messageList)) {
            return;
        }
        String collectionName = this.getCollectionNameForAppExpirationMessage(messageList.get(0).getTenantId());
        this.createCollectionNecessary(collectionName, CiConstant.CollectionFlagEnum.APP_EXPIRATION_MESSAGE.getFlag());
        LocalDateTime createDate = LocalDateTime.now();
        messageList.forEach(message -> {
            message.setCreateDate(createDate);
            message.setModifyDate(createDate);
        });
        BulkOperations operations = this.msgMongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, collectionName);
        operations.insert(messageList);
        operations.execute();
    }

    public List<MessageDO> queryAppExpirationMessage(MessageDO condition) {
        Criteria criteria = Criteria.where((String)"userId").is((Object)condition.getUserId()).and("endTime").gte((Object)LocalDateTime.now());
        Query query = new Query((CriteriaDefinition)criteria);
        String collectionName = this.getCollectionNameForAppExpirationMessage(condition.getTenantId());
        List messageDOList = this.msgMongoTemplate.find(query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"createDate"})), MessageDO.class, collectionName);
        log.info("MongoMessageMapperV2 query app expiration message success. result:{}", (Object)messageDOList);
        if (CollectionUtils.isNotEmpty((Collection)messageDOList)) {
            Update update = new Update();
            update.set("modifyDate", (Object)LocalDateTime.now());
            UpdateResult updateResult = this.msgMongoTemplate.updateMulti(query, (UpdateDefinition)update, collectionName);
        }
        return messageDOList;
    }

    public void deleteAppExpirationMessage(AppExpireMessageDO appExpireMessageDO) {
        String collectionName = this.getCollectionNameForAppExpirationMessage(appExpireMessageDO.getTenantId());
        Criteria criteria = Criteria.where((String)"appCode").is((Object)appExpireMessageDO.getAppCode());
        this.msgMongoTemplate.remove(new Query((CriteriaDefinition)criteria), collectionName);
    }
}

