/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.infrastructure.mongo;

import com.digiwin.athena.aim.domain.message.model.CiConstant;
import com.digiwin.athena.aim.domain.message.model.MessageTemplateDTO;
import com.digiwin.athena.aim.domain.message.repository.MessageTemplateMapper;
import com.digiwin.athena.aim.infrastructure.mongo.AbstractMongoMessageMapper;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import java.time.LocalDateTime;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class MongoMessageTemplateMapper
extends AbstractMongoMessageMapper
implements MessageTemplateMapper {
    public MessageTemplateDTO insertMessageTemplate(MessageTemplateDTO messageTemplateDTO) {
        String collectionName = this.getCollectionNameForTempTemplate();
        this.createCollectionNecessary(collectionName, CiConstant.CollectionFlagEnum.TEMPLATE.getFlag());
        messageTemplateDTO.setGid(String.valueOf(SnowflakeIdWorker.getInstance().newId()));
        messageTemplateDTO.setCreateDate(LocalDateTime.now());
        messageTemplateDTO.setModifyDate(LocalDateTime.now());
        messageTemplateDTO.setUserId(AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
        messageTemplateDTO.setTenantId(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        return (MessageTemplateDTO)this.msgMongoTemplate.insert((Object)messageTemplateDTO, collectionName);
    }

    public List<MessageTemplateDTO> queryMessageTemplateList(String templateCode) {
        String collectionName = this.getCollectionNameForTempTemplate();
        Query query = new Query();
        if (StringUtils.isNotBlank((String)templateCode)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"code").is((Object)templateCode));
        }
        return this.msgMongoTemplate.find(query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"createDate"})), MessageTemplateDTO.class, collectionName);
    }
}

