/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.infrastructure.thememap.service;

import com.digiwin.athena.aim.app.env.EnvProperties;
import com.digiwin.athena.aim.infrastructure.thememap.dto.KmApplicationRelationDTO;
import com.digiwin.athena.aim.infrastructure.thememap.dto.KmApplicationRelationReqDTO;
import com.digiwin.athena.aim.infrastructure.thememap.dto.TmAppExpireChangeComponentDTO;
import com.digiwin.athena.aim.infrastructure.thememap.service.ThemeMapService;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class ThemeMapServiceImpl
implements ThemeMapService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThemeMapServiceImpl.class);
    @Autowired
    EnvProperties envProperties;
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    MessageUtils messageUtils;

    public TmAppExpireChangeComponentDTO getAppExpireChangeComponent(TmAppExpireChangeComponentDTO appExpireChangeComponent) {
        String url = this.envProperties.getKnowledgegraphUri() + "/restful/service/knowledgegraph/Component/QueryComponent";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity((Object)appExpireChangeComponent, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            if (null != respEntity.getBody() && ((BaseResultDTO)respEntity.getBody()).isOK()) {
                return (TmAppExpireChangeComponentDTO)((BaseResultDTO)respEntity.getBody()).getResponse();
            }
            log.error("\u8bf7\u6c42KM\u83b7\u53d6\u8fc7\u671f\u5e94\u7528\u7684\u7ec4\u4ef6\u5217\u8868\u62a5\u9519\uff0c\u53c2\u6570\uff1a{}, \u54cd\u5e94\u5185\u5bb9\uff1a{}", (Object)appExpireChangeComponent, (Object)JsonUtils.objectToString((Object)respEntity.getBody()));
            String errMsg = MessageFormat.format(this.messageUtils.getMessage("exception.KM.expired.application"), JsonUtils.objectToString((Object)appExpireChangeComponent), JsonUtils.objectToString((Object)respEntity.getBody()));
            throw BusinessException.create((String)errMsg);
        }
        catch (BusinessException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String errMsg = MessageFormat.format(this.messageUtils.getMessage("exception.KM.expired.application2"), JsonUtils.objectToString((Object)appExpireChangeComponent));
            throw BusinessException.create((String)errMsg, (Throwable)ex);
        }
    }

    public List<KmApplicationRelationDTO> getApplicationRelation(KmApplicationRelationReqDTO relationReqDTO) {
        String url = this.envProperties.getKnowledgegraphUri() + "/restful/service/knowledgegraph/task/applicationRelation";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        headers.add("token", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        ArrayList<KmApplicationRelationDTO> relationDTOS = new ArrayList<KmApplicationRelationDTO>();
        HttpEntity httpEntity = new HttpEntity((Object)relationReqDTO, (MultiValueMap)headers);
        try {
            log.info("\u8bf7\u6c42KM\u83b7\u53d6\u5e94\u7528\u4fe1\u606f \u5165\u53c2:{}", (Object)JsonUtils.objectToString((Object)httpEntity));
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            log.info("\u8bf7\u6c42KM\u83b7\u53d6\u5e94\u7528\u4fe1\u606f\uff0c\u5165\u53c2\uff1a{}, \u54cd\u5e94\u5185\u5bb9\uff1a{}", (Object)JsonUtils.objectToString((Object)relationReqDTO), (Object)JsonUtils.objectToString((Object)respEntity.getBody()));
            if (null != respEntity.getBody() && ((BaseResultDTO)respEntity.getBody()).isOK()) {
                return (List)((BaseResultDTO)respEntity.getBody()).getResponse();
            }
        }
        catch (BusinessException ex) {
            log.error("\u8bf7\u6c42KM\u83b7\u53d6\u5e94\u7528\u4fe1\u606f\u62a5\u9519\uff0c\u5165\u53c2\uff1a{}, ex\uff1a{}", (Object)JsonUtils.objectToString((Object)relationReqDTO), (Object)ex);
        }
        return relationDTOS;
    }
}

