/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class WebToolUtils {
    private static final String IP_UTILS_FLAG = ",";
    private static final String UNKNOWN = "unknown";
    private static final String LOCALHOST_IP = "0:0:0:0:0:0:0:1";
    private static final String LOCALHOST_IP1 = "127.0.0.1";
    private static Logger logger = LoggerFactory.getLogger(WebToolUtils.class);

    private WebToolUtils() {
    }

    public static String getLocalIP() throws Exception {
        if (WebToolUtils.isWindowsOS()) {
            return InetAddress.getLocalHost().getHostAddress();
        }
        return WebToolUtils.getLinuxLocalIp();
    }

    public static String getDomainName() throws UnknownHostException {
        return InetAddress.getLocalHost().getCanonicalHostName();
    }

    private static String getLinuxLocalIp() throws Exception {
        String ip = "";
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                String name = intf.getName();
                if (name.contains("docker") || name.contains("lo")) continue;
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    String ipaddress;
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress() || (ipaddress = inetAddress.getHostAddress().toString()).contains("::") || ipaddress.contains("0:0:") || ipaddress.contains("fe80")) continue;
                    ip = ipaddress;
                }
            }
        }
        catch (Exception ex) {
            logger.error("getLinuxLocalIp error", (Throwable)ex);
        }
        return ip;
    }

    public static boolean isWindowsOS() {
        boolean isWindowsOS = false;
        String osName = System.getProperty("os.name");
        if (osName.toLowerCase().indexOf("windows") > -1) {
            isWindowsOS = true;
        }
        return isWindowsOS;
    }

    public static String getRemortIP(HttpServletRequest request) {
        String ip = null;
        try {
            ip = request.getHeader("X-Original-Forwarded-For");
            if (StringUtils.isEmpty((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("X-Forwarded-For");
            }
            if (StringUtils.isEmpty((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("x-forwarded-for");
            }
            if (StringUtils.isEmpty((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("Proxy-Client-IP");
            }
            if (StringUtils.isEmpty((CharSequence)ip) || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("WL-Proxy-Client-IP");
            }
            if (StringUtils.isEmpty((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("HTTP_CLIENT_IP");
            }
            if (StringUtils.isEmpty((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("HTTP_X_FORWARDED_FOR");
            }
            if ((StringUtils.isEmpty((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) && ("127.0.0.1".equalsIgnoreCase(ip = request.getRemoteAddr()) || "0:0:0:0:0:0:0:1".equalsIgnoreCase(ip))) {
                try {
                    InetAddress iNet = InetAddress.getLocalHost();
                    ip = iNet.getHostAddress();
                }
                catch (UnknownHostException e) {
                    logger.warn("getRemortIP UnknownHostException: {}", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            logger.warn("getRemortIP ERROR ", (Throwable)e);
        }
        if (!StringUtils.isEmpty((CharSequence)ip) && ip.indexOf(",") > 0) {
            ip = ip.substring(0, ip.indexOf(","));
        }
        return ip;
    }
}

