/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.api;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/aim/jacoco"})
public class JacocoController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JacocoController.class);
    @Value(value="${jacoco.workingDir:/usr/local/aim}")
    private String workingDir;
    @Value(value="${jacoco.jarDir:/usr/local/aim/jacoco/lib}")
    private String jacocoJarDir;
    @Value(value="${jacoco.workingDir:/usr/local/aim}/${jacoco.classesJarDir:aim-0.0.2.0020.jar}")
    private String classesJarDir;
    @Value(value="${jacoco.workingDir:/usr/local/aim}/${jacoco.sourceJarDir:aim-0.0.2.0020-sources.jar}")
    private String sourceJarDir;

    private void dumpJacocoExec() {
        try {
            Class<?> rt = Class.forName("org.jacoco.agent.rt.RT");
            Method getAgent = rt.getMethod("getAgent", new Class[0]);
            Method dump = getAgent.getReturnType().getMethod("dump", Boolean.TYPE);
            Object agent = getAgent.invoke(null, new Object[0]);
            dump.invoke(agent, false);
        }
        catch (ClassNotFoundException e) {
            log.error("Jacoco not enabled", (Throwable)e);
            throw new RuntimeException("Jacoco not enabled");
        }
        catch (Exception e) {
            log.error("Dump exec failed", (Throwable)e);
            throw new RuntimeException("Dump exec failed");
        }
    }

    public void zipDirectory(String name, Path sourceDir, OutputStream outputStream) throws IOException {
        try (ZipOutputStream zipOut = new ZipOutputStream(outputStream);){
            try (Stream<Path> pathStream = Files.walk(sourceDir, new FileVisitOption[0]);){
                pathStream.forEach(path -> {
                    Path rel = sourceDir.relativize((Path)path);
                    String entryName = (name + "/" + rel.toString().replace(File.separatorChar, '/') + (Files.isDirectory(path, new LinkOption[0]) ? "/" : "")).replace("//", "/");
                    try {
                        zipOut.putNextEntry(new ZipEntry(entryName));
                        if (Files.isRegularFile(path, new LinkOption[0])) {
                            Files.copy(path, zipOut);
                        }
                        zipOut.closeEntry();
                    }
                    catch (IOException e) {
                        log.error("An error occurred in packaging file : {}", path, (Object)e);
                    }
                });
            }
            zipOut.finish();
        }
    }

    private void extractClassesJar() {
        File classesDirectory = new File(this.workingDir, "jacoco_classes");
        if (!classesDirectory.exists()) {
            try {
                this.extractJar(this.classesJarDir, this.workingDir + "/jacoco_classes");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void extractSourceJar() {
        File sourceDirectory = new File(this.workingDir, "src/main/java");
        if (!sourceDirectory.exists()) {
            try {
                this.extractJar(this.sourceJarDir, this.workingDir + "/src/main/java");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void extractJar(String jarPath, String destDir) throws IOException {
        JarFile jarFile = new JarFile(jarPath);
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            File entryFile = new File(destDir, entry.getName());
            if (entry.isDirectory()) {
                entryFile.mkdirs();
                continue;
            }
            entryFile.getParentFile().mkdirs();
            InputStream in = jarFile.getInputStream(entry);
            Throwable throwable = null;
            try {
                FileOutputStream out = new FileOutputStream(entryFile);
                Throwable throwable2 = null;
                try {
                    int bytesRead;
                    byte[] buffer = new byte[4096];
                    while ((bytesRead = in.read(buffer)) != -1) {
                        ((OutputStream)out).write(buffer, 0, bytesRead);
                    }
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (out == null) continue;
                    if (throwable2 != null) {
                        try {
                            ((OutputStream)out).close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    ((OutputStream)out).close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                in.close();
            }
        }
        jarFile.close();
        log.info("Decompression completed: " + destDir);
    }

    private void execCmd(String coverageReportDir) throws InterruptedException, IOException {
        int exitCode = new ProcessBuilder(new String[0]).command("java", "-jar", this.jacocoJarDir + "/jacococli.jar", "report", this.workingDir + "/platform/jacoco/jacoco.exec", "--classfiles", this.workingDir + "/jacoco_classes/BOOT-INF/classes", "--sourcefiles", this.sourceJarDir, "--html", this.workingDir + coverageReportDir).redirectErrorStream(true).start().waitFor();
        if (exitCode == 0) {
            log.info("HTML report generation successfully!");
        } else {
            log.error("Report generation failed. exitCode: {}", (Object)exitCode);
        }
    }

    @GetMapping(value={"/getJacocoExec"})
    public void getJacocoExec(HttpServletResponse response) throws IOException {
        this.dumpJacocoExec();
        Path execPath = Paths.get(this.workingDir, "platform", "jacoco", "jacoco.exec");
        try (ServletOutputStream os = response.getOutputStream();
             InputStream is = Files.newInputStream(execPath, new OpenOption[0]);){
            int bytesRead;
            byte[] buffer = new byte[4096];
            while ((bytesRead = is.read(buffer)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
            os.flush();
        }
    }

    @GetMapping(value={"/downloadJacocoReport"})
    public void getReport(HttpServletResponse response) throws Exception {
        this.dumpJacocoExec();
        this.extractClassesJar();
        this.extractSourceJar();
        String coverageReportDir = "/coveragereport";
        this.execCmd(coverageReportDir);
        String filename = "aim-jacoco-report_" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")) + ".zip";
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
        try (ServletOutputStream os = response.getOutputStream();){
            this.zipDirectory(filename, Paths.get(this.workingDir + coverageReportDir, new String[0]), (OutputStream)os);
            os.flush();
        }
    }
}

