/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.api;

import com.digiwin.athena.aim.domain.message.service.MiscHandleService;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/aim/v1/misc"})
public class MiscController {
    @Autowired
    private MiscHandleService miscHandleService;

    @GetMapping(value={"/demo/reset"})
    public ResponseEntity<?> resetData() {
        this.miscHandleService.resetDataByTenantId();
        return ResponseEntityWrapper.wrapperOk();
    }

    @GetMapping(value={"/message/deleteByTenant/{tenantId}"})
    public ResponseEntity<?> deleteByTenant(@PathVariable(value="tenantId") String tenantId) {
        this.miscHandleService.deleteByTenantId(tenantId);
        return ResponseEntityWrapper.wrapperOk();
    }

    @GetMapping(value={"/downFile"})
    public ResponseEntity<Resource> downFile(String path) throws IOException {
        if (StringUtils.isBlank((CharSequence)path)) {
            throw new RuntimeException("\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
        }
        Path filePath = Paths.get(path, new String[0]);
        UrlResource resource = new UrlResource(filePath.toUri());
        if (resource.exists() || resource.isReadable()) {
            HttpHeaders headers = new HttpHeaders();
            headers.add("Content-Disposition", "attachment; filename=\"" + resource.getFilename() + "\"");
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentLength(resource.contentLength()).body((Object)resource);
        }
        throw new RuntimeException("\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u4e0d\u53ef\u8bfb");
    }
}

