/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.api;

import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.mongodb.client.ListIndexesIterable;
import com.mongodb.client.MongoCursor;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.map.HashedMap;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/aim/v1/"})
public class RepairDataController {
    @Resource
    protected MongoTemplate msgMongoTemplate;

    @GetMapping(value={"/repair/msg/queryCollections"})
    public ResponseEntity queryAllCollectionInfo() {
        Set collectionInfo = this.msgMongoTemplate.getCollectionNames();
        return ResponseEntityWrapper.wrapperOk((Object)collectionInfo);
    }

    @GetMapping(value={"/repair/msg/getIndexInfo"})
    public ResponseEntity queryIndexInfo(@RequestParam(value="collection", required=false) String collectionName) {
        ListIndexesIterable currentIndexes = this.msgMongoTemplate.getCollection(collectionName).listIndexes();
        MongoCursor cursor = currentIndexes.iterator();
        HashSet<Object> indexNames = new HashSet<Object>();
        while (cursor.hasNext()) {
            Object next = cursor.next();
            indexNames.add(next);
        }
        return ResponseEntityWrapper.wrapperOk(indexNames);
    }

    @PostMapping(value={"/repair/msg/setIndex"})
    public ResponseEntity setIndex(@RequestParam(value="collection", required=false) String collectionName, @RequestBody Document document) {
        String result = this.msgMongoTemplate.getCollection(collectionName).createIndex((Bson)document);
        return ResponseEntityWrapper.wrapperOk((Object)result);
    }

    @PostMapping(value={"/repair/msg/batchSetIndex"})
    public ResponseEntity batchSetIndex(@RequestParam(value="collections", required=false) String collectionNames, @RequestBody Document document) {
        String[] collArrs = collectionNames.split(",");
        HashedMap result = new HashedMap();
        for (String col : collArrs) {
            String tempResult = this.msgMongoTemplate.getCollection(col).createIndex((Bson)document);
            result.put(col, tempResult);
        }
        return ResponseEntityWrapper.wrapperOk((Object)result);
    }

    @GetMapping(value={"/repair/msg/dropIndex"})
    public ResponseEntity dropIndex(@RequestParam(value="collection", required=false) String collectionName, @RequestParam(value="indexName", required=false) String indexName) {
        try {
            this.msgMongoTemplate.getCollection(collectionName).dropIndex(indexName);
        }
        catch (Exception e) {
            return ResponseEntityWrapper.wrapperOk((Object)"\u5220\u9664\u7d22\u5f15\u5f02\u5e38");
        }
        return ResponseEntityWrapper.wrapperOk((Object)"\u5220\u9664\u7d22\u5f15\u6210\u529f");
    }
}

