/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.api;

import com.digiwin.athena.aim.api.dto.GrayTenantDTO;
import com.digiwin.athena.aim.api.dto.TenantRouteDTO;
import com.digiwin.athena.aim.common.TenantRouteTypeEnum;
import com.digiwin.athena.aim.domain.message.model.TenantRouteChangeMessageDO;
import com.digiwin.athena.aim.domain.message.service.MessageSendService;
import com.digiwin.athena.aim.domain.tenantroute.service.TenantRouteService;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/aim/v1/tenant/route"})
public class TenantRouteController {
    private final TenantRouteService tenantRouteService;
    private final MessageSendService messageSendService;

    public TenantRouteController(TenantRouteService tenantRouteService, MessageSendService messageSendService) {
        this.tenantRouteService = tenantRouteService;
        this.messageSendService = messageSendService;
    }

    @GetMapping(value={"/queryPreEnvTenantIdList"})
    public ResponseEntity queryPreEnvTenantIdList(@RequestParam(value="app") String app) {
        List preEnvTenantIdList = this.tenantRouteService.queryPreEnvTenantIdList(app);
        return ResponseEntityWrapper.wrapperOk((Object)preEnvTenantIdList);
    }

    @GetMapping(value={"/queryResolveEnvTenantIdList"})
    public ResponseEntity queryResolveEnvTenantIdList(@RequestParam(value="app") String app, @RequestParam(value="mode") String mode) {
        GrayTenantDTO grayTenantDTO = this.tenantRouteService.queryResolveEnvTenantIdList(app, mode);
        return ResponseEntityWrapper.wrapperOk((Object)grayTenantDTO);
    }

    @GetMapping(value={"/getType"})
    public ResponseEntity queryAllCollectionInfo(@RequestParam(value="app") String app) {
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        Pair routeType = this.tenantRouteService.getRouteType(tenantId, app);
        return ResponseEntityWrapper.wrapperOk((Object)((TenantRouteTypeEnum)routeType.getLeft()).name());
    }

    @GetMapping(value={"/batchGetType"})
    public ResponseEntity batchQueryAllCollectionInfo(@RequestParam(value="apps") String apps) {
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        String[] appArr = StringUtils.split((String)apps, (String)",");
        HashMap<String, String> routeTypeMap = new HashMap<String, String>();
        for (String app : appArr) {
            Pair routeType = this.tenantRouteService.getRouteType(tenantId, app);
            routeTypeMap.put(app, ((TenantRouteTypeEnum)routeType.getLeft()).name());
        }
        return ResponseEntityWrapper.wrapperOk(routeTypeMap);
    }

    @PostMapping(value={"/sendChange"})
    public ResponseEntity sendChange(@RequestBody TenantRouteDTO tenantRouteDTO) {
        String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        if (!StringUtils.equals((String)tenantRouteDTO.getTenantId(), (String)tenantId)) {
            return ResponseEntityWrapper.wrapperFail((int)500, (String)"tenantId not match token");
        }
        TenantRouteChangeMessageDO messageDO = new TenantRouteChangeMessageDO(tenantRouteDTO.getTenantId(), tenantRouteDTO.getType());
        this.messageSendService.sendTenantRouteChange(tenantId, tenantRouteDTO.getApp(), messageDO);
        return ResponseEntityWrapper.wrapperOk((Object)"success");
    }
}

