/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.app.config;

import com.digiwin.athena.aim.util.WebToolUtils;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.ContentCachingRequestWrapper;
import org.springframework.web.util.ContentCachingResponseWrapper;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
public class LogParamConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogParamConfig.class);
    private static final Set<String> EXCLUDE_URL_SET = Sets.newHashSet((Iterable)Lists.newArrayList((Object[])new String[]{"/api/env", "/api/aim/v1/misc/downFile", "/aim/actuator/prometheus"}));
    private static final int LOG_SIZE = 2000;

    @Bean
    public OncePerRequestFilter contentCachingRequestFilter() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private void recordRequestStart(HttpServletRequest request, HttpServletResponse response) {
        try {
            MDC.put((String)"filter1", (String)LogParamConfig.getUUID());
            if (AppAuthContextHolder.getContext() != null && AppAuthContextHolder.getContext().getAuthoredUser() != null) {
                String userId = AppAuthContextHolder.getContext().getAuthoredUser().getUserId();
                String tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
                MDC.put((String)"userId", (String)userId);
                MDC.put((String)"tenantId", (String)tenantId);
            }
            HashMap<String, String> extraInfoMap = new HashMap<String, String>();
            extraInfoMap.put("Accessor IP", WebToolUtils.getRemortIP((HttpServletRequest)request));
            extraInfoMap.put("Host IP", request.getRemoteHost());
            extraInfoMap.put("UrlPath", request.getRequestURL().toString());
            extraInfoMap.put("QueryString", request.getQueryString());
            extraInfoMap.put("Referer", request.getHeader("Referer"));
            extraInfoMap.put("Token", request.getHeader("Token"));
            extraInfoMap.put("traceId", request.getHeader("traceId"));
            extraInfoMap.put("requestedId", request.getHeader("X-Requested-With"));
            log.info(request.getServletPath() + " \u63a5\u53e3\u8bf7\u6c42\u5f00\u59cb\uff0c\r\n" + LogParamConfig.mapToString(extraInfoMap));
        }
        catch (Exception e) {
            log.error("\u8bb0\u5f55\u8bf7\u6c42\u5f00\u59cb\u5f02\u5e38", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordRequestEnd(ContentCachingRequestWrapper requestWrapper, ContentCachingResponseWrapper resultWrapper, long cost) {
        try {
            HashMap<String, String> logExtraInfo = new HashMap<String, String>();
            byte[] requestBytes = requestWrapper.getContentAsByteArray();
            if (requestBytes.length > 2000) {
                logExtraInfo.put("request", new String(LogParamConfig.slice((byte[])requestBytes, (int)0, (int)2000)));
            } else {
                logExtraInfo.put("request", new String(requestBytes));
            }
            String contentType = resultWrapper.getContentType();
            if (StringUtils.isNotBlank((CharSequence)contentType) && contentType.contains("application/octet-stream")) {
                logExtraInfo.put("response", "\u54cd\u5e94\u6587\u4ef6\u6d41");
            } else {
                byte[] responseBytes = resultWrapper.getContentAsByteArray();
                if (responseBytes.length > 2000) {
                    logExtraInfo.put("response", new String(LogParamConfig.slice((byte[])responseBytes, (int)0, (int)2000)));
                } else {
                    logExtraInfo.put("response", new String(responseBytes));
                }
            }
            logExtraInfo.put("cost", cost + "");
            if (cost > 1000L) {
                log.warn("\u6162\u8bf7\u6c42\uff1a{}\uff0c{}", (Object)cost, (Object)requestWrapper.getServletPath());
            }
            log.info(requestWrapper.getServletPath() + " \u63a5\u53e3\u8bf7\u6c42\u7ed3\u675f\uff0c\r\n" + LogParamConfig.mapToString(logExtraInfo));
        }
        catch (Exception e) {
            log.error("\u8bb0\u5f55\u8bf7\u6c42\u7ed3\u675f\u5f02\u5e38", (Throwable)e);
        }
        finally {
            try {
                MDC.clear();
            }
            catch (Exception e) {
                log.error("logMdcRemoveEx", (Throwable)e);
            }
        }
    }

    private static String mapToString(Map<String, String> extraInfo) {
        StringBuilder sb = new StringBuilder();
        if (MapUtils.isEmpty(extraInfo)) {
            return "";
        }
        if (sb.length() > 0) {
            sb.append("\r\n");
        }
        for (String s : extraInfo.keySet()) {
            sb.append(s).append(":").append(extraInfo.get(s)).append("\r\n");
        }
        sb.setLength(Math.max(sb.length() - 1, 0));
        return sb.toString();
    }

    private static byte[] slice(byte[] original, int start, int length) {
        byte[] slice = new byte[length];
        System.arraycopy(original, start, slice, 0, length);
        return slice;
    }

    private static String getUUID() {
        UUID uuid = UUID.randomUUID();
        char[] dest = new char[32];
        char[] src = uuid.toString().toCharArray();
        System.arraycopy(src, 0, dest, 0, 8);
        System.arraycopy(src, 9, dest, 8, 4);
        System.arraycopy(src, 14, dest, 12, 4);
        System.arraycopy(src, 19, dest, 16, 4);
        System.arraycopy(src, 24, dest, 20, 12);
        return new String(dest);
    }

    static /* synthetic */ Set access$000() {
        return EXCLUDE_URL_SET;
    }

    static /* synthetic */ void access$100(LogParamConfig x0, HttpServletRequest x1, HttpServletResponse x2) {
        x0.recordRequestStart(x1, x2);
    }

    static /* synthetic */ void access$200(LogParamConfig x0, ContentCachingRequestWrapper x1, ContentCachingResponseWrapper x2, long x3) {
        x0.recordRequestEnd(x1, x2, x3);
    }
}

