/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.app.config;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.internal.MongoClientImpl;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.DefaultMongoTypeMapper;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.MongoTypeMapper;

@Configuration
public class MongoTemplateConfig {
    @Value(value="${spring.data.mongodb-message.uri}")
    private String uriMsg;
    @Value(value="${spring.data.mongodb-message.database}")
    private String databaseMsg;
    @Value(value="${spring.data.mongodb.uri}")
    private String uriLog;
    @Value(value="${spring.data.mongodb.database}")
    private String databaseLog;

    @Bean(value={"msgMongoTemplate"})
    public MongoTemplate tagMongoTemplate() {
        MongoClientImpl client = new MongoClientImpl(MongoClientSettings.builder().retryWrites(false).applyConnectionString(new ConnectionString(this.uriMsg)).build(), null);
        MongoTemplate msgMongoTemplate = new MongoTemplate((MongoClient)client, this.databaseMsg);
        MongoConverter converter = msgMongoTemplate.getConverter();
        if (converter.getTypeMapper().isTypeKey("_class")) {
            ((MappingMongoConverter)converter).setTypeMapper((MongoTypeMapper)new DefaultMongoTypeMapper(null));
        }
        return msgMongoTemplate;
    }

    @Bean(value={"mongoTemplate"})
    public MongoTemplate mongoTemplate() {
        MongoClientImpl client = new MongoClientImpl(MongoClientSettings.builder().retryWrites(false).applyConnectionString(new ConnectionString(this.uriLog)).build(), null);
        return new MongoTemplate((MongoClient)client, this.databaseLog);
    }
}

