/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.app.config;

import com.ctrip.framework.apollo.ConfigChangeListener;
import com.ctrip.framework.apollo.ConfigService;
import com.digiwin.athena.aim.domain.message.subscriber.ApolloConfigChangeSubscriber;
import com.digiwin.athena.appcore.util.JsonUtils;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class TenantRouteNamepspaceConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantRouteNamepspaceConfig.class);
    @Value(value="${tenantRouteNamespaceConfig:}")
    private String tenantRouteNamespaceConfig;
    private Map<String, String> deployMmcIdMap = new HashMap();
    private Map<String, String> deployArKeyMap = new HashMap();
    private Map<String, String> deployTrnamespaceMap = new HashMap();

    @PostConstruct
    public void init() {
        if (StringUtils.isBlank((String)this.tenantRouteNamespaceConfig)) {
            log.warn("\u79df\u6237\u8def\u7531apollo\u914d\u7f6e\u4e2d\u5fc3namespace\u672a\u914d\u7f6e");
            return;
        }
        Map nameSpaceConfig = (Map)JsonUtils.jsonToObject((String)this.tenantRouteNamespaceConfig, Map.class);
        this.deployTrnamespaceMap.putAll(nameSpaceConfig);
        nameSpaceConfig.forEach((deployId, trNamespace) -> {
            String mmcId = StringUtils.substringBefore((String)trNamespace, (String)"_");
            this.deployMmcIdMap.put(deployId, mmcId);
            String arKey = StringUtils.substringAfter((String)trNamespace, (String)"_");
            arKey = StringUtils.substringBeforeLast((String)arKey, (String)"_tr");
            this.deployArKeyMap.put(deployId, arKey);
            ApolloConfigChangeSubscriber handler = new ApolloConfigChangeSubscriber(deployId);
            ConfigService.getConfig((String)trNamespace).addChangeListener((ConfigChangeListener)handler);
        });
    }

    public String getMmcIdByDeployId(String deployId) {
        return (String)this.deployMmcIdMap.get(deployId);
    }

    public String getArKeyByDeployId(String deployId) {
        return (String)this.deployArKeyMap.get(deployId);
    }
}

