/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.domain.message.model;

import com.digiwin.athena.aim.common.TargetEnum;
import com.digiwin.athena.aim.domain.message.model.MessageDO;
import com.digiwin.athena.aim.domain.message.model.MessageValidateGroup;
import com.digiwin.athena.aim.domain.message.model.MsgTypeEnum;
import com.digiwin.athena.aim.domain.message.model.TemplateVariableDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.LanguageUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.validation.constraints.NotBlank;
import lombok.Generated;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;

public class MessageDO {
    public static final String DATA_ID = "dataId";
    private String gid;
    @NotBlank(groups={MessageValidateGroup.NewSingleMessage.class})
    private String userId;
    private String langName;
    @NotBlank(groups={MessageValidateGroup.NewSingleMessage.class})
    private String tenantId;
    @NotBlank
    private String type;
    private String channelType;
    @NotBlank
    private String subType;
    @NotBlank
    private String subTypeCategory;
    @NotBlank
    private String category;
    private Integer importance;
    private String source;
    private Integer state;
    private Boolean hasReadDetail;
    private String title;
    private JSONObject content;
    private String jsonContent;
    private LocalDateTime sendDate;
    private LocalDateTime startTime;
    private LocalDateTime endTime;
    private LocalDateTime createDate;
    private LocalDateTime modifyDate;
    private Boolean noticeMobileApp;
    private Boolean noticeOnlineUser;
    private String appCode;
    private String appName;
    private Boolean hasAppPermission;
    private TemplateVariableDTO template;
    private String locale;
    private TargetAction action;
    private Boolean unterminate = false;
    private String startTimeStr;
    private String endTimeStr;
    private String key;
    private String detailUrl;

    @JsonIgnore
    public JSONObject convertMobileAppMsg() {
        Object projectId;
        JSONObject parameter = new JSONObject();
        parameter.put((Object)"is_system", (Object)false);
        parameter.put((Object)"detail_url", (Object)this.getDetailUrl());
        parameter.put((Object)"service_name", (Object)"dinghui.notice.send");
        parameter.put((Object)"creator_name", (Object)"Athena");
        parameter.put((Object)"category_key", (Object)"MessageCenter");
        parameter.put((Object)"locale", (Object)"zh_CN");
        parameter.put((Object)"title", (Object)this.getTitle());
        if (null != this.getContent() && this.getContent().containsKey((Object)"msg")) {
            parameter.put((Object)"content", (Object)this.getContent().getString("msg"));
        }
        parameter.put((Object)"outer_tenant_id", (Object)this.getTenantId());
        parameter.put((Object)"outer_user_id", (Object)this.getUserId());
        HashMap<String, Object> detail = new HashMap<String, Object>();
        if (StringUtils.equals((String)MsgTypeEnum.ACTIVITY.getValue(), (String)this.getType())) {
            detail.put("type", "TASK");
            if (null != this.getContent() && this.getContent().containsKey((Object)"id")) {
                Object taskId = Optional.ofNullable(this.getContent()).map(msgContent -> msgContent.get("id")).orElse("");
                detail.put(DATA_ID, taskId);
            } else {
                detail.put(DATA_ID, "");
            }
            detail.put("tmActivityId", this.getSubType());
        } else if (StringUtils.equals((String)MsgTypeEnum.TASK.getValue(), (String)this.getType())) {
            detail.put("type", "PROJECT");
            if (null != this.getContent() && this.getContent().containsKey((Object)"id")) {
                projectId = Optional.ofNullable(this.getContent()).map(msgContent -> msgContent.get("id")).orElse("");
                detail.put(DATA_ID, projectId);
            } else {
                detail.put(DATA_ID, "");
            }
            detail.put("tmTaskId", this.getSubType());
        } else if (StringUtils.equals((String)MsgTypeEnum.AGILE_DATA.getValue(), (String)this.getType())) {
            detail.put("type", "AGILE_DATA_DETAIL");
            if (null != this.getContent() && this.getContent().containsKey((Object)"id")) {
                projectId = Optional.ofNullable(this.getContent()).map(msgContent -> msgContent.get("id")).orElse("");
                detail.put(DATA_ID, projectId);
            } else {
                detail.put(DATA_ID, "");
            }
        } else if (StringUtils.equals((String)MsgTypeEnum.NEWS.getValue(), (String)this.getType())) {
            detail.put("type", "NOTICE_DETAIL_PAGE");
            if (null != this.getContent() && this.getContent().containsKey((Object)"id")) {
                Object newsId = Optional.ofNullable(this.getContent()).map(msgContent -> msgContent.get("id")).orElse("");
                detail.put("newsId", newsId);
            } else {
                detail.put("newsId", "");
            }
        } else if (StringUtils.equals((String)MsgTypeEnum.TEXT.getValue(), (String)this.getType())) {
            JSONObject jsonObject;
            TargetAction action = this.getAction();
            if (action != null && StringUtils.isNotBlank((String)action.getTarget()) && TargetEnum.NANA.getFlag().equals(action.getTarget())) {
                detail.put("type", "AI_ASSISTANT");
                jsonObject = new JSONObject();
                jsonObject.put((Object)"skillType", (Object)action.getSkillType());
                detail.put("aiAssistantParams", jsonObject);
            }
            if (action != null && StringUtils.isNotBlank((String)action.getTarget()) && TargetEnum.AGILE_DATA.getFlag().equals(action.getTarget())) {
                detail.put("type", action.getType());
                jsonObject = new JSONObject();
                jsonObject.put((Object)"skillType", (Object)action.getSkillType());
                jsonObject.put((Object)"adaParams", (Object)action.getAdaParams());
                detail.put("aiAssistantParams", jsonObject);
            }
        }
        parameter.put((Object)"detail", detail);
        JSONObject stdDataJson = new JSONObject();
        stdDataJson.put((Object)"parameter", (Object)parameter);
        JSONObject noticeAppMsg = new JSONObject();
        noticeAppMsg.put((Object)"std_data", (Object)stdDataJson);
        return noticeAppMsg;
    }

    @JsonIgnore
    public String getMessageByLanguage(String local) {
        if (local == null) {
            local = "zh_CN";
        }
        if (this.content == null && this.jsonContent != null) {
            Map map = (Map)JsonUtils.jsonToObject((String)this.jsonContent, Map.class);
            this.content = JSONObject.fromObject((Object)map);
        }
        if (this.content == null) {
            return null;
        }
        String json = JsonUtils.objectToString((Object)this.content);
        Map map = (Map)JsonUtils.jsonToObject((String)json, Map.class);
        JSONObject cloneContentObject = JSONObject.fromObject((Object)map);
        LanguageUtils.processLanguage((Object)cloneContentObject, (String)local);
        JSONObject cloneObject = JSONObject.fromObject((Object)this);
        cloneObject.put((Object)"content", (Object)cloneContentObject);
        cloneObject.remove("jsonContent");
        return cloneObject.toString();
    }

    @Generated
    public String getGid() {
        return this.gid;
    }

    @Generated
    public String getUserId() {
        return this.userId;
    }

    @Generated
    public String getLangName() {
        return this.langName;
    }

    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getChannelType() {
        return this.channelType;
    }

    @Generated
    public String getSubType() {
        return this.subType;
    }

    @Generated
    public String getSubTypeCategory() {
        return this.subTypeCategory;
    }

    @Generated
    public String getCategory() {
        return this.category;
    }

    @Generated
    public Integer getImportance() {
        return this.importance;
    }

    @Generated
    public String getSource() {
        return this.source;
    }

    @Generated
    public Integer getState() {
        return this.state;
    }

    @Generated
    public Boolean getHasReadDetail() {
        return this.hasReadDetail;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public JSONObject getContent() {
        return this.content;
    }

    @Generated
    public String getJsonContent() {
        return this.jsonContent;
    }

    @Generated
    public LocalDateTime getSendDate() {
        return this.sendDate;
    }

    @Generated
    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    @Generated
    public LocalDateTime getEndTime() {
        return this.endTime;
    }

    @Generated
    public LocalDateTime getCreateDate() {
        return this.createDate;
    }

    @Generated
    public LocalDateTime getModifyDate() {
        return this.modifyDate;
    }

    @Generated
    public Boolean getNoticeMobileApp() {
        return this.noticeMobileApp;
    }

    @Generated
    public Boolean getNoticeOnlineUser() {
        return this.noticeOnlineUser;
    }

    @Generated
    public String getAppCode() {
        return this.appCode;
    }

    @Generated
    public String getAppName() {
        return this.appName;
    }

    @Generated
    public Boolean getHasAppPermission() {
        return this.hasAppPermission;
    }

    @Generated
    public TemplateVariableDTO getTemplate() {
        return this.template;
    }

    @Generated
    public String getLocale() {
        return this.locale;
    }

    @Generated
    public TargetAction getAction() {
        return this.action;
    }

    @Generated
    public Boolean getUnterminate() {
        return this.unterminate;
    }

    @Generated
    public String getStartTimeStr() {
        return this.startTimeStr;
    }

    @Generated
    public String getEndTimeStr() {
        return this.endTimeStr;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public String getDetailUrl() {
        return this.detailUrl;
    }

    @Generated
    public void setGid(String gid) {
        this.gid = gid;
    }

    @Generated
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Generated
    public void setLangName(String langName) {
        this.langName = langName;
    }

    @Generated
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setChannelType(String channelType) {
        this.channelType = channelType;
    }

    @Generated
    public void setSubType(String subType) {
        this.subType = subType;
    }

    @Generated
    public void setSubTypeCategory(String subTypeCategory) {
        this.subTypeCategory = subTypeCategory;
    }

    @Generated
    public void setCategory(String category) {
        this.category = category;
    }

    @Generated
    public void setImportance(Integer importance) {
        this.importance = importance;
    }

    @Generated
    public void setSource(String source) {
        this.source = source;
    }

    @Generated
    public void setState(Integer state) {
        this.state = state;
    }

    @Generated
    public void setHasReadDetail(Boolean hasReadDetail) {
        this.hasReadDetail = hasReadDetail;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setContent(JSONObject content) {
        this.content = content;
    }

    @Generated
    public void setJsonContent(String jsonContent) {
        this.jsonContent = jsonContent;
    }

    @Generated
    public void setSendDate(LocalDateTime sendDate) {
        this.sendDate = sendDate;
    }

    @Generated
    public void setStartTime(LocalDateTime startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setEndTime(LocalDateTime endTime) {
        this.endTime = endTime;
    }

    @Generated
    public void setCreateDate(LocalDateTime createDate) {
        this.createDate = createDate;
    }

    @Generated
    public void setModifyDate(LocalDateTime modifyDate) {
        this.modifyDate = modifyDate;
    }

    @Generated
    public void setNoticeMobileApp(Boolean noticeMobileApp) {
        this.noticeMobileApp = noticeMobileApp;
    }

    @Generated
    public void setNoticeOnlineUser(Boolean noticeOnlineUser) {
        this.noticeOnlineUser = noticeOnlineUser;
    }

    @Generated
    public void setAppCode(String appCode) {
        this.appCode = appCode;
    }

    @Generated
    public void setAppName(String appName) {
        this.appName = appName;
    }

    @Generated
    public void setHasAppPermission(Boolean hasAppPermission) {
        this.hasAppPermission = hasAppPermission;
    }

    @Generated
    public void setTemplate(TemplateVariableDTO template) {
        this.template = template;
    }

    @Generated
    public void setLocale(String locale) {
        this.locale = locale;
    }

    @Generated
    public void setAction(TargetAction action) {
        this.action = action;
    }

    @Generated
    public void setUnterminate(Boolean unterminate) {
        this.unterminate = unterminate;
    }

    @Generated
    public void setStartTimeStr(String startTimeStr) {
        this.startTimeStr = startTimeStr;
    }

    @Generated
    public void setEndTimeStr(String endTimeStr) {
        this.endTimeStr = endTimeStr;
    }

    @Generated
    public void setKey(String key) {
        this.key = key;
    }

    @Generated
    public void setDetailUrl(String detailUrl) {
        this.detailUrl = detailUrl;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageDO)) {
            return false;
        }
        MessageDO other = (MessageDO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$importance = this.getImportance();
        Integer other$importance = other.getImportance();
        if (this$importance == null ? other$importance != null : !((Object)this$importance).equals(other$importance)) {
            return false;
        }
        Integer this$state = this.getState();
        Integer other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)this$state).equals(other$state)) {
            return false;
        }
        Boolean this$hasReadDetail = this.getHasReadDetail();
        Boolean other$hasReadDetail = other.getHasReadDetail();
        if (this$hasReadDetail == null ? other$hasReadDetail != null : !((Object)this$hasReadDetail).equals(other$hasReadDetail)) {
            return false;
        }
        Boolean this$noticeMobileApp = this.getNoticeMobileApp();
        Boolean other$noticeMobileApp = other.getNoticeMobileApp();
        if (this$noticeMobileApp == null ? other$noticeMobileApp != null : !((Object)this$noticeMobileApp).equals(other$noticeMobileApp)) {
            return false;
        }
        Boolean this$noticeOnlineUser = this.getNoticeOnlineUser();
        Boolean other$noticeOnlineUser = other.getNoticeOnlineUser();
        if (this$noticeOnlineUser == null ? other$noticeOnlineUser != null : !((Object)this$noticeOnlineUser).equals(other$noticeOnlineUser)) {
            return false;
        }
        Boolean this$hasAppPermission = this.getHasAppPermission();
        Boolean other$hasAppPermission = other.getHasAppPermission();
        if (this$hasAppPermission == null ? other$hasAppPermission != null : !((Object)this$hasAppPermission).equals(other$hasAppPermission)) {
            return false;
        }
        Boolean this$unterminate = this.getUnterminate();
        Boolean other$unterminate = other.getUnterminate();
        if (this$unterminate == null ? other$unterminate != null : !((Object)this$unterminate).equals(other$unterminate)) {
            return false;
        }
        String this$gid = this.getGid();
        String other$gid = other.getGid();
        if (this$gid == null ? other$gid != null : !this$gid.equals(other$gid)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$langName = this.getLangName();
        String other$langName = other.getLangName();
        if (this$langName == null ? other$langName != null : !this$langName.equals(other$langName)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$channelType = this.getChannelType();
        String other$channelType = other.getChannelType();
        if (this$channelType == null ? other$channelType != null : !this$channelType.equals(other$channelType)) {
            return false;
        }
        String this$subType = this.getSubType();
        String other$subType = other.getSubType();
        if (this$subType == null ? other$subType != null : !this$subType.equals(other$subType)) {
            return false;
        }
        String this$subTypeCategory = this.getSubTypeCategory();
        String other$subTypeCategory = other.getSubTypeCategory();
        if (this$subTypeCategory == null ? other$subTypeCategory != null : !this$subTypeCategory.equals(other$subTypeCategory)) {
            return false;
        }
        String this$category = this.getCategory();
        String other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        JSONObject this$content = this.getContent();
        JSONObject other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$jsonContent = this.getJsonContent();
        String other$jsonContent = other.getJsonContent();
        if (this$jsonContent == null ? other$jsonContent != null : !this$jsonContent.equals(other$jsonContent)) {
            return false;
        }
        LocalDateTime this$sendDate = this.getSendDate();
        LocalDateTime other$sendDate = other.getSendDate();
        if (this$sendDate == null ? other$sendDate != null : !((Object)this$sendDate).equals(other$sendDate)) {
            return false;
        }
        LocalDateTime this$startTime = this.getStartTime();
        LocalDateTime other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        LocalDateTime this$endTime = this.getEndTime();
        LocalDateTime other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        LocalDateTime this$createDate = this.getCreateDate();
        LocalDateTime other$createDate = other.getCreateDate();
        if (this$createDate == null ? other$createDate != null : !((Object)this$createDate).equals(other$createDate)) {
            return false;
        }
        LocalDateTime this$modifyDate = this.getModifyDate();
        LocalDateTime other$modifyDate = other.getModifyDate();
        if (this$modifyDate == null ? other$modifyDate != null : !((Object)this$modifyDate).equals(other$modifyDate)) {
            return false;
        }
        String this$appCode = this.getAppCode();
        String other$appCode = other.getAppCode();
        if (this$appCode == null ? other$appCode != null : !this$appCode.equals(other$appCode)) {
            return false;
        }
        String this$appName = this.getAppName();
        String other$appName = other.getAppName();
        if (this$appName == null ? other$appName != null : !this$appName.equals(other$appName)) {
            return false;
        }
        TemplateVariableDTO this$template = this.getTemplate();
        TemplateVariableDTO other$template = other.getTemplate();
        if (this$template == null ? other$template != null : !this$template.equals(other$template)) {
            return false;
        }
        String this$locale = this.getLocale();
        String other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !this$locale.equals(other$locale)) {
            return false;
        }
        TargetAction this$action = this.getAction();
        TargetAction other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        String this$startTimeStr = this.getStartTimeStr();
        String other$startTimeStr = other.getStartTimeStr();
        if (this$startTimeStr == null ? other$startTimeStr != null : !this$startTimeStr.equals(other$startTimeStr)) {
            return false;
        }
        String this$endTimeStr = this.getEndTimeStr();
        String other$endTimeStr = other.getEndTimeStr();
        if (this$endTimeStr == null ? other$endTimeStr != null : !this$endTimeStr.equals(other$endTimeStr)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$detailUrl = this.getDetailUrl();
        String other$detailUrl = other.getDetailUrl();
        return !(this$detailUrl == null ? other$detailUrl != null : !this$detailUrl.equals(other$detailUrl));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MessageDO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $importance = this.getImportance();
        result = result * 59 + ($importance == null ? 43 : ((Object)$importance).hashCode());
        Integer $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)$state).hashCode());
        Boolean $hasReadDetail = this.getHasReadDetail();
        result = result * 59 + ($hasReadDetail == null ? 43 : ((Object)$hasReadDetail).hashCode());
        Boolean $noticeMobileApp = this.getNoticeMobileApp();
        result = result * 59 + ($noticeMobileApp == null ? 43 : ((Object)$noticeMobileApp).hashCode());
        Boolean $noticeOnlineUser = this.getNoticeOnlineUser();
        result = result * 59 + ($noticeOnlineUser == null ? 43 : ((Object)$noticeOnlineUser).hashCode());
        Boolean $hasAppPermission = this.getHasAppPermission();
        result = result * 59 + ($hasAppPermission == null ? 43 : ((Object)$hasAppPermission).hashCode());
        Boolean $unterminate = this.getUnterminate();
        result = result * 59 + ($unterminate == null ? 43 : ((Object)$unterminate).hashCode());
        String $gid = this.getGid();
        result = result * 59 + ($gid == null ? 43 : $gid.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $langName = this.getLangName();
        result = result * 59 + ($langName == null ? 43 : $langName.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $channelType = this.getChannelType();
        result = result * 59 + ($channelType == null ? 43 : $channelType.hashCode());
        String $subType = this.getSubType();
        result = result * 59 + ($subType == null ? 43 : $subType.hashCode());
        String $subTypeCategory = this.getSubTypeCategory();
        result = result * 59 + ($subTypeCategory == null ? 43 : $subTypeCategory.hashCode());
        String $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        JSONObject $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $jsonContent = this.getJsonContent();
        result = result * 59 + ($jsonContent == null ? 43 : $jsonContent.hashCode());
        LocalDateTime $sendDate = this.getSendDate();
        result = result * 59 + ($sendDate == null ? 43 : ((Object)$sendDate).hashCode());
        LocalDateTime $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        LocalDateTime $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        LocalDateTime $createDate = this.getCreateDate();
        result = result * 59 + ($createDate == null ? 43 : ((Object)$createDate).hashCode());
        LocalDateTime $modifyDate = this.getModifyDate();
        result = result * 59 + ($modifyDate == null ? 43 : ((Object)$modifyDate).hashCode());
        String $appCode = this.getAppCode();
        result = result * 59 + ($appCode == null ? 43 : $appCode.hashCode());
        String $appName = this.getAppName();
        result = result * 59 + ($appName == null ? 43 : $appName.hashCode());
        TemplateVariableDTO $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : $template.hashCode());
        String $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : $locale.hashCode());
        TargetAction $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        String $startTimeStr = this.getStartTimeStr();
        result = result * 59 + ($startTimeStr == null ? 43 : $startTimeStr.hashCode());
        String $endTimeStr = this.getEndTimeStr();
        result = result * 59 + ($endTimeStr == null ? 43 : $endTimeStr.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $detailUrl = this.getDetailUrl();
        result = result * 59 + ($detailUrl == null ? 43 : $detailUrl.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MessageDO(gid=" + this.getGid() + ", userId=" + this.getUserId() + ", langName=" + this.getLangName() + ", tenantId=" + this.getTenantId() + ", type=" + this.getType() + ", channelType=" + this.getChannelType() + ", subType=" + this.getSubType() + ", subTypeCategory=" + this.getSubTypeCategory() + ", category=" + this.getCategory() + ", importance=" + this.getImportance() + ", source=" + this.getSource() + ", state=" + this.getState() + ", hasReadDetail=" + this.getHasReadDetail() + ", title=" + this.getTitle() + ", content=" + this.getContent() + ", jsonContent=" + this.getJsonContent() + ", sendDate=" + this.getSendDate() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", createDate=" + this.getCreateDate() + ", modifyDate=" + this.getModifyDate() + ", noticeMobileApp=" + this.getNoticeMobileApp() + ", noticeOnlineUser=" + this.getNoticeOnlineUser() + ", appCode=" + this.getAppCode() + ", appName=" + this.getAppName() + ", hasAppPermission=" + this.getHasAppPermission() + ", template=" + this.getTemplate() + ", locale=" + this.getLocale() + ", action=" + this.getAction() + ", unterminate=" + this.getUnterminate() + ", startTimeStr=" + this.getStartTimeStr() + ", endTimeStr=" + this.getEndTimeStr() + ", key=" + this.getKey() + ", detailUrl=" + this.getDetailUrl() + ")";
    }

    @Generated
    public MessageDO() {
    }
}

