/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.domain.message.service.impl;

import com.digiwin.athena.aim.api.dto.DapEmpDisabledDTO;
import com.digiwin.athena.aim.domain.message.model.MessageDO;
import com.digiwin.athena.aim.domain.message.model.MsgStateEnum;
import com.digiwin.athena.aim.domain.message.repository.MessageMapperV2;
import com.digiwin.athena.aim.domain.message.service.ExtCustomMsgService;
import com.digiwin.athena.aim.domain.message.service.MessageSendService;
import com.digiwin.athena.aim.infrastructure.iam.IamService;
import com.digiwin.athena.aim.infrastructure.iam.dto.IamUserDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExtCustomMsgServiceImpl
implements ExtCustomMsgService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExtCustomMsgServiceImpl.class);
    private static final String EMP_DISABLED = "empDisabled";
    @Resource
    private MessageSendService messageSendService;
    @Resource
    private IamService iamService;
    @Autowired
    private MessageMapperV2 messageMapperV2;
    @Autowired
    MessageUtils messageUtils;

    public void dapEmpDisabled(DapEmpDisabledDTO dapEmpDisabledDTO) {
        log.info("[dapEmpDisabled] sendMessageRemindToClient-payload \uff1a{}", (Object)JsonUtils.objectToString((Object)dapEmpDisabledDTO));
        List userList = this.iamService.getUserListByRole("superadmin");
        Set<String> userIds = userList.stream().filter(user -> !user.isDeleted() || !user.isDisabled()).map(IamUserDTO::getId).collect(Collectors.toSet());
        ArrayList messageDOList = new ArrayList();
        userIds.forEach(userId -> {
            MessageDO messageDO = this.buildMessagePayload(dapEmpDisabledDTO, userId);
            messageDOList.add(messageDO);
            log.info("[dapEmpDisabled] sendMessageRemindToClient-payload \uff1atenantId={},userId={},message={}", new Object[]{dapEmpDisabledDTO.getTenantId(), userId, JsonUtils.objectToString((Object)messageDO)});
            this.messageSendService.sendToClient(dapEmpDisabledDTO.getTenantId(), userId, messageDO);
        });
        log.info("[dapEmpDisabled] insert message to mongo \uff1a{}", (Object)JsonUtils.objectToString(messageDOList));
        if (CollectionUtils.isNotEmpty(messageDOList)) {
            this.messageMapperV2.batchInsert(messageDOList);
        }
    }

    private MessageDO buildMessagePayload(DapEmpDisabledDTO dapEmpDisabledDTO, String userId) {
        MessageDO messageDO = new MessageDO();
        messageDO.setState(Integer.valueOf(MsgStateEnum.UNREAD.getState()));
        messageDO.setGid(String.valueOf(SnowflakeIdWorker.getInstance().newId()));
        messageDO.setUserId(userId);
        messageDO.setTenantId(dapEmpDisabledDTO.getTenantId());
        messageDO.setSendDate(LocalDateTime.now());
        messageDO.setType(EMP_DISABLED);
        String langName = this.iamService.getUserMetadataAllTenant(userId, 1, 0);
        messageDO.setLangName(langName);
        JSONObject content = new JSONObject();
        content.put((Object)"title", (Object)MessageFormat.format(this.messageUtils.getMessageByLangName("emp.disabled.msg.notice", langName), dapEmpDisabledDTO.getUserName(), dapEmpDisabledDTO.getReplacerUserName()));
        content.put((Object)"msg", (Object)"");
        messageDO.setContent(content);
        return messageDO;
    }
}

