/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.domain.message.service.impl;

import com.digiwin.athena.aim.api.dto.Page;
import com.digiwin.athena.aim.app.env.EnvProperties;
import com.digiwin.athena.aim.domain.message.model.MessageCenterConditionDTO;
import com.digiwin.athena.aim.domain.message.model.MessageCenterConfigDTO;
import com.digiwin.athena.aim.domain.message.model.MessageCenterPushConfig;
import com.digiwin.athena.aim.domain.message.model.MessageCenterPushReceiver;
import com.digiwin.athena.aim.domain.message.model.MessageCenterPushReceiverDuty;
import com.digiwin.athena.aim.domain.message.model.MessageCenterPushReceiverPersonnel;
import com.digiwin.athena.aim.domain.message.model.MessageCenterPushReceiverVariable;
import com.digiwin.athena.aim.domain.message.model.MessageCenterRecordDO;
import com.digiwin.athena.aim.domain.message.model.MessageCenterRecordReq;
import com.digiwin.athena.aim.domain.message.model.MessageCenterSceneDTO;
import com.digiwin.athena.aim.domain.message.model.MessageCenterSendConfigDTO;
import com.digiwin.athena.aim.domain.message.model.MessageCenterSendReq;
import com.digiwin.athena.aim.domain.message.model.MessageCenterTemplateDTO;
import com.digiwin.athena.aim.domain.message.model.MessageDO;
import com.digiwin.athena.aim.domain.message.repository.MessageCenterMapper;
import com.digiwin.athena.aim.domain.message.repository.MessageMapperV2;
import com.digiwin.athena.aim.domain.message.service.MessageCenterService;
import com.digiwin.athena.aim.infrastructure.concurrent.pool.DynamicThreadPool;
import com.digiwin.athena.aim.infrastructure.emc.EmcService;
import com.digiwin.athena.aim.infrastructure.eoc.EocService;
import com.digiwin.athena.aim.infrastructure.eoc.dto.EmpDTO;
import com.digiwin.athena.aim.infrastructure.iam.IamService;
import com.digiwin.athena.aim.infrastructure.iam.dto.PersonalizedDto;
import com.digiwin.athena.aim.util.ScriptUtil;
import com.digiwin.athena.aim.util.ValidateUtils;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.data.domain.PageImpl;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MessageCenterServiceImpl
implements MessageCenterService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageCenterServiceImpl.class);
    @Autowired
    private EmcService emcService;
    @Autowired
    private EocService eocService;
    @Autowired
    private IamService iamService;
    @Autowired
    private MessageMapperV2 messageMapperV2;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private MessageCenterMapper messageCenterMapper;
    @Autowired
    DynamicThreadPool taskExecutor;

    public PageImpl<MessageCenterRecordDO> record(MessageCenterRecordReq messageCenterSendReq) throws IllegalAccessException {
        ValidateUtils.checkPageParam((Page)messageCenterSendReq);
        return this.messageCenterMapper.pageMessageCenterRecord(messageCenterSendReq);
    }

    public void send(MessageCenterSendReq messageCenterSendReq) {
        log.info("[send] send msg start, req = {}", (Object)JsonUtils.objectToString((Object)messageCenterSendReq));
        List msgConfigList = this.emcService.getMsgConfigList(messageCenterSendReq.getTenantId(), messageCenterSendReq.getAppCode(), messageCenterSendReq.getSceneId());
        log.info("[send] \u67e5\u8be2\u573a\u666f\u914d\u7f6e result = {}", (Object)JsonUtils.objectToString((Object)msgConfigList));
        if (CollectionUtils.isEmpty((Collection)msgConfigList)) {
            return;
        }
        for (MessageCenterConfigDTO messageCenterConfig : msgConfigList) {
            Boolean isSend = this.judgmentConditional(messageCenterSendReq.getData(), messageCenterConfig.getType().getTriggerCondition());
            log.info("[send] \u6761\u4ef6\u5224\u65ad result = {}", (Object)isSend);
            if (!isSend.booleanValue()) continue;
            this.sendMsg(messageCenterSendReq.getTenantId(), messageCenterSendReq.getAppCode(), messageCenterSendReq.getData(), messageCenterConfig);
        }
    }

    private void sendMsg(String tenantId, String appCode, Map<String, Object> data, MessageCenterConfigDTO messageCenterConfig) {
        log.info("[send] sendMsg start tenantId = {}, appCode = {}, data = {}, messageCenterConfig = {} ", new Object[]{tenantId, appCode, JsonUtils.objectToString(data), JsonUtils.objectToString((Object)messageCenterConfig)});
        if (CollectionUtils.isEmpty((Collection)messageCenterConfig.getSettings())) {
            return;
        }
        if (MapUtils.isEmpty(data)) {
            data = new HashMap<String, Object>();
        }
        this.sendWebMsg(tenantId, appCode, data, messageCenterConfig);
        this.sendAppMsg(tenantId, appCode, data, messageCenterConfig);
        this.sendEmailMsg(appCode, data, messageCenterConfig);
        this.sendSmsMsg(appCode, data, messageCenterConfig);
        this.sendDingTalkMsg(tenantId, appCode, data, messageCenterConfig);
        this.sendWeComMsg(appCode, data, messageCenterConfig);
        log.info("[send] sendMsg end tenantId = {}, appCode = {}, data = {}, messageCenterConfig = {} ", new Object[]{tenantId, appCode, JsonUtils.objectToString(data), JsonUtils.objectToString((Object)messageCenterConfig)});
    }

    public void sendWeComMsg(String appCode, Map<String, Object> data, MessageCenterConfigDTO messageCenterConfig) {
        List messageCenterSendConfigList = messageCenterConfig.getSettings().stream().filter(messageCenterSendConfigDTO -> "weCom".equals(messageCenterSendConfigDTO.getType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(messageCenterSendConfigList)) {
            return;
        }
        this.taskExecutor.submit(() -> {
            for (MessageCenterSendConfigDTO messageCenterSendConfig : messageCenterSendConfigList) {
                log.info("[send] sendWeComMsg start data = {},messageCenterSendConfig = {}", (Object)JsonUtils.objectToString((Object)data), (Object)JsonUtils.objectToString((Object)messageCenterSendConfig));
                Map receivers = this.analysisPushConfig("weCom", data, messageCenterSendConfig);
                log.info("[send] sendWeComMsg  analysisPushConfig receivers = {}", (Object)JsonUtils.objectToString((Object)receivers));
                List contacts = (List)receivers.get("contacts");
                if (CollectionUtils.isEmpty((Collection)contacts)) {
                    return;
                }
                this.sendWeComMsg(appCode, data, messageCenterConfig, contacts);
            }
        });
    }

    public void sendDingTalkMsg(String tenantId, String appCode, Map<String, Object> data, MessageCenterConfigDTO messageCenterConfig) {
        List messageCenterSendConfigList = messageCenterConfig.getSettings().stream().filter(messageCenterSendConfigDTO -> "dingTalk".equals(messageCenterSendConfigDTO.getType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(messageCenterSendConfigList)) {
            return;
        }
        this.taskExecutor.submit(() -> {
            for (MessageCenterSendConfigDTO messageCenterSendConfig : messageCenterSendConfigList) {
                log.info("[send] sendDingTalkMsg start data = {},messageCenterSendConfig = {}", (Object)JsonUtils.objectToString((Object)data), (Object)JsonUtils.objectToString((Object)messageCenterSendConfig));
                Map receivers = this.analysisPushConfig("dingTalk", data, messageCenterSendConfig);
                log.info("[send] sendDingTalkMsg  analysisPushConfig receivers = {}", (Object)JsonUtils.objectToString((Object)receivers));
                List contacts = (List)receivers.get("contacts");
                if (CollectionUtils.isEmpty((Collection)contacts)) {
                    return;
                }
                this.sendDingTalkMsg(tenantId, appCode, data, messageCenterConfig, contacts);
            }
        });
    }

    public void sendSmsMsg(String appCode, Map<String, Object> data, MessageCenterConfigDTO messageCenterConfig) {
        List messageCenterSendConfigList = messageCenterConfig.getSettings().stream().filter(messageCenterSendConfigDTO -> "sms".equals(messageCenterSendConfigDTO.getType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(messageCenterSendConfigList)) {
            return;
        }
        this.taskExecutor.submit(() -> {
            for (MessageCenterSendConfigDTO messageCenterSendConfig : messageCenterSendConfigList) {
                log.info("[send] sendSmsMsg start data = {},messageCenterSendConfig = {}", (Object)JsonUtils.objectToString((Object)data), (Object)JsonUtils.objectToString((Object)messageCenterSendConfig));
                Map receivers = this.analysisPushConfig("sms", data, messageCenterSendConfig);
                log.info("[send] sendSmsMsg  analysisPushConfig receivers = {}", (Object)JsonUtils.objectToString((Object)receivers));
                List contacts = (List)receivers.get("contacts");
                if (CollectionUtils.isEmpty((Collection)contacts)) {
                    return;
                }
                this.sendSmsMsg(appCode, data, messageCenterConfig, contacts);
            }
        });
    }

    public void sendEmailMsg(String appCode, Map<String, Object> data, MessageCenterConfigDTO messageCenterConfig) {
        List messageCenterSendConfigList = messageCenterConfig.getSettings().stream().filter(messageCenterSendConfigDTO -> "email".equals(messageCenterSendConfigDTO.getType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(messageCenterSendConfigList)) {
            return;
        }
        this.taskExecutor.submit(() -> {
            for (MessageCenterSendConfigDTO messageCenterSendConfig : messageCenterSendConfigList) {
                log.info("[send] sendEmailMsg start data = {},messageCenterSendConfig = {}", (Object)JsonUtils.objectToString((Object)data), (Object)JsonUtils.objectToString((Object)messageCenterSendConfig));
                Map receivers = this.analysisPushConfig("email", data, messageCenterSendConfig);
                List contacts = (List)receivers.get("contacts");
                log.info("[send] sendEmailMsg  analysisPushConfig receivers = {}", (Object)JsonUtils.objectToString((Object)receivers));
                List ccContacts = (List)receivers.get("ccContacts");
                List bccContacts = (List)receivers.get("bccContacts");
                if (CollectionUtils.isEmpty((Collection)contacts) && CollectionUtils.isEmpty((Collection)ccContacts) && CollectionUtils.isEmpty((Collection)bccContacts)) {
                    return;
                }
                this.sendEmailMsg(appCode, data, messageCenterConfig, contacts, ccContacts, bccContacts);
            }
        });
    }

    public void sendAppMsg(String tenantId, String appCode, Map<String, Object> data, MessageCenterConfigDTO messageCenterConfig) {
        List messageCenterSendConfigList = messageCenterConfig.getSettings().stream().filter(messageCenterSendConfigDTO -> "app".equals(messageCenterSendConfigDTO.getType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(messageCenterSendConfigList)) {
            return;
        }
        this.taskExecutor.submit(() -> {
            for (MessageCenterSendConfigDTO messageCenterSendConfig : messageCenterSendConfigList) {
                log.info("[send] sendAppMsg start tenantId = {},appCode = {},data = {},messageCenterSendConfig = {}", new Object[]{tenantId, appCode, JsonUtils.objectToString((Object)data), JsonUtils.objectToString((Object)messageCenterSendConfig)});
                Map receivers = this.analysisPushConfig("app", data, messageCenterSendConfig);
                log.info("[send] sendAppMsg  analysisPushConfig  tenantId = {},appCode = {},receivers = {}", new Object[]{tenantId, appCode, JsonUtils.objectToString((Object)receivers)});
                List contacts = (List)receivers.get("contacts");
                if (CollectionUtils.isEmpty((Collection)contacts)) {
                    return;
                }
                List templates = this.analysisTemplate(data, messageCenterSendConfig);
                log.info("[send] sendAppMsg analysisTemplate  tenantId = {},appCode = {},data = {},templates = {}", new Object[]{tenantId, appCode, JsonUtils.objectToString((Object)data), JsonUtils.objectToString((Object)templates)});
                this.saveMessage(tenantId, appCode, "app", contacts, templates, data);
                this.saveMessageRecord("app", tenantId, appCode, messageCenterConfig.getType(), messageCenterSendConfig, contacts, templates);
            }
        });
    }

    public void sendWebMsg(String tenantId, String appCode, Map<String, Object> data, MessageCenterConfigDTO messageCenterConfig) {
        List messageCenterSendConfigList = messageCenterConfig.getSettings().stream().filter(messageCenterSendConfigDTO -> "web".equals(messageCenterSendConfigDTO.getType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(messageCenterSendConfigList)) {
            return;
        }
        this.taskExecutor.submit(() -> {
            for (MessageCenterSendConfigDTO messageCenterSendConfig : messageCenterSendConfigList) {
                log.info("[send] sendWebMsg start tenantId = {},appCode = {},data = {},messageCenterSendConfig = {}", new Object[]{tenantId, appCode, JsonUtils.objectToString((Object)data), JsonUtils.objectToString((Object)messageCenterSendConfig)});
                Map receivers = this.analysisPushConfig("web", data, messageCenterSendConfig);
                log.info("[send] sendWebMsg analysisPushConfig  tenantId = {},appCode = {},receivers = {}", new Object[]{tenantId, appCode, JsonUtils.objectToString((Object)receivers)});
                List contacts = (List)receivers.get("contacts");
                if (CollectionUtils.isEmpty((Collection)contacts)) {
                    return;
                }
                List templates = this.analysisTemplate(data, messageCenterSendConfig);
                log.info("[send] sendWebMsg analysisTemplate  tenantId = {},appCode = {},data = {},templates = {}", new Object[]{tenantId, appCode, JsonUtils.objectToString((Object)data), JsonUtils.objectToString((Object)templates)});
                this.saveMessage(tenantId, appCode, "web", contacts, templates, data);
                this.saveMessageRecord("web", tenantId, appCode, messageCenterConfig.getType(), messageCenterSendConfig, contacts, templates);
            }
        });
    }

    private void saveMessageRecord(String channelType, String tenantId, String appCode, MessageCenterSceneDTO messageCenterScene, MessageCenterSendConfigDTO messageCenterSendConfig, List<EmpDTO> contacts, List<MessageCenterTemplateDTO> templates) {
        log.info("[send] saveMessageHistory start  tenantId = {},appCode = {},channel = {},templates = {},contacts = {}", new Object[]{tenantId, appCode, channelType, JsonUtils.objectToString(templates), JsonUtils.objectToString(contacts)});
        MessageCenterRecordDO messageCenterRecordDO = new MessageCenterRecordDO();
        messageCenterRecordDO.setTenantId(tenantId);
        messageCenterRecordDO.setAppCode(appCode);
        messageCenterRecordDO.setChannelType(channelType);
        messageCenterRecordDO.setStatus(Long.valueOf(1L));
        messageCenterRecordDO.setMsgType(messageCenterSendConfig.getMsgType());
        if (null != messageCenterScene && null != messageCenterScene.getTriggerTiming()) {
            messageCenterRecordDO.setSceneId(messageCenterScene.getAthenaMessageId());
            messageCenterRecordDO.setSceneName(messageCenterScene.getName());
            messageCenterRecordDO.setEventId(messageCenterScene.getTriggerTiming().getEventId());
            messageCenterRecordDO.setEventName(messageCenterScene.getTriggerTiming().getEventName());
            HashMap lang = new HashMap();
            if (MapUtils.isNotEmpty((Map)messageCenterScene.getLang())) {
                lang.put("sceneName", messageCenterScene.getLang().get("name"));
            }
            if (MapUtils.isNotEmpty((Map)messageCenterScene.getTriggerTiming().getLang())) {
                lang.put("eventName", messageCenterScene.getTriggerTiming().getLang().get("eventName"));
            }
            messageCenterRecordDO.setLang(lang);
        }
        messageCenterRecordDO.setReceivers(this.bulidString(contacts, channelType));
        HashMap<String, Object> message = new HashMap<String, Object>();
        if (CollectionUtils.isNotEmpty(templates)) {
            MessageCenterTemplateDTO template = this.getTemplate(LocaleContextHolder.getLocale().toString(), templates);
            message.put("title", template.getSubject());
            message.put("content", template.getContent());
            HashMap<String, Map<String, String>> langMap = new HashMap<String, Map<String, String>>();
            langMap.put("title", templates.stream().collect(Collectors.toMap(MessageCenterTemplateDTO::getLanguage, MessageCenterTemplateDTO::getSubject)));
            langMap.put("content", templates.stream().collect(Collectors.toMap(MessageCenterTemplateDTO::getLanguage, MessageCenterTemplateDTO::getContent)));
            message.put("lang", langMap);
            messageCenterRecordDO.setMessage(message);
        }
        messageCenterRecordDO.setCreateDate(LocalDateTime.now());
        messageCenterRecordDO.setModifyDate(LocalDateTime.now());
        log.info("[send] saveMessageHistory insert record  tenantId = {},appCode = {},channel = {},messageCenterRecordDO = {}", new Object[]{tenantId, appCode, channelType, JsonUtils.objectToString((Object)messageCenterRecordDO)});
        this.messageCenterMapper.insert(messageCenterRecordDO);
    }

    private void sendWeComMsg(String appCode, Map<String, Object> data, MessageCenterConfigDTO messageCenterConfig, List<EmpDTO> contacts) {
        Map<String, List<EmpDTO>> contactsLang = contacts.stream().collect(Collectors.groupingBy(EmpDTO::getLang));
        log.info("[send] sendWeComMsg start data = {},messageCenterSendConfig = {}, contactsLang = {}, contacts = {}", new Object[]{JsonUtils.objectToString(data), JsonUtils.objectToString((Object)messageCenterConfig), JsonUtils.objectToString(contactsLang), JsonUtils.objectToString(contacts)});
        for (String lang : contactsLang.keySet()) {
            List<EmpDTO> empDTOS = contactsLang.get(lang);
            List userList = this.bulidContactsList(empDTOS, "weCom");
            JSONObject req = new JSONObject();
            req.put((Object)"currentAppId", (Object)appCode);
            req.put((Object)"eventId", (Object)messageCenterConfig.getType().getId());
            ArrayList<String> types = new ArrayList<String>();
            types.add("weCom");
            req.put((Object)"types", types);
            HashMap<String, Object> reqData = new HashMap<String, Object>();
            reqData.put("userList", userList);
            String appId = this.getAppId();
            if (StringUtils.isBlank((CharSequence)appId)) {
                log.info("[send] sendWeComMsg  appId is null ");
                continue;
            }
            reqData.put("appId", appId);
            reqData.put("messageData", data);
            HashMap<String, HashMap<String, Object>> message = new HashMap<String, HashMap<String, Object>>();
            message.put("data", reqData);
            req.put((Object)"message", message);
            log.info("[send] sendWeComMsg  lang = {},req = {}", (Object)lang, (Object)req);
            this.emcService.sendCommonChannelMsg(lang, req);
        }
    }

    private String getAppId() {
        JSONArray data;
        ResponseEntity wecomConfig = this.emcService.getWecomConfig();
        if (null != wecomConfig && 200 == wecomConfig.getStatusCodeValue() && wecomConfig.getBody() != null && (data = ((JSONObject)wecomConfig.getBody()).getJSONArray("data")) != null && data.size() > 0) {
            JSONObject jsonObject = data.getJSONObject(0);
            String appId = jsonObject.getString("appId");
            return appId;
        }
        return "";
    }

    private void sendDingTalkMsg(String tenantId, String appCode, Map<String, Object> data, MessageCenterConfigDTO messageCenterConfig, List<EmpDTO> contacts) {
        Map<String, List<EmpDTO>> contactsLang = contacts.stream().collect(Collectors.groupingBy(EmpDTO::getLang));
        log.info("[send] sendDingTalkMsg start data = {},messageCenterSendConfig = {}, contactsLang = {}, contacts = {}", new Object[]{JsonUtils.objectToString(data), JsonUtils.objectToString((Object)messageCenterConfig), JsonUtils.objectToString(contactsLang), JsonUtils.objectToString(contacts)});
        for (String lang : contactsLang.keySet()) {
            List<EmpDTO> empDTOS = contactsLang.get(lang);
            List userList = this.bulidContactsList(empDTOS, "dingTalk");
            JSONObject req = new JSONObject();
            req.put((Object)"currentAppId", (Object)appCode);
            req.put((Object)"eventId", (Object)messageCenterConfig.getType().getId());
            ArrayList<String> types = new ArrayList<String>();
            types.add("dingTalk");
            req.put((Object)"types", types);
            HashMap<String, Object> reqData = new HashMap<String, Object>();
            reqData.put("userList", userList);
            reqData.put("appId", appCode);
            String corpid = this.iamService.getTenantCorpid();
            reqData.put("corpId", StringUtils.isNotBlank((CharSequence)corpid) ? corpid : tenantId);
            reqData.put("tenantId", tenantId);
            data.put("tenantId", StringUtils.isNotBlank((CharSequence)corpid) ? corpid : tenantId);
            reqData.put("messageData", data);
            HashMap<String, HashMap<String, Object>> message = new HashMap<String, HashMap<String, Object>>();
            message.put("data", reqData);
            req.put((Object)"message", message);
            log.info("[send] sendDingTalkMsg  lang = {},req = {}", (Object)lang, (Object)req);
            this.emcService.sendCommonChannelMsg(lang, req);
        }
    }

    private void sendSmsMsg(String appCode, Map<String, Object> data, MessageCenterConfigDTO messageCenterConfig, List<EmpDTO> contacts) {
        Map<String, List<EmpDTO>> contactsLang = contacts.stream().collect(Collectors.groupingBy(EmpDTO::getLang));
        log.info("[send] sendSmsMsg start data = {},messageCenterSendConfig = {}, contactsLang = {}, contacts = {}", new Object[]{JsonUtils.objectToString(data), JsonUtils.objectToString((Object)messageCenterConfig), JsonUtils.objectToString(contactsLang), JsonUtils.objectToString(contacts)});
        for (String lang : contactsLang.keySet()) {
            List<EmpDTO> empDTOS = contactsLang.get(lang);
            String contactsStr = this.bulidString(empDTOS, "sms");
            JSONObject req = new JSONObject();
            req.put((Object)"currentAppId", (Object)appCode);
            req.put((Object)"eventId", (Object)messageCenterConfig.getType().getId());
            req.put((Object)"telephone", (Object)contactsStr);
            ArrayList<String> types = new ArrayList<String>();
            types.add("sms");
            req.put((Object)"types", types);
            HashMap<String, Map<String, Object>> message = new HashMap<String, Map<String, Object>>();
            message.put("data", data);
            req.put((Object)"message", message);
            log.info("[send] sendSmsMsg  lang = {},req = {}", (Object)lang, (Object)req);
            this.emcService.sendCommonChannelMsg(lang, req);
        }
    }

    private void sendEmailMsg(String appCode, Map<String, Object> data, MessageCenterConfigDTO messageCenterConfig, List<EmpDTO> contacts, List<EmpDTO> ccContacts, List<EmpDTO> bccContacts) {
        log.info("[send] sendEmailMsg start data = {},messageCenterSendConfig = {}, contacts = {}, ccContacts = {}, bccContacts = {}", new Object[]{JsonUtils.objectToString(data), JsonUtils.objectToString((Object)messageCenterConfig), JsonUtils.objectToString(contacts), JsonUtils.objectToString(ccContacts), JsonUtils.objectToString(bccContacts)});
        String contactsStr = this.bulidString(contacts, "email");
        String ccContactsStr = this.bulidString(ccContacts, "email");
        String bccContactsStr = this.bulidString(bccContacts, "email");
        JSONObject req = new JSONObject();
        req.put((Object)"currentAppId", (Object)appCode);
        req.put((Object)"eventId", (Object)messageCenterConfig.getType().getId());
        req.put((Object)"contacts", (Object)contactsStr);
        req.put((Object)"ccContacts", (Object)ccContactsStr);
        req.put((Object)"bccContacts", (Object)bccContactsStr);
        ArrayList<String> types = new ArrayList<String>();
        types.add("email");
        req.put((Object)"types", types);
        HashMap<String, Map<String, Object>> message = new HashMap<String, Map<String, Object>>();
        message.put("data", data);
        req.put((Object)"message", message);
        String lang = this.envProperties.getDefaultLang();
        log.info("[send] sendEmailMsg  lang = {},req = {}", (Object)lang, (Object)req);
        this.emcService.sendCommonChannelMsg(lang, req);
    }

    private String bulidString(List<EmpDTO> empDTOS, String channel) {
        if (CollectionUtils.isEmpty(empDTOS)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if ("email".equals(channel)) {
            for (EmpDTO empDTO : empDTOS) {
                if (!StringUtils.isNotBlank((CharSequence)empDTO.getEmail())) continue;
                sb.append(empDTO.getEmail()).append(";");
            }
        }
        if ("sms".equals(channel)) {
            for (EmpDTO empDTO : empDTOS) {
                if (!StringUtils.isNotBlank((CharSequence)empDTO.getTelephone())) continue;
                sb.append(empDTO.getTelephone()).append(";");
            }
        }
        if ("web".equals(channel) || "app".equals(channel)) {
            for (EmpDTO empDTO : empDTOS) {
                if (!StringUtils.isNotBlank((CharSequence)empDTO.getUserId())) continue;
                sb.append(empDTO.getUserId()).append(";");
            }
        }
        if (sb.length() == 0) {
            return "";
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }

    private List<String> bulidContactsList(List<EmpDTO> empDTOS, String channel) {
        ArrayList<String> userList = new ArrayList<String>();
        if (CollectionUtils.isEmpty(empDTOS)) {
            return userList;
        }
        if ("dingTalk".equals(channel)) {
            empDTOS.forEach(empDTO -> {
                if (StringUtils.isNotBlank((CharSequence)empDTO.getUserId())) {
                    userList.add(empDTO.getUserId());
                }
            });
        }
        if ("weCom".equals(channel)) {
            empDTOS.forEach(empDTO -> {
                if (StringUtils.isNotBlank((CharSequence)empDTO.getUserId())) {
                    userList.add(empDTO.getUserId());
                }
            });
        }
        return userList;
    }

    private void saveMessage(String tenantId, String appCode, String channel, List<EmpDTO> contacts, List<MessageCenterTemplateDTO> templates, Map<String, Object> data) {
        log.info("[send] saveMessage start  tenantId = {},appCode = {},channel = {},data = {},templates = {},contacts = {}", new Object[]{tenantId, appCode, channel, JsonUtils.objectToString(data), JsonUtils.objectToString(templates), JsonUtils.objectToString(contacts)});
        if (CollectionUtils.isEmpty(contacts) || CollectionUtils.isEmpty(templates)) {
            return;
        }
        ArrayList messageList = new ArrayList();
        contacts.forEach(empDTO -> {
            if (StringUtils.isNotBlank((CharSequence)empDTO.getUserId())) {
                MessageDO messageDO = new MessageDO();
                messageDO.setGid(String.valueOf(SnowflakeIdWorker.getInstance().newId()));
                messageDO.setTenantId(tenantId);
                messageDO.setAppCode(appCode);
                messageDO.setUserId(empDTO.getUserId());
                messageDO.setChannelType(channel);
                messageDO.setState(Integer.valueOf(0));
                messageDO.setHasReadDetail(Boolean.valueOf(null != data.get("hasReadDetail") ? (Boolean)data.get("hasReadDetail") : false));
                messageDO.setLangName(empDTO.getLang());
                messageDO.setImportance(Integer.valueOf(null != data.get("importance") ? Integer.parseInt(String.valueOf(data.get("importance"))) : 0));
                messageDO.setSource(null != data.get("source") ? String.valueOf(data.get("source")) : "athena");
                messageDO.setType(null != data.get("type") ? String.valueOf(data.get("type")) : "other");
                messageDO.setCategory(null != data.get("category") ? String.valueOf(data.get("category")) : "OTHER");
                messageDO.setSubType(String.valueOf(data.get("subType")));
                messageDO.setSubTypeCategory(null != data.get("subTypeCategory") ? String.valueOf(data.get("subTypeCategory")) : "OTHER");
                MessageCenterTemplateDTO template = this.getTemplate(empDTO.getLang(), templates);
                if (null != template) {
                    data.put("title", template.getSubject());
                    data.put("msg", template.getContent());
                    messageDO.setContent(JSONObject.fromObject((Object)data));
                    messageDO.setCreateDate(LocalDateTime.now());
                    messageDO.setSendDate(LocalDateTime.now());
                    messageDO.setModifyDate(LocalDateTime.now());
                    messageList.add(messageDO);
                }
            }
        });
        if (CollectionUtils.isEmpty(messageList)) {
            return;
        }
        log.info("[send] saveMessage insert message  tenantId = {},appCode = {},channel = {},messageList = {}", new Object[]{tenantId, appCode, channel, JsonUtils.objectToString(messageList)});
        this.messageMapperV2.batchInsert(messageList);
    }

    private MessageCenterTemplateDTO getTemplate(String lang, List<MessageCenterTemplateDTO> templates) {
        Optional<MessageCenterTemplateDTO> templateDTOOptional = templates.stream().filter(messageCenterTemplateDTO -> lang.equals(messageCenterTemplateDTO.getLanguage())).findFirst();
        if (templateDTOOptional.isPresent()) {
            return templateDTOOptional.get();
        }
        Optional<MessageCenterTemplateDTO> systemOptional = templates.stream().filter(messageCenterTemplateDTO -> this.envProperties.getDefaultLang().equals(messageCenterTemplateDTO.getLanguage())).findFirst();
        return systemOptional.orElseGet(() -> (MessageCenterTemplateDTO)templates.get(0));
    }

    private List<MessageCenterTemplateDTO> analysisTemplate(Map<String, Object> data, MessageCenterSendConfigDTO messageCenterSendConfig) {
        List templates = messageCenterSendConfig.getTemplates();
        if (CollectionUtils.isEmpty((Collection)templates)) {
            return new ArrayList<MessageCenterTemplateDTO>();
        }
        return this.replaceTemplatesVariable(data, templates);
    }

    private List<MessageCenterTemplateDTO> replaceTemplatesVariable(Map<String, Object> data, List<MessageCenterTemplateDTO> templates) {
        for (MessageCenterTemplateDTO template : templates) {
            template.setSubject(this.templateVariableReplace(data, template.getSubject()));
            template.setContent(this.templateVariableReplace(data, template.getContent()));
        }
        return templates;
    }

    private String templateVariableReplace(Map<String, Object> data, String content) {
        if (MapUtils.isEmpty(data)) {
            return content;
        }
        Pattern pattern = Pattern.compile("\\{(\\w+)}");
        Matcher matcher = pattern.matcher(content);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            SimpleDateFormat dateFormat;
            String key = matcher.group(1);
            Object replacement = data.getOrDefault(key, matcher.group(0));
            if (replacement instanceof Date) {
                dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                replacement = dateFormat.format(replacement);
            }
            if (replacement instanceof Date) {
                dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                replacement = dateFormat.format((Date)replacement);
            } else if (replacement instanceof LocalDateTime) {
                DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                replacement = ((LocalDateTime)replacement).format(dateTimeFormatter);
            } else if (replacement instanceof LocalDate) {
                DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                replacement = ((LocalDate)replacement).format(dateFormatter);
            }
            matcher.appendReplacement(result, String.valueOf(replacement));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private Map<String, List<EmpDTO>> analysisPushConfig(String channel, Map<String, Object> data, MessageCenterSendConfigDTO messageCenterSendConfig) {
        List pushConfig = messageCenterSendConfig.getPushConfig();
        if (CollectionUtils.isEmpty((Collection)pushConfig)) {
            return new HashMap<String, List<EmpDTO>>();
        }
        HashMap<String, List<EmpDTO>> receivers = new HashMap<String, List<EmpDTO>>();
        List contacts = this.analysisContacts("contacts", channel, data, pushConfig);
        receivers.put("contacts", contacts);
        List ccContacts = this.analysisContacts("ccContacts", channel, data, pushConfig);
        receivers.put("ccContacts", ccContacts);
        List bccContacts = this.analysisContacts("bccContacts", channel, data, pushConfig);
        receivers.put("bccContacts", bccContacts);
        return receivers;
    }

    private List<EmpDTO> analysisContacts(String contactsType, String channel, Map<String, Object> data, List<MessageCenterPushConfig> pushConfig) {
        List personalizedDtos;
        Optional<MessageCenterPushConfig> messageCenterPushConfigOptional = pushConfig.stream().filter(messageCenterPushConfig -> contactsType.equals(messageCenterPushConfig.getType())).findFirst();
        if (!messageCenterPushConfigOptional.isPresent()) {
            return new ArrayList<EmpDTO>();
        }
        ArrayList<EmpDTO> empList = new ArrayList();
        HashSet userIdList = new HashSet();
        List messageCenterPushReceivers = messageCenterPushConfigOptional.get().getReceivers();
        if (CollectionUtils.isNotEmpty((Collection)messageCenterPushReceivers)) {
            List receiverVariables;
            Optional<MessageCenterPushReceiver> variablePushReceiverOptional;
            List outsiders;
            Optional<MessageCenterPushReceiver> outsidersPushReceiverOptional;
            List userIds;
            List dutyIds;
            List emps;
            List receiverDutys;
            Optional<MessageCenterPushReceiver> dutyPushReceiverOptional;
            List receiverPersonnels;
            Optional<MessageCenterPushReceiver> personnelPushReceiverOptional = messageCenterPushReceivers.stream().filter(messageCenterPushReceiver -> "personnel".equals(messageCenterPushReceiver.getClassification())).findFirst();
            if (personnelPushReceiverOptional.isPresent() && CollectionUtils.isNotEmpty((Collection)(receiverPersonnels = personnelPushReceiverOptional.get().getPersonnel()))) {
                List empIds = receiverPersonnels.stream().map(MessageCenterPushReceiverPersonnel::getEmpId).collect(Collectors.toList());
                List emps2 = this.eocService.getEmpByIds(null, empIds);
                empList.addAll(emps2);
                List userIds2 = emps2.stream().map(EmpDTO::getUserId).filter(StringUtils::isNotBlank).collect(Collectors.toList());
                userIdList.addAll(userIds2);
            }
            if ((dutyPushReceiverOptional = messageCenterPushReceivers.stream().filter(messageCenterPushReceiver -> "duty".equals(messageCenterPushReceiver.getClassification())).findFirst()).isPresent() && CollectionUtils.isNotEmpty((Collection)(receiverDutys = dutyPushReceiverOptional.get().getDuty())) && CollectionUtils.isNotEmpty((Collection)(emps = this.eocService.getEmpByDutyIds(dutyIds = receiverDutys.stream().map(MessageCenterPushReceiverDuty::getDutyId).collect(Collectors.toList()))))) {
                empList.addAll(emps);
                userIds = emps.stream().map(EmpDTO::getUserId).filter(StringUtils::isNotBlank).collect(Collectors.toList());
                userIdList.addAll(userIds);
            }
            if ((outsidersPushReceiverOptional = messageCenterPushReceivers.stream().filter(messageCenterPushReceiver -> "outsiders".equals(messageCenterPushReceiver.getClassification())).findFirst()).isPresent() && CollectionUtils.isNotEmpty((Collection)(outsiders = outsidersPushReceiverOptional.get().getOutsiders()))) {
                emps = this.buildEmpsByChannel(outsiders, channel);
                userIds = emps.stream().map(EmpDTO::getUserId).filter(StringUtils::isNotBlank).collect(Collectors.toList());
                userIdList.addAll(userIds);
                empList.addAll(emps);
            }
            if ((variablePushReceiverOptional = messageCenterPushReceivers.stream().filter(messageCenterPushReceiver -> "variable".equals(messageCenterPushReceiver.getClassification())).findFirst()).isPresent() && CollectionUtils.isNotEmpty((Collection)(receiverVariables = variablePushReceiverOptional.get().getVariable()))) {
                List empByUserList;
                Set keySet = receiverVariables.stream().filter(messageCenterPushReceiverVariable -> StringUtils.isNotBlank((CharSequence)messageCenterPushReceiverVariable.getKey())).map(MessageCenterPushReceiverVariable::getKey).collect(Collectors.toSet());
                List idList = this.analysisVariable(data, keySet);
                List empByEmps = this.eocService.getEmpByIds(null, idList);
                if (CollectionUtils.isNotEmpty((Collection)empByEmps)) {
                    empList.addAll(empByEmps);
                    List userIds3 = empByEmps.stream().map(EmpDTO::getUserId).filter(StringUtils::isNotBlank).collect(Collectors.toList());
                    userIdList.addAll(userIds3);
                }
                if (CollectionUtils.isNotEmpty((Collection)(empByUserList = this.eocService.getEmpByIds(idList, null)))) {
                    empList.addAll(empByUserList);
                    List userIds4 = empByUserList.stream().map(EmpDTO::getUserId).filter(StringUtils::isNotBlank).collect(Collectors.toList());
                    userIdList.addAll(userIds4);
                }
            }
        }
        if (CollectionUtils.isEmpty(empList = empList.stream().filter(EmpDTO::getStatus).collect(Collectors.toList()))) {
            return empList;
        }
        empList = empList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<EmpDTO>(Comparator.comparing(EmpDTO::getId))), ArrayList::new));
        if (CollectionUtils.isNotEmpty(userIdList) && CollectionUtils.isNotEmpty((Collection)(personalizedDtos = this.iamService.queryUserLangMetadataList(new ArrayList(userIdList))))) {
            Map<String, String> langRel = personalizedDtos.stream().collect(Collectors.toMap(PersonalizedDto::getUserId, PersonalizedDto::getValue));
            empList.stream().forEach(empDTO -> {
                if (StringUtils.isNotBlank((CharSequence)empDTO.getUserId())) {
                    empDTO.setLang(StringUtils.isNotBlank((CharSequence)((CharSequence)langRel.get(empDTO.getUserId()))) ? (String)langRel.get(empDTO.getUserId()) : this.envProperties.getDefaultLang());
                } else {
                    empDTO.setLang(this.envProperties.getDefaultLang());
                }
            });
        }
        return empList;
    }

    private List<String> analysisVariable(Map<String, Object> data, Set<String> keySet) {
        if (CollectionUtils.isEmpty(keySet) || MapUtils.isEmpty(data)) {
            return new ArrayList<String>();
        }
        ArrayList<String> idList = new ArrayList<String>();
        for (String key : keySet) {
            if (null == data.get(key)) continue;
            idList.add(String.valueOf(data.get(key)));
        }
        return idList;
    }

    private List<EmpDTO> buildEmpsByChannel(List<String> outsiders, String channel) {
        ArrayList<EmpDTO> emps = new ArrayList<EmpDTO>();
        for (String outsider : outsiders) {
            EmpDTO emp = new EmpDTO();
            emp.setId("outsider-" + outsider);
            emp.setStatus(Boolean.valueOf(true));
            emp.setLang(this.envProperties.getDefaultLang());
            if ("web".equals(channel) || "app".equals(channel)) {
                emp.setUserId(outsider);
                emp.setName(outsider);
            }
            if ("sms".equals(channel)) {
                emp.setTelephone(outsider);
                emp.setName(outsider);
            }
            if ("email".equals(channel)) {
                emp.setEmail(outsider);
                emp.setName(outsider);
            }
            if ("weCom".equals(channel)) {
                emp.setUserId(outsider);
                emp.setName(outsider);
            }
            if ("dingTalk".equals(channel)) {
                emp.setUserId(outsider);
                emp.setName(outsider);
            }
            emps.add(emp);
        }
        return emps;
    }

    private Boolean judgmentConditional(Map<String, Object> data, List<Map<String, Object>> triggerCondition) {
        if (CollectionUtils.isEmpty(triggerCondition)) {
            return true;
        }
        List messageCenterConditions = MessageCenterServiceImpl.transferCondition(triggerCondition);
        log.info("[send] transferCondition result = {}", (Object)JsonUtils.objectToString((Object)messageCenterConditions));
        String expression = MessageCenterServiceImpl.transferExpression((List)messageCenterConditions);
        log.info("[send] judgmentConditional expression = {}", (Object)expression);
        try {
            return (Boolean)ScriptUtil.getInstance().JsEvaluator(expression, "data", data);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String transferExpression(List<MessageCenterConditionDTO> messageCenterConditionS) {
        StringBuilder expression = new StringBuilder();
        for (MessageCenterConditionDTO condition : messageCenterConditionS) {
            List searchOperatorList;
            String searchTablePath = "data.";
            String bracket = condition.getBracket();
            String logic = condition.getLogic();
            String searchOperator = condition.getSearch_operator();
            String mode = condition.getMode();
            String searchField = condition.getSearch_field();
            List searchValue = condition.getSearch_value();
            if (StringUtils.isNotBlank((CharSequence)bracket) && bracket.equals("(")) {
                expression.append(bracket);
            }
            if (CollectionUtils.isNotEmpty((Collection)(searchOperatorList = MessageCenterServiceImpl.searchOperatorChange((String)searchOperator)))) {
                if (searchOperatorList.size() == 1) {
                    MessageCenterServiceImpl.generateExpressionByOperate((StringBuilder)expression, (String)((String)searchOperatorList.get(0)), (String)searchTablePath, (String)searchField, searchValue.get(0), (String)mode);
                } else if (searchOperatorList.size() == 2) {
                    MessageCenterServiceImpl.generateExpressionByOperate((StringBuilder)expression, (String)((String)searchOperatorList.get(0)), (String)searchTablePath, (String)searchField, searchValue.get(0), (String)mode);
                    expression.append("&&").append(" ");
                    MessageCenterServiceImpl.generateExpressionByOperate((StringBuilder)expression, (String)((String)searchOperatorList.get(1)), (String)searchTablePath, (String)searchField, searchValue.get(1), (String)mode);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)bracket) && bracket.equals(")")) {
                expression.append(bracket);
            }
            if (!StringUtils.isNotBlank((CharSequence)logic)) continue;
            logic = MessageCenterServiceImpl.logicChange((String)logic);
            expression.append(logic).append(" ");
        }
        return expression.toString();
    }

    private static List<String> searchOperatorChange(String searchOperator) {
        ArrayList<String> searchOperatorResultList = new ArrayList<String>();
        switch (searchOperator) {
            case "equal": {
                searchOperatorResultList.add("==");
                break;
            }
            case "greater": {
                searchOperatorResultList.add(">");
                break;
            }
            case "less": {
                searchOperatorResultList.add("<");
                break;
            }
            case "greater_equal": {
                searchOperatorResultList.add(">=");
                break;
            }
            case "less_equal": {
                searchOperatorResultList.add("<=");
                break;
            }
            case "like": {
                searchOperatorResultList.add("includes");
                break;
            }
            case "not_like": {
                searchOperatorResultList.add("not includes");
                break;
            }
            case "not_equal": {
                searchOperatorResultList.add("!=");
                break;
            }
            case "between": {
                searchOperatorResultList.add(">=");
                searchOperatorResultList.add("<=");
            }
        }
        return searchOperatorResultList;
    }

    private static String logicChange(String logic) {
        String logicResult = "";
        if (logic.equals("AND")) {
            logicResult = "&&";
        } else if (logic.equals("OR")) {
            logicResult = "||";
        }
        return logicResult;
    }

    private static void generateExpressionByOperate(StringBuilder expression, String searchOperator, String searchTablePath, String searchField, Object conditionValue, String type) {
        boolean numberFlag = false;
        if (conditionValue instanceof Integer || conditionValue instanceof Double || conditionValue instanceof Long || conditionValue instanceof BigDecimal || conditionValue instanceof Float || conditionValue instanceof Boolean) {
            numberFlag = true;
        } else if (StringUtils.isNotBlank((CharSequence)type) && "CUSTOM_CONSTANT".equals(type)) {
            numberFlag = true;
        }
        if (searchOperator.equals("includes")) {
            expression.append(searchTablePath).append(searchField).append(".indexOf('").append(conditionValue).append("') != -1").append(" ");
        } else if (searchOperator.equals("not includes")) {
            expression.append(searchTablePath).append(searchField).append(".indexOf('").append(conditionValue).append("') == -1").append(" ");
        } else if (numberFlag) {
            expression.append(searchTablePath).append(searchField).append(" ").append(searchOperator).append(conditionValue).append(" ");
        } else {
            expression.append(searchTablePath).append(searchField).append(" ").append(searchOperator).append(" '").append(conditionValue).append("' ");
        }
    }

    public static List<MessageCenterConditionDTO> transferCondition(List<Map<String, Object>> triggerCondition) {
        ArrayList<MessageCenterConditionDTO> searchInfo = new ArrayList<MessageCenterConditionDTO>();
        int order = 0;
        for (int i = 0; i < triggerCondition.size(); ++i) {
            Map<String, Object> item = triggerCondition.get(i);
            List queryGroup = (List)item.get("queryGroup");
            String logic = (String)item.get("logic");
            for (int j = 0; j < queryGroup.size(); ++j) {
                Map groupItem = (Map)queryGroup.get(j);
                List<Object> searchValue = new ArrayList();
                Object searchValueObj = groupItem.get("searchValue");
                if (!(searchValueObj instanceof List)) {
                    searchValue.add(searchValueObj);
                } else {
                    searchValue = (List)searchValueObj;
                }
                MessageCenterConditionDTO searchParams = new MessageCenterConditionDTO();
                searchParams.setOrder(order++);
                searchParams.setSearch_field((String)groupItem.get("searchField"));
                searchParams.setSearch_operator((String)groupItem.get("searchOperator"));
                searchParams.setSearch_value(searchValue);
                searchParams.setMode((String)groupItem.get("mode"));
                searchParams.setSearch_table_path((String)groupItem.get("search_table_path"));
                if ("empty".equals(searchParams.getSearch_operator())) {
                    searchParams.setSearch_operator("equal");
                }
                if ("notEmpty".equals(searchParams.getSearch_operator())) {
                    searchParams.setSearch_operator("not_equal");
                }
                if (queryGroup.size() > 1) {
                    if (j == 0) {
                        searchParams.setBracket("(");
                    } else if (j == queryGroup.size() - 1) {
                        searchParams.setBracket(")");
                    }
                }
                if (j != 0) {
                    ((MessageCenterConditionDTO)searchInfo.get(searchInfo.size() - 1)).setLogic((String)groupItem.get("logic"));
                } else if (i != 0) {
                    ((MessageCenterConditionDTO)searchInfo.get(searchInfo.size() - 1)).setLogic(logic);
                }
                searchInfo.add(searchParams);
            }
        }
        return searchInfo;
    }
}

