/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.domain.message.service.impl;

import com.digiwin.athena.aim.domain.message.service.MiscHandleService;
import com.digiwin.athena.aim.infrastructure.mongo.AbstractMongoMessageMapper;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.MessageUtils;
import java.text.MessageFormat;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="miscHandleServiceImpl")
public class MiscHandleServiceImpl
extends AbstractMongoMessageMapper
implements MiscHandleService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MiscHandleServiceImpl.class);
    @Autowired
    private MessageUtils messageUtils;
    private static final String TENANT_ID_PREFIX = "digidemo";
    private static final String RECORD_TENANT_ID_PREFIX = "digir";
    private static final String CREATE_TENANT_ID_PREFIX = "digid";

    public void resetDataByTenantId() {
        AuthoredUser user = AppAuthContextHolder.getContext().getAuthoredUser();
        if (StringUtils.isEmpty((Object)user.getTenantId())) {
            throw BusinessException.create((String)this.messageUtils.getMessage("exception.tenant.empty"));
        }
        if (!(StringUtils.startsWithIgnoreCase((String)user.getTenantId(), (String)RECORD_TENANT_ID_PREFIX) || StringUtils.startsWithIgnoreCase((String)user.getTenantId(), (String)CREATE_TENANT_ID_PREFIX) || StringUtils.startsWithIgnoreCase((String)user.getTenantId(), (String)TENANT_ID_PREFIX))) {
            throw BusinessException.create((String)MessageFormat.format(this.messageUtils.getMessage("exception.tenant.error"), user.getTenantId()));
        }
        String collectionName = this.getCollectionName(user.getTenantId());
        this.msgMongoTemplate.dropCollection(collectionName);
    }

    public void deleteByTenantId(String tenantId) {
        if (StringUtils.isEmpty((Object)tenantId)) {
            throw BusinessException.create((String)this.messageUtils.getMessage("exception.tenant.error"));
        }
        String collectionName = this.getCollectionName(tenantId);
        this.msgMongoTemplate.dropCollection(collectionName);
    }
}

