/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.domain.message.service.impl;

import com.digiwin.athena.aim.app.env.EnvProperties;
import com.digiwin.athena.aim.common.CategoryEnum;
import com.digiwin.athena.aim.domain.message.model.MessageBatchUserDTO;
import com.digiwin.athena.aim.domain.message.model.MessageContentDO;
import com.digiwin.athena.aim.domain.message.model.MessageDO;
import com.digiwin.athena.aim.domain.message.service.WecomMessageService;
import com.digiwin.athena.aim.infrastructure.emc.EmcService;
import com.digiwin.athena.aim.infrastructure.iam.IamService;
import com.digiwin.athena.aim.infrastructure.iam.dto.IamUserTokenDTO;
import com.digiwin.athena.aim.util.AESUtils;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class WecomMessageServiceImpl
implements WecomMessageService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WecomMessageServiceImpl.class);
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Resource
    private EnvProperties envProperties;
    @Resource
    private EmcService emcService;
    @Autowired
    private IamService iamService;
    @Autowired
    private MessageUtils messageUtils;
    @Resource
    private RestTemplate restTemplate;
    public static final String MESSAGE_LINK_URL = "<a href=\"%s\">%s</a>";
    public static final String ASA_MESSAGE_LINK_URL = "<div class=\\\"gray\\\">%s</div> <div class=\\\"normal\\\">%s</div>";
    private static final String END_TIME_FORM = "YYYY\u5e74M\u6708d\u65e5";

    public void sendWecomMessage(MessageBatchUserDTO messageBatchUserDTO) throws UnsupportedEncodingException {
        MessageDO message = messageBatchUserDTO.getMessage();
        if (message == null) {
            return;
        }
        MessageContentDO messageContentDO = (MessageContentDO)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)message.getContent()), MessageContentDO.class);
        if (null == messageContentDO) {
            log.info("sendWecomMessage | content is empty, message:{}", (Object)JsonUtils.objectToString((Object)message));
            return;
        }
        if ("ASA".equalsIgnoreCase(message.getSource()) && "text".equalsIgnoreCase(message.getType()) || "AGILE_DATA".equalsIgnoreCase(message.getSource())) {
            this.sendAsaWecomMessage(messageBatchUserDTO);
            return;
        }
        if (!"activity".equalsIgnoreCase(message.getType())) {
            log.info("sendWecomMessage | message type is not within the range, type:{}", (Object)message.getType());
            return;
        }
        JSONObject content = message.getContent();
        String targetTenantId = messageBatchUserDTO.getTenantId();
        StringBuilder msg = new StringBuilder(content.containsKey((Object)"title") ? content.getString("title") : "").append(content.containsKey((Object)"msg") ? content.getString("msg") : "");
        if (CategoryEnum.NEW.name().equals(message.getCategory()) || CategoryEnum.SIGN_NOTICE.name().equals(message.getCategory())) {
            String taskId = content.getString("id");
            StringBuilder mobileUrl = new StringBuilder(this.envProperties.getMobileProperties().getUri() + "/mobile/v1/sso/grantOauthAccess").append("?taskId=").append(taskId).append("&targetTenantId=").append(targetTenantId);
            mobileUrl.append("&proxyToken=").append("");
            String tenantIdDecrypt = targetTenantId;
            try {
                tenantIdDecrypt = AESUtils.encrypt((String)"550F743242C486791EDBDEDEE3498BAA", (String)targetTenantId);
            }
            catch (Exception e) {
                log.info("sendWecomMessage AESUtils encrypted tenantId error, tenantId:{}", (Object)targetTenantId, (Object)e);
            }
            mobileUrl.append("&tenantId=").append(tenantIdDecrypt);
            List userIdList = messageBatchUserDTO.getUserIdList();
            List userList = userIdList.stream().map(x -> {
                IamUserTokenDTO dto = new IamUserTokenDTO();
                dto.setUserId(x);
                dto.setTenantId(targetTenantId);
                dto.setAppId("athena");
                return dto;
            }).collect(Collectors.toList());
            List tokenDTOList = this.iamService.queryUserTempToken(userList);
            Map<String, String> userTokenMap = tokenDTOList.stream().collect(Collectors.toMap(IamUserTokenDTO::getUserId, IamUserTokenDTO::getTempToken, (a, b) -> a));
            Iterator iterator = userIdList.iterator();
            while (iterator.hasNext()) {
                JSONArray data;
                String userId;
                String userIdDecrypt = userId = (String)iterator.next();
                try {
                    userIdDecrypt = AESUtils.encrypt((String)"550F743242C486791EDBDEDEE3498BAA", (String)userId);
                }
                catch (Exception e) {
                    log.info("sendWecomMessage AESUtils encrypted userId error, tenantId:{}", (Object)targetTenantId, (Object)e);
                }
                String userToken = StringUtils.isNotBlank((String)userTokenMap.get(userId)) ? userTokenMap.get(userId) : "";
                mobileUrl.append("&userId=").append(userIdDecrypt).append("&iamUserToken=").append(userToken).append("&sourceType=Wechat&isHideAppBar=false");
                ResponseEntity respEntity = this.getWecomConfig();
                if (200 == respEntity.getStatusCodeValue() && respEntity.getBody() != null && (data = ((JSONObject)respEntity.getBody()).getJSONArray("data")) != null && data.size() > 0) {
                    JSONObject jsonObject = data.getJSONObject(0);
                    String agentid = jsonObject.getString("appId");
                    String corpId = jsonObject.getString("corpId");
                    String redirect_uri = this.envProperties.getPcAddressUri() + "/semc/router/routingDistribution?taskId=" + taskId + "&appId=" + agentid + "&tenantId=" + targetTenantId;
                    String encode = URLEncoder.encode(redirect_uri, "utf-8");
                    String weChatUrl = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + corpId + "&redirect_uri=" + encode + "&response_type=code&scope=snsapi_base&state=STATE&agentid=" + agentid + "#wechat_redirect";
                    String text = String.format(MESSAGE_LINK_URL, weChatUrl, msg);
                    this.emcService.sendWeChat(Collections.singletonList(userId), text, null);
                    log.info("message send success");
                }
                log.error("Message sending failed");
            }
        }
    }

    private void sendAsaWecomMessage(MessageBatchUserDTO messageBatchUserDTO) throws UnsupportedEncodingException {
        JSONArray data;
        MessageDO message = messageBatchUserDTO.getMessage();
        ResponseEntity respEntity = this.getWecomConfig();
        if (200 == respEntity.getStatusCodeValue() && respEntity.getBody() != null && (data = ((JSONObject)respEntity.getBody()).getJSONArray("data")) != null && data.size() > 0) {
            for (int i = 0; i < data.size(); ++i) {
                JSONObject jsonObject = data.getJSONObject(i);
                if (!jsonObject.getString("suiteId").equals(this.envProperties.getNanaSuiteId())) continue;
                String agentid = jsonObject.getString("appId");
                String corpId = jsonObject.getString("corpId");
                String redirect_uri = String.format("%s/ania/router/routingDistribution", this.envProperties.getAniaAddressUri());
                StringBuilder urlPath = new StringBuilder().append(redirect_uri).append("?");
                List urlParams = message.getAction().getUrlParams();
                for (int j = 0; j < urlParams.size(); ++j) {
                    urlPath.append(((MessageDO.TargetAction.Param)urlParams.get(j)).getKey()).append("=").append(((MessageDO.TargetAction.Param)urlParams.get(j)).getValue()).append("&");
                }
                urlPath.append("appId=").append(agentid);
                String encode = URLEncoder.encode(urlPath.toString(), "utf-8").replace("+", "%20");
                String weChatUrl = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + corpId + "&redirect_uri=" + encode + "&response_type=code&scope=snsapi_base&state=STATE&agentid=" + agentid + "#wechat_redirect";
                JSONObject msgJson = new JSONObject();
                JSONObject dataJsonObject = new JSONObject();
                dataJsonObject.put((Object)"appId", (Object)agentid);
                dataJsonObject.put((Object)"userList", (Object)messageBatchUserDTO.getUserIdList());
                dataJsonObject.put((Object)"thirdUserList", (Object)new String[0]);
                dataJsonObject.put((Object)"messageData", (Object)this.buildMessageData(messageBatchUserDTO, weChatUrl));
                msgJson.put((Object)"message", (Object)new com.alibaba.fastjson.JSONObject().fluentPut("data", (Object)dataJsonObject));
                msgJson.put((Object)"types", (Object)Lists.newArrayList((Object[])new String[]{"weCom"}));
                msgJson.put((Object)"eventId", (Object)this.envProperties.getWecomNoticeEventId());
                this.emcService.sendCommonChannelMsg(messageBatchUserDTO.getMessage().getLocale(), msgJson);
                log.info("message send success");
            }
        }
    }

    private ResponseEntity<JSONObject> getWecomConfig() {
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
        ResponseEntity respEntity = this.restTemplate.exchange(this.envProperties.getEmcUri() + "/api/emc/v1/appconfig/outsource/current", HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
        return respEntity;
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        String redirect_uri = "https://semc-test.apps.digiwincloud.com.cn/semc/router/enterpriseWeChatLogin?tenantId=AthenaWF&appId=1000034";
        String encode = URLEncoder.encode(redirect_uri, "utf-8");
        String weChatUrl = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=&redirect_uri=" + encode + "&response_type=code&scope=snsapi_base&state=STATE&agentid=#wechat_redirect";
        System.out.println(weChatUrl);
    }

    private JSONObject buildTaskButtonsMsg(String title, String description, String url, String btntxt) {
        JSONObject taskMsg = new JSONObject();
        taskMsg.put((Object)"title", (Object)title);
        taskMsg.put((Object)"description", (Object)description);
        taskMsg.put((Object)"url", (Object)url);
        taskMsg.put((Object)"btntxt", (Object)btntxt);
        return taskMsg;
    }

    private String parseDateOfPattern(Date date, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.format(date);
    }

    private JSONObject buildMessageData(MessageBatchUserDTO messageBatchUserDTO, String weChatUrl) {
        MessageDO message = messageBatchUserDTO.getMessage();
        JSONObject content = message.getContent();
        String msg = content.getString("msg");
        String date = this.parseDateOfPattern(new Date(), END_TIME_FORM);
        String locale = StringUtils.isNotBlank((String)message.getLocale()) && message.getLocale().equals("zh_CN") ? "zh_CN" : "zh_TW";
        String title = this.messageUtils.getMessageByLangName("meesage.wecom.title", locale);
        String description = "AGILE_DATA".equalsIgnoreCase(message.getSource()) ? "\u3010" + content.getString("title") + "\u3011\n" + msg : (StringUtils.isNotBlank((String)content.getString("msg")) ? msg : this.messageUtils.getMessageByLangName("meesage.wecom.description", locale));
        String btntxt = this.messageUtils.getMessageByLangName("message.line.button", locale);
        description = String.format(ASA_MESSAGE_LINK_URL, date, description);
        return this.buildTaskButtonsMsg(title, description, weChatUrl, btntxt);
    }
}

