/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.domain.message.subscriber;

import com.ctrip.framework.apollo.ConfigChangeListener;
import com.ctrip.framework.apollo.model.ConfigChange;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.digiwin.athena.aim.common.TenantRouteTypeEnum;
import com.digiwin.athena.aim.domain.message.model.TenantRouteChangeMessageDO;
import com.digiwin.athena.aim.domain.message.service.MessageSendService;
import com.digiwin.athena.aim.domain.tenantroute.service.TenantRouteService;
import com.digiwin.athena.appcore.util.SpringUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApolloConfigChangeSubscriber
implements ConfigChangeListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApolloConfigChangeSubscriber.class);
    private final TenantRouteService tenantRouteService = (TenantRouteService)SpringUtil.getBean(TenantRouteService.class);
    private final MessageSendService messageSendService = (MessageSendService)SpringUtil.getBean(MessageSendService.class);
    private final String deployId;

    public ApolloConfigChangeSubscriber(String deployId) {
        this.deployId = deployId;
    }

    public void onChange(ConfigChangeEvent changeEvent) {
        Set changeKeys = changeEvent.changedKeys();
        HashSet changeTenant = new HashSet();
        for (String key : changeKeys) {
            ConfigChange change = changeEvent.getChange(key);
            String oldValue = change.getOldValue();
            String newValue = change.getNewValue();
            if (StringUtils.isBlank((String)oldValue) && StringUtils.isBlank((String)newValue)) continue;
            if (StringUtils.isBlank((String)oldValue) && StringUtils.isNotBlank((String)newValue)) {
                this.addAllTenants(changeTenant, newValue);
                continue;
            }
            if (StringUtils.isNotBlank((String)oldValue) && StringUtils.isBlank((String)newValue)) {
                this.addAllTenants(changeTenant, oldValue);
                continue;
            }
            String[] oldTenants = StringUtils.split((String)oldValue, (String)",");
            String[] newTenants = StringUtils.split((String)newValue, (String)",");
            changeTenant.addAll(this.diff(oldTenants, newTenants));
        }
        changeTenant.forEach(tenant -> {
            Pair type = this.tenantRouteService.getRouteType(tenant, this.deployId);
            TenantRouteChangeMessageDO messageDO = new TenantRouteChangeMessageDO(tenant, this.getRouteType(type));
            try {
                this.messageSendService.sendTenantRouteChange(tenant, this.deployId, messageDO);
            }
            catch (Exception e) {
                log.error("\u53d1\u9001\u6d88\u606f\u7ed9\u79df\u6237:{}\u3001app:{}\u5f02\u5e38", new Object[]{tenant, this.deployId, e});
            }
        });
    }

    private String getRouteType(Pair<TenantRouteTypeEnum, String> type) {
        if (TenantRouteTypeEnum.PRE.equals(type.getLeft())) {
            return TenantRouteTypeEnum.PRE.name() + "-" + (String)type.getValue();
        }
        return ((TenantRouteTypeEnum)type.getLeft()).name();
    }

    private void addAllTenants(Set<String> changeTenant, String tenantConcats) {
        String[] tenants;
        for (String tenant : tenants = StringUtils.split((String)tenantConcats, (String)",")) {
            changeTenant.add(tenant);
        }
    }

    private Set<String> diff(String[] first, String[] second) {
        HashMap<String, Integer> firstMap = new HashMap<String, Integer>();
        for (String firstVal : first) {
            firstMap.put(firstVal, 1);
        }
        HashSet<String> different = new HashSet<String>();
        HashSet<String> secondSet = new HashSet<String>();
        for (String secondVal2 : second) {
            secondSet.add(secondVal2);
        }
        secondSet.forEach(secondVal -> {
            if (firstMap.containsKey(secondVal)) {
                firstMap.remove(secondVal);
            } else {
                different.add((String)secondVal);
            }
        });
        firstMap.forEach((k, v) -> different.add((String)k));
        return different;
    }
}

