/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.domain.message.subscriber;

import com.digiwin.athena.aim.domain.message.event.DingDingMessageEvent;
import com.digiwin.athena.aim.domain.message.model.MessageBatchUserDTO;
import com.digiwin.athena.aim.domain.message.service.DingDingMessageService;
import com.google.common.eventbus.Subscribe;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
public class DingDingMessageSubscriber {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DingDingMessageSubscriber.class);
    @Resource
    private DingDingMessageService dingDingMessageService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    public void handle(DingDingMessageEvent event) {
        if (MapUtils.isNotEmpty((Map)event.getMdcContext())) {
            MDC.setContextMap((Map)event.getMdcContext());
        }
        log.info("senDingDingMessage \u3010\u9489\u9489\u53d1\u9001\u6d88\u606fevent\u3011\uff1a{}", (Object)(CollectionUtils.isNotEmpty((Collection)event.getMessageBatchUserList()) ? event.getMessageBatchUserList().size() : 0));
        long start = System.currentTimeMillis();
        try {
            for (MessageBatchUserDTO message : event.getMessageBatchUserList()) {
                this.dingDingMessageService.senDingDingMessage(message);
            }
        }
        catch (Exception ex) {
            log.error("[senDingDingMessage] error: {}", (Throwable)ex);
        }
        finally {
            log.info("senDingDingMessage\u7ed3\u675f\u65f6\u95f4\uff1a{}", (Object)(System.currentTimeMillis() - start));
            try {
                if (MapUtils.isNotEmpty((Map)event.getMdcContext())) {
                    MDC.clear();
                }
            }
            catch (Exception e) {
                log.error("logMdcRemoveEx", (Throwable)e);
            }
        }
    }
}

