/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.domain.message.subscriber;

import com.digiwin.athena.aim.app.env.EnvProperties;
import com.digiwin.athena.aim.domain.message.event.NoticeMobileAppEvent;
import com.digiwin.athena.aim.domain.message.model.MessageDO;
import com.digiwin.athena.aim.infrastructure.mobile.AppSendMsgService;
import com.digiwin.athena.aim.infrastructure.mobile.MobileProperties;
import com.google.common.eventbus.Subscribe;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import lombok.Generated;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
public class NoticeMobileAppSubscriber {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NoticeMobileAppSubscriber.class);
    @Resource
    private AppSendMsgService appSendMsgService;
    @Resource
    private EnvProperties envProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    public void handle(NoticeMobileAppEvent event) {
        if (MapUtils.isNotEmpty((Map)event.getMdcContext())) {
            MDC.setContextMap((Map)event.getMdcContext());
        }
        log.info("\u3010\u79fb\u52a8\u7aef\u6d88\u606f\u63d0\u9192event\u3011\uff1a{}", (Object)event.getMessageList());
        log.info("\u3010\u79fb\u52a8\u7aef\u6d88\u606f\u63d0\u9192needNoticeMobileApp\u3011\uff1a{}", (Object)(!this.needNoticeMobileApp() ? 1 : 0));
        long start = System.currentTimeMillis();
        if (CollectionUtils.isEmpty((Collection)event.getMessageList()) || !this.needNoticeMobileApp()) {
            return;
        }
        try {
            for (MessageDO message : event.getMessageList()) {
                JSONObject mobileAppMsg = message.convertMobileAppMsg();
                this.appSendMsgService.sendAppMsg(mobileAppMsg);
            }
        }
        catch (Exception ex) {
            log.error("[NoticeMobileAppSubscriber] error: {}", (Object)ex.getMessage(), (Object)ex);
        }
        finally {
            log.info("\u79fb\u52a8\u7aef\u6d88\u606f\u63d0\u9192event\u7ed3\u675f\u65f6\u95f4\uff1a{}", (Object)(System.currentTimeMillis() - start));
            try {
                if (MapUtils.isNotEmpty((Map)event.getMdcContext())) {
                    MDC.clear();
                }
            }
            catch (Exception e) {
                log.error("logMdcRemoveEx", (Throwable)e);
            }
        }
    }

    private boolean needNoticeMobileApp() {
        Optional<String> sendMsgUri = Optional.ofNullable(this.envProperties.getMobileProperties()).map(MobileProperties::getMessage).map(MobileProperties.MessageProperties::getUri);
        log.info("\u3010\u79fb\u52a8\u7aef\u6d88\u606f\u63d0\u9192sendMsgUri\u3011\uff1a{}", sendMsgUri);
        return sendMsgUri.isPresent() && StringUtils.isNotBlank((String)sendMsgUri.get());
    }
}

