/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.domain.tenantroute.service.impl;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigService;
import com.digiwin.athena.aim.api.dto.GrayTenantDTO;
import com.digiwin.athena.aim.app.config.TenantRouteNamepspaceConfig;
import com.digiwin.athena.aim.common.TenantRouteTypeEnum;
import com.digiwin.athena.aim.domain.tenantroute.service.TenantRouteService;
import com.digiwin.athena.appcore.exception.BusinessException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TenantRouteServiceImpl
implements TenantRouteService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantRouteServiceImpl.class);
    @Autowired
    private TenantRouteNamepspaceConfig tenantRouteNamepspaceConfig;

    public Pair<TenantRouteTypeEnum, String> getRouteType(String tenantId, String depolyId) {
        String arKey;
        log.info("\u79df\u6237{}\u83b7\u53d6\u5e94\u7528{}\u662f\u5426\u662f\u9884\u533a\u8def\u7531", (Object)tenantId, (Object)depolyId);
        String mmcId = this.tenantRouteNamepspaceConfig.getMmcIdByDeployId(depolyId);
        if (mmcId == null) {
            throw BusinessException.create((String)"\u90e8\u7f72id\u4f20\u5165\u6709\u8bef");
        }
        String arNamespace = mmcId + "_ar";
        Config arConfig = ConfigService.getConfig((String)arNamespace);
        String arValue = arConfig.getProperty(arKey = this.tenantRouteNamepspaceConfig.getArKeyByDeployId(depolyId), null);
        if (StringUtils.isBlank((CharSequence)arValue)) {
            log.warn("namespace:{}\u914d\u7f6evalue\u4e3a\u7a7a", (Object)arNamespace);
            return Pair.of((Object)TenantRouteTypeEnum.PROD, (Object)arValue);
        }
        String trNamespace = mmcId + "_" + arKey + "_tr";
        Config trConfig = ConfigService.getConfig((String)trNamespace);
        Set trKeys = trConfig.getPropertyNames();
        if (CollectionUtils.isEmpty((Collection)trKeys)) {
            log.warn("namespace:{}\u914d\u7f6e\u4e3a\u7a7a", (Object)trNamespace);
            return Pair.of((Object)TenantRouteTypeEnum.PROD, (Object)arValue);
        }
        List preTrKeys = trKeys.stream().filter(one -> !arValue.equals(one)).collect(Collectors.toList());
        String tenantWithSplitor = "," + tenantId + ",";
        for (String preTrKey : preTrKeys) {
            String trValue = trConfig.getProperty(preTrKey, null);
            if (StringUtils.isBlank((CharSequence)trValue) || !("," + trValue + ",").contains(tenantWithSplitor)) continue;
            log.warn("\u79df\u6237\u914d\u7f6e\u5728\u9884\u533a\u8def\u7531");
            return Pair.of((Object)TenantRouteTypeEnum.PRE, (Object)preTrKey);
        }
        log.warn("\u79df\u6237\u6ca1\u6709\u914d\u7f6e\u5728\u9884\u533a\u8def\u7531");
        return Pair.of((Object)TenantRouteTypeEnum.PROD, (Object)arValue);
    }

    public List<String> queryPreEnvTenantIdList(String deployId) {
        String mmcId = this.tenantRouteNamepspaceConfig.getMmcIdByDeployId(deployId);
        if (mmcId == null) {
            throw BusinessException.create((String)"\u90e8\u7f72id\u4f20\u5165\u6709\u8bef");
        }
        log.info("mmcId:{}", (Object)mmcId);
        ArrayList<String> preEnvTenantIdList = new ArrayList<String>();
        String arNamespace = mmcId + "_ar";
        Config arConfig = ConfigService.getConfig((String)arNamespace);
        String arKey = this.tenantRouteNamepspaceConfig.getArKeyByDeployId(deployId);
        log.info("arKey:{}", (Object)arKey);
        String arValue = arConfig.getProperty(arKey, null);
        if (StringUtils.isBlank((CharSequence)arValue)) {
            log.warn("namespace:{}\u914d\u7f6evalue\u4e3a\u7a7a", (Object)arNamespace);
            return preEnvTenantIdList;
        }
        String trNamespace = mmcId + "_" + arKey + "_tr";
        Config trConfig = ConfigService.getConfig((String)trNamespace);
        Set trKeys = trConfig.getPropertyNames();
        log.info("trKeys:{}", (Object)trKeys);
        if (CollectionUtils.isEmpty((Collection)trKeys)) {
            log.warn("namespace:{}\u914d\u7f6e\u4e3a\u7a7a", (Object)trNamespace);
            return preEnvTenantIdList;
        }
        List preTrKeys = trKeys.stream().filter(one -> !arValue.equals(one)).collect(Collectors.toList());
        for (String preTrKey : preTrKeys) {
            String trValue = trConfig.getProperty(preTrKey, null);
            if (StringUtils.isBlank((CharSequence)trValue)) continue;
            preEnvTenantIdList.add(trValue);
        }
        return preEnvTenantIdList;
    }

    public GrayTenantDTO queryResolveEnvTenantIdList(String app, String mode) {
        String mmcId = this.tenantRouteNamepspaceConfig.getMmcIdByDeployId(app);
        if (mmcId == null) {
            throw BusinessException.create((String)("\u90e8\u7f72id:" + app + "\u4f20\u5165\u6709\u8bef"));
        }
        String arKey = this.tenantRouteNamepspaceConfig.getArKeyByDeployId(app);
        log.info("queryResolveEnvTenantIdList app:{},mode:{},mmcId:{},arKey:{}", new Object[]{app, mode, mmcId, arKey});
        String arNamespace = mmcId + "_ar";
        Config arConfig = ConfigService.getConfig((String)arNamespace);
        String arValue = arConfig.getProperty(arKey, null);
        GrayTenantDTO grayTenantDTO = new GrayTenantDTO();
        grayTenantDTO.setMaster(Boolean.valueOf(false));
        ArrayList<String> preEnvTenantIdList = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)arValue)) {
            log.warn("queryResolveEnvTenantIdList namespace:{} \u914d\u7f6evalue\u4e3a\u7a7a", (Object)arNamespace);
            grayTenantDTO.setTenantIdList(preEnvTenantIdList);
            return grayTenantDTO;
        }
        log.info("queryResolveEnvTenantIdList arValue:{},mode:{}", (Object)arValue, (Object)mode);
        if (arValue.equals(mode)) {
            grayTenantDTO.setMaster(Boolean.valueOf(true));
        }
        String trNamespace = mmcId + "_" + arKey + "_tr";
        Config trConfig = ConfigService.getConfig((String)trNamespace);
        Set trKeys = trConfig.getPropertyNames();
        log.info("queryResolveEnvTenantIdList trKeys:{}", (Object)trKeys);
        if (CollectionUtils.isEmpty((Collection)trKeys)) {
            log.warn("queryResolveEnvTenantIdList namespace:{}\u914d\u7f6e\u4e3a\u7a7a", (Object)trNamespace);
            grayTenantDTO.setTenantIdList(preEnvTenantIdList);
            return grayTenantDTO;
        }
        List<Object> preTrKeys = arValue.equals(mode) ? new ArrayList(trKeys) : Arrays.asList(mode);
        for (String preTrKey : preTrKeys) {
            String trValue = trConfig.getProperty(preTrKey, null);
            if (StringUtils.isBlank((CharSequence)trValue)) continue;
            preEnvTenantIdList.add(trValue);
        }
        grayTenantDTO.setTenantIdList(preEnvTenantIdList);
        return grayTenantDTO;
    }
}

