/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.infrastructure.concurrent.pool;

import com.digiwin.athena.aim.infrastructure.concurrent.pool.AbstractDynamicThreadPool;
import com.digiwin.athena.aim.infrastructure.concurrent.pool.DynamicThreadPoolBean;
import com.digiwin.athena.aim.infrastructure.concurrent.pool.DynamicThreadPoolConfig;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.jugg.agile.framework.core.config.JaProperty;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DynamicThreadPool
extends AbstractDynamicThreadPool {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DynamicThreadPool.class);
    @Autowired
    private DynamicThreadPoolConfig dynamicThreadPoolConfig;
    private final String poolName = "dynamicThreadPool";

    protected DynamicThreadPoolBean buildThreadPool() {
        DynamicThreadPoolBean dynamicThreadPool = new DynamicThreadPoolBean("dynamicThreadPool", this.dynamicThreadPoolConfig.getCoreSize().intValue(), this.dynamicThreadPoolConfig.getMaxSize().intValue(), this.dynamicThreadPoolConfig.getKeepAliveTime().longValue(), TimeUnit.SECONDS, new LinkedBlockingQueue(this.dynamicThreadPoolConfig.getQueueSize()), new ThreadFactoryBuilder().setNameFormat("dynamicThreadPool_%d").build(), (RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy(), this.dynamicThreadPoolConfig.getQueueSize());
        return dynamicThreadPool;
    }

    public AbstractDynamicThreadPool.DynamicParam transferParameter() {
        Integer coreSize = JaProperty.getInteger((String)"dynamic.threadPool.coreSize", (Integer)this.dynamicThreadPoolConfig.getCoreSize());
        Integer maxSize = JaProperty.getInteger((String)"dynamic.threadPool.maxSize", (Integer)this.dynamicThreadPoolConfig.getMaxSize());
        AbstractDynamicThreadPool.DynamicParam dynamicParam = new AbstractDynamicThreadPool.DynamicParam(coreSize, maxSize);
        return dynamicParam;
    }
}

