/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.infrastructure.concurrent.pool;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicThreadPoolBean
extends ThreadPoolExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DynamicThreadPoolBean.class);
    private String poolName = "DynamicThreadPoolDefault";
    private int queueCapacity;
    private static final int DEFAULT_QUEUESIZE = 1000;
    private static final Float THRESHOLD_FACTOR = Float.valueOf(0.8f);
    private static final Long INTERVAL = 300000L;
    private Long maxPoolSizeWarningTime;
    private Long queueCapacityWarningTime;
    private final ReentrantLock lock = new ReentrantLock();

    private DynamicThreadPoolBean(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    public DynamicThreadPoolBean(String poolName, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        this.poolName = poolName;
        this.setQueueCapacity(1000);
    }

    public DynamicThreadPoolBean(String poolName, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler, Integer queueSize) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        this.poolName = poolName;
        this.setQueueCapacity(queueSize.intValue());
    }

    public String getPoolName() {
        return this.poolName;
    }

    public int getQueueCapacity() {
        return this.queueCapacity;
    }

    public void setQueueCapacity(int queueCapacity) {
        this.queueCapacity = queueCapacity;
    }

    protected void changeThreadPoolConfig(Integer coreSize, Integer maxSize) {
        this.setCorePoolSize(coreSize.intValue());
        this.setMaximumPoolSize(maxSize.intValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void beforeExecute(Thread t, Runnable r) {
        this.lock.lock();
        try {
            String printLog = this.printThreadPoolStatus();
            log.info("beforeExecute " + printLog);
            this.logWarningNotice();
            super.beforeExecute(t, r);
        }
        catch (Exception e) {
            log.error("SpiderThreadPool beforeExecute error!", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        this.logWarningNotice();
    }

    protected void terminated() {
        super.terminated();
    }

    public int getQueueTaskSize() {
        return this.getQueue().size();
    }

    public void logWarningNotice() {
        boolean queueCapacityWarningTimeFlag;
        int maximumPoolSize = this.getMaximumPoolSize();
        int currentPoolSize = this.getPoolSize();
        boolean maxPoolSizeWarningTimeFlag = this.maxPoolSizeWarningTime == null || System.currentTimeMillis() - this.maxPoolSizeWarningTime > INTERVAL;
        boolean bl = queueCapacityWarningTimeFlag = this.queueCapacityWarningTime == null || System.currentTimeMillis() - this.queueCapacityWarningTime > INTERVAL;
        if ((float)currentPoolSize / (float)maximumPoolSize > THRESHOLD_FACTOR.floatValue() && maxPoolSizeWarningTimeFlag) {
            this.maxPoolSizeWarningTime = System.currentTimeMillis();
            log.warn(this.poolName + "->\u7ebf\u7a0b\u6c60\u6700\u5927\u7ebf\u7a0b\u6570\u5df2\u8d85\u8fc7\u9608\u503c\uff0c\u5f53\u524d\u6700\u5927\u7ebf\u7a0b\u6570\uff1a" + maximumPoolSize + "\uff0c\u5f53\u524d\u6d3b\u8dc3\u7ebf\u7a0b\u6570\uff1a" + currentPoolSize + "\uff0c\u5f53\u524d\u7ebf\u7a0b\u8d1f\u8f7d\uff1a" + (float)currentPoolSize / (float)maximumPoolSize + "\uff0c\u8bf7\u53ca\u65f6\u8c03\u6574\u7ebf\u7a0b\u6c60\u914d\u7f6e");
        }
        if ((float)this.getQueueTaskSize() / (float)this.queueCapacity > THRESHOLD_FACTOR.floatValue() && queueCapacityWarningTimeFlag) {
            this.queueCapacityWarningTime = System.currentTimeMillis();
            log.warn(this.poolName + "->\u7ebf\u7a0b\u6c60\u961f\u5217\u5df2\u8d85\u8fc7\u9608\u503c\uff0c\u5f53\u524d\u961f\u5217\u5bb9\u91cf\uff1a" + this.queueCapacity + "\uff0c\u5f53\u524d\u961f\u5217\u4efb\u52a1\u6570\uff1a" + this.getQueueTaskSize() + "\uff0c\u5f53\u524d\u961f\u5217\u8d1f\u8f7d\uff1a" + (float)this.getQueueTaskSize() / (float)this.queueCapacity + "\uff0c\u8bf7\u53ca\u65f6\u8c03\u6574\u7ebf\u7a0b\u6c60\u914d\u7f6e");
        }
    }

    public String printThreadPoolStatus() {
        return String.format(this.poolName + "->core_size:%s;max_size:%s;active_size:%s;pool_size:%s;queue_size:%s;task_count:%s;completed_count:%s;largest_pool_count:%s", this.getCorePoolSize(), this.getMaximumPoolSize(), this.getActiveCount(), this.getPoolSize(), this.getQueue().size(), this.getTaskCount(), this.getCompletedTaskCount(), this.getLargestPoolSize());
    }
}

