/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.infrastructure.dingding.impl;

import com.digiwin.athena.aim.infrastructure.dingding.DingdingService;
import com.digiwin.athena.aim.infrastructure.dingding.dto.DingdingInviteSettingDto;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import java.time.LocalDateTime;
import javax.annotation.Resource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class DingdingServiceImpl
implements DingdingService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DingdingServiceImpl.class);
    @Resource
    protected MongoTemplate mongoTemplate;

    public void recordInviteSetting(Boolean isNeverRemind, AuthoredUser user) {
        DingdingInviteSettingDto dto = this.buildDto(isNeverRemind, user);
        if (Boolean.TRUE.equals(isNeverRemind)) {
            this.mongoTemplate.insert((Object)dto, "remind-setting-collection");
        } else {
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"userId").is((Object)user.getUserId()).and("tenantSid").is((Object)user.getTenantSid()));
            this.mongoTemplate.remove(query, "remind-setting-collection");
        }
    }

    public ResponseEntity<?> getRemindSetting(AuthoredUser user) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"userId").is((Object)user.getUserId()).and("tenantSid").is((Object)user.getTenantSid()));
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        DingdingInviteSettingDto dto = (DingdingInviteSettingDto)this.mongoTemplate.findOne(query, DingdingInviteSettingDto.class, "remind-setting-collection");
        if (dto == null || !Boolean.TRUE.equals(dto.getIsNeverRemind())) {
            return ResponseEntityWrapper.wrapperOk((Object)false);
        }
        return ResponseEntityWrapper.wrapperOk((Object)true);
    }

    private DingdingInviteSettingDto buildDto(Boolean isNeverRemind, AuthoredUser user) {
        DingdingInviteSettingDto dto = new DingdingInviteSettingDto();
        dto.setIsNeverRemind(isNeverRemind);
        dto.setUserId(user.getUserId());
        dto.setTenantSid(user.getTenantSid());
        dto.setCreateTime(LocalDateTime.now());
        return dto;
    }
}

