/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.infrastructure.emc.impl;

import com.digiwin.athena.aim.app.env.EnvProperties;
import com.digiwin.athena.aim.domain.message.model.MessageCenterConfigDTO;
import com.digiwin.athena.aim.domain.message.model.MessageCenterTenantChannelConfig;
import com.digiwin.athena.aim.infrastructure.emc.EmcService;
import com.digiwin.athena.aim.infrastructure.thememap.dto.IamDdMessageDTO;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.iam.sdk.meta.dto.IamResultDTO;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class EmcServiceImpl
implements EmcService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmcServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;

    public int senDdMessage(IamDdMessageDTO iamDdMessageDTO) {
        String url = this.envProperties.getEmcUri() + "/api/emc/v1/message/email";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("Digi-Middleware-Auth-App", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c");
        headers.add("digi-middleware-auth-user", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        headers.add("token", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        String local = iamDdMessageDTO.getLocale();
        headers.add("Accept-Language", StringUtils.isEmpty((String)local) ? "zh_CN" : local);
        JSONObject reqObject = JSONObject.fromObject((Object)this);
        reqObject.put((Object)"eventId", (Object)(this.envProperties.getNoticeEventId() + "_" + iamDdMessageDTO.getAppId()));
        JSONObject messageObject = JSONObject.fromObject((Object)this);
        messageObject.put((Object)"data", (Object)iamDdMessageDTO);
        reqObject.put((Object)"message", (Object)messageObject);
        reqObject.put((Object)"types", (Object)new String[]{"dingTalk"});
        HttpEntity httpEntity = new HttpEntity((Object)reqObject, (MultiValueMap)headers);
        try {
            log.info("\u8bf7\u6c42EMC\u53d1\u9001\u9489\u9489\u6d88\u606f \u5165\u53c2:{}", (Object)JsonUtils.objectToString((Object)httpEntity));
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            log.info("\u8bf7\u6c42EMC\u53d1\u9001\u9489\u9489\u6d88\u606fend\uff0c\u5165\u53c2\uff1a{}, \u54cd\u5e94\u5185\u5bb9\uff1a{}", (Object)JsonUtils.objectToString((Object)iamDdMessageDTO), (Object)JsonUtils.objectToString((Object)respEntity.getBody()));
        }
        catch (BusinessException ex) {
            log.error("\u8bf7\u6c42EMC\u53d1\u9001\u9489\u9489\u6d88\u606f\u62a5\u9519\uff0c\u5165\u53c2\uff1a{}, ex\uff1a{}", (Object)JsonUtils.objectToString((Object)iamDdMessageDTO), (Object)ex);
        }
        return 0;
    }

    public void sendWeChat(List<String> userIdList, String msg, String appId) {
        String url = this.envProperties.getEmcUri() + "/api/emc/v1/message/sendWechat";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c");
        headers.add("digi-middleware-auth-user", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        JSONObject reqObject = JSONObject.fromObject((Object)this);
        reqObject.put((Object)"msgType", (Object)"text");
        if (StringUtils.isNotBlank((String)appId)) {
            reqObject.put((Object)"appId", (Object)appId);
        }
        reqObject.put((Object)"content", (Object)msg);
        reqObject.put((Object)"userIds", userIdList);
        HttpEntity httpEntity = new HttpEntity((Object)reqObject, (MultiValueMap)headers);
        try {
            log.info("invoke emc sendWeChat, url:{}, param:{}", (Object)url, (Object)JsonUtils.objectToString((Object)httpEntity));
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            log.info("invoke emc sendWeChat success, url:{}, response\uff1a{}", (Object)url, (Object)JsonUtils.objectToString((Object)respEntity.getBody()));
        }
        catch (Exception ex) {
            log.error("invoke emc sendWeChat error, url:{}, param:{}", new Object[]{url, JsonUtils.objectToString((Object)httpEntity), ex});
        }
    }

    public void sendCommonChannelMsg(String language, JSONObject msgJson) {
        String url = this.envProperties.getEmcUri() + "/api/emc/v1/message/integrated";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c");
        headers.add("digi-middleware-auth-user", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        headers.add("Accept-Language", language);
        HttpEntity httpEntity = new HttpEntity((Object)msgJson, (MultiValueMap)headers);
        try {
            log.info("start invoke emc send common channel msg. param:{}", (Object)httpEntity);
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, HashMap.class, new Object[0]);
            if (respEntity.getBody() == null || !this.requestSuccess(((HashMap)respEntity.getBody()).get("code"), ((HashMap)respEntity.getBody()).get("success"))) {
                log.error("invoke emc send common channel msg fail. url:{}, result:{}", (Object)url, (Object)respEntity);
                throw BusinessException.create((String)("invoke emc send common channel msg fail. param:" + httpEntity + ", result:" + respEntity));
            }
            log.info("invoke emc send common channel msg success. param:{}, result:{}", (Object)httpEntity, (Object)respEntity);
        }
        catch (Exception ex) {
            log.error("invoke emc send common channel msg error, url:{}, request:{}, errorMessage:{}", new Object[]{url, httpEntity, ex.getMessage()});
            throw BusinessException.create((String)("invoke emc send common channel msg error:" + ex.getMessage() + ", param:" + httpEntity));
        }
    }

    private boolean requestSuccess(Object code, Object success) {
        if (null == code || null == success) {
            return false;
        }
        return StringUtils.equals((String)String.valueOf(code), (String)String.valueOf(200)) && Boolean.parseBoolean(String.valueOf(success));
    }

    public void sendEmail(String language, JSONObject content) {
        log.info("[SendEmail] EmcServiceImpl start: {}", (Object)content);
        String url = this.envProperties.getEmcUri() + "/api/emc/v1/message/email";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("Accept-Language", StringUtils.isEmpty((String)language) ? "zh_CN" : language);
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        HttpEntity httpEntity = new HttpEntity((Object)content, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, HashMap.class, new Object[0]);
            Object code = ((HashMap)respEntity.getBody()).get("code");
            Object success = ((HashMap)respEntity.getBody()).get("success");
            if (!this.requestSuccess(code, success)) {
                log.error("\u8c03\u7528emc\u53d1\u9001\u90ae\u4ef6\u5931\u8d25\uff0c{}", (Object)("status code: 200, code: " + code + ", message: " + JsonUtils.objectToString(((HashMap)respEntity.getBody()).get("message"))));
            }
        }
        catch (Exception ex) {
            log.error("\u8bf7\u6c42EMC\u53d1\u90ae\u4ef6\u62a5\u9519\uff0c\u5165\u53c2\uff1a{}, ex\uff1a{}", (Object)JsonUtils.objectToString((Object)content), (Object)ex);
        }
    }

    public List<MessageCenterConfigDTO> getMsgConfigList(String tenantId, String appCode, String sceneId) {
        String url = this.envProperties.getEmcUri() + "/api/emc/v2/config/list?athenaMessageId={athenaMessageId}&tenantId={tenantId}&source={source}";
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        headers.add("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c");
        headers.add("token", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantId", tenantId);
        param.put("source", appCode);
        param.put("athenaMessageId", sceneId);
        try {
            log.info("[getMsgConfigList]\u8bf7\u6c42EMC \u67e5\u8be2\u573a\u666f\u914d\u7f6e \u5165\u53c2:tenantId = {},source = {},athenaMessageId = {} ", new Object[]{tenantId, appCode, sceneId});
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, param);
            log.info("[getMsgConfigList]\u8bf7\u6c42EMC \u67e5\u8be2\u573a\u666f\u914d\u7f6e\uff0c \u54cd\u5e94\u5185\u5bb9\uff1a{}", (Object)JsonUtils.objectToString((Object)respEntity.getBody()));
            if (null != respEntity.getBody() && 200 == ((IamResultDTO)respEntity.getBody()).getCode()) {
                return (List)((IamResultDTO)respEntity.getBody()).data();
            }
        }
        catch (BusinessException ex) {
            log.error("\u8bf7\u6c42EMC\u67e5\u8be2\u573a\u666f\u914d\u7f6e\u5931\u8d25\uff0c\u5165\u53c2:tenantId = {},source = {},athenaMessageId = {}, ex\uff1a{}", new Object[]{tenantId, appCode, sceneId, ex});
        }
        return new ArrayList<MessageCenterConfigDTO>();
    }

    public List<MessageCenterTenantChannelConfig> getMsgTenantChannelConfigList() {
        String url = this.envProperties.getEmcUri() + "/api/emc/v2/channel/current/list";
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        headers.add("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c");
        headers.add("token", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        try {
            log.info("\u8bf7\u6c42EMC \u67e5\u8be2\u79df\u6237\u6e20\u9053\u914d\u7f6e \u5165\u53c2:tenantId = {}", (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            log.info("\u8bf7\u6c42EMC \u67e5\u8be2\u79df\u6237\u6e20\u9053\u914d\u7f6e , \u54cd\u5e94\u5185\u5bb9\uff1a{}", (Object)JsonUtils.objectToString((Object)respEntity.getBody()));
            if (null != respEntity.getBody() && 200 == ((IamResultDTO)respEntity.getBody()).getCode()) {
                return (List)((IamResultDTO)respEntity.getBody()).getData();
            }
        }
        catch (BusinessException ex) {
            log.error("\u8bf7\u6c42EMC \u67e5\u8be2\u79df\u6237\u6e20\u9053\u914d\u7f6e\u5931\u8d25\uff0c\u5165\u53c2:tenantId = {}, ex\uff1a{}", (Object)AppAuthContextHolder.getContext().getAuthoredUser().getTenantId(), (Object)ex);
        }
        return new ArrayList<MessageCenterTenantChannelConfig>();
    }

    public Map getAppConfig(JSONObject param) {
        HashMap map = Maps.newHashMap();
        String url = this.envProperties.getEmcUri() + "/api/emc/v1/appconfig/find";
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        headers.add("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c");
        headers.add("token", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        HttpEntity httpEntity = new HttpEntity((Object)param, (MultiValueMap)headers);
        try {
            log.info("\u8c03\u7528emc\u67e5\u8be2\u9489\u9489\u5185\u90e8\u5e94\u7528\u914d\u7f6e\u5f00\u59cb\uff0c\u5165\u53c2\u662f\uff1a{}", (Object)JsonUtils.objectToString((Object)httpEntity));
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, HashMap.class, new Object[0]);
            log.info("\u8c03\u7528emc\u67e5\u8be2\u9489\u9489\u5185\u90e8\u5e94\u7528\u914d\u7f6e\u7ed3\u675f\uff0c\u8fd4\u53c2\u662f\uff1a{}", (Object)JsonUtils.objectToString((Object)respEntity));
            Object code = ((HashMap)respEntity.getBody()).get("code");
            Object success = ((HashMap)respEntity.getBody()).get("success");
            if (!this.requestSuccess(code, success)) {
                log.error("\u8c03\u7528emc\u67e5\u8be2\u9489\u9489\u5185\u90e8\u5e94\u7528\u914d\u7f6e\u5931\u8d25\uff0c{}", (Object)("status code: 200, code: " + code + ", message: " + JsonUtils.objectToString(((HashMap)respEntity.getBody()).get("message"))));
            }
            if (Objects.nonNull(((HashMap)respEntity.getBody()).get("data"))) {
                Object data = ((HashMap)respEntity.getBody()).get("data");
                map.put("corpId", JSONObject.fromObject(data).getString("corpId"));
                map.put("agentId", JSONObject.fromObject(data).getString("appId"));
            }
        }
        catch (Exception ex) {
            log.error("\u8bf7\u6c42EMC\u67e5\u8be2\u9489\u9489\u5185\u90e8\u5e94\u7528\u914d\u7f6e\u5931\u8d25\uff0c\u5165\u53c2\uff1a{}, ex\uff1a{}", (Object)JsonUtils.objectToString((Object)httpEntity), (Object)ex);
        }
        return map;
    }

    public ResponseEntity<JSONObject> getWecomConfig() {
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
        ResponseEntity respEntity = this.restTemplate.exchange(this.envProperties.getEmcUri() + "/api/emc/v1/appconfig/outsource/current", HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
        return respEntity;
    }
}

