/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.infrastructure.iam.impl;

import com.digiwin.athena.aim.app.env.EnvProperties;
import com.digiwin.athena.aim.common.MeesqgeConstant;
import com.digiwin.athena.aim.infrastructure.iam.IamService;
import com.digiwin.athena.aim.infrastructure.iam.dto.IamUserDTO;
import com.digiwin.athena.aim.infrastructure.iam.dto.IamUserTokenDTO;
import com.digiwin.athena.aim.infrastructure.iam.dto.PersonalizedDto;
import com.digiwin.athena.aim.infrastructure.iam.dto.UserLangMetadataDTO;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class IamServiceImpl
implements IamService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IamServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    MessageUtils messageUtils;
    private static final String TENANT_METADATA_CORPID = "/api/iam/v2/tenant/metadata/corpid/from?comeFrom=dingding";
    public static final String CATALOG_ID_BASIC = "basic";
    public static final String MESSAGE_NOTICE_TYPE_KEY = "MessageSendType";
    public static final String DAP_ACCEPT_LANGUAGE = "dapAcceptLanguage";

    public List<IamUserDTO> getUserListByRole(String roleId) {
        String url = this.envProperties.getIamUri() + "/api/iam/v2/association/userinrole";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("roleId", roleId);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, params);
            if (null != responseEntity.getBody()) {
                return (List)responseEntity.getBody();
            }
            log.error("\u8bf7\u6c42AIM\u67e5\u8be2\u5f53\u524d\u79df\u6237\u4e0b\u6307\u5b9a\u89d2\u8272\u4e0b\u7684\u7528\u6237\u6e05\u5355\u7684\u4fe1\u606f\u62a5\u9519\uff0c\u53c2\u6570\uff1a{}", params);
            String errMsg = MessageFormat.format(this.messageUtils.getMessage("exception.aim.user.list"), JsonUtils.objectToString(params));
            throw BusinessException.create((String)errMsg);
        }
        catch (BusinessException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String errMsg = MessageFormat.format(this.messageUtils.getMessage("exception.aim.user.list"), JsonUtils.objectToString(params));
            throw BusinessException.create((String)errMsg, (Throwable)ex);
        }
    }

    public String getUserMetadataAllTenant(String userId, int type, int lineOrDingding) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        headers.add("digi-middleware-auth-user", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        log.info("getUserMetadataAllTenant-userId:{},type:{}", (Object)userId, (Object)type);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userId);
        params.put("tenantSid", 0);
        if (type == 1) {
            params.put("catalogId", CATALOG_ID_BASIC);
            params.put("key", DAP_ACCEPT_LANGUAGE);
        } else if (type == 2) {
            params.put("catalogId", "integrationUserId");
            if (Objects.equals(1, lineOrDingding)) {
                params.put("key", "line_Athena");
            } else {
                params.put("tenantSid", AppAuthContextHolder.getContext().getAuthoredUser().getTenantSid());
                params.put("key", "dingding");
            }
        }
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        String url = this.envProperties.getIamUri() + "/api/iam/v2/usermetadata/user/get";
        try {
            UserLangMetadataDTO baseResult;
            log.info(JsonUtils.objectToString((Object)httpEntity));
            ResponseEntity respEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, UserLangMetadataDTO.class, new Object[0]);
            if (HttpStatus.OK.value() == respEntity.getStatusCodeValue() && null != (baseResult = (UserLangMetadataDTO)respEntity.getBody()) && HttpStatus.OK.value() == baseResult.getCode().intValue()) {
                Object value = Optional.ofNullable(baseResult.getData()).map(data -> data.get("value")).orElse(null);
                if (type == 1) {
                    return Objects.nonNull(value) ? String.valueOf(value) : "zh_CN";
                }
                if (type == 2) {
                    return Objects.nonNull(value) ? String.valueOf(value) : null;
                }
            }
            throw BusinessException.create((Integer)respEntity.getStatusCodeValue(), (String)JsonUtils.objectToString((Object)respEntity.getBody()));
        }
        catch (Exception ex) {
            String errMsg = null;
            if (type == 1) {
                errMsg = MessageFormat.format(this.messageUtils.getMessage("exception.aim.user.lang"), JsonUtils.objectToString(params));
            } else if (type == 2) {
                errMsg = MessageFormat.format(this.messageUtils.getMessage("exception.aim.user.line"), JsonUtils.objectToString(params));
            }
            throw BusinessException.create(errMsg, (Throwable)ex);
        }
    }

    public List<IamUserTokenDTO> queryUserTempToken(List<IamUserTokenDTO> userIdList) {
        ResponseEntity respEntity;
        String url = this.envProperties.getIamUri() + "/api/iam/v2/user/tempToken/list";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        headers.add("digi-middleware-auth-user", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        HashMap<String, List<IamUserTokenDTO>> params = new HashMap<String, List<IamUserTokenDTO>>();
        params.put("userList", userIdList);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        try {
            respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, JSONObject.class, new Object[0]);
        }
        catch (Exception ex) {
            log.error("query user temp token error. url:{}, param:{}", new Object[]{url, JsonUtils.objectToString((Object)httpEntity), ex});
            return null;
        }
        if (HttpStatus.OK.value() == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
            JSONArray data = ((JSONObject)respEntity.getBody()).getJSONArray("data");
            return JSONArray.toList((JSONArray)data, (Object)new IamUserTokenDTO(), (JsonConfig)new JsonConfig());
        }
        log.error("query user temp token fail. url:{}, param:{}, result:{}", new Object[]{url, JsonUtils.objectToString((Object)httpEntity), respEntity});
        return null;
    }

    public List<IamUserDTO> queryUserInfoList(List<String> userIdList) {
        ResponseEntity respEntity;
        if (CollectionUtils.isEmpty(userIdList)) {
            return new ArrayList<IamUserDTO>();
        }
        userIdList = userIdList.stream().distinct().collect(Collectors.toList());
        String url = this.envProperties.getIamUri() + "/api/iam/v2/tenant/user/info";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        headers.add("digi-middleware-auth-user", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        params.put("userIds", userIdList);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        try {
            log.info("start query user Info list. param:{}", (Object)httpEntity);
            respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, JSONObject.class, new Object[0]);
        }
        catch (Exception ex) {
            log.error("query user Info list error. url:{}, param:{}", new Object[]{url, JsonUtils.objectToString((Object)httpEntity), ex});
            throw BusinessException.create((String)("query user Info list error:" + ex.getMessage() + ", param:" + JsonUtils.objectToString((Object)httpEntity)));
        }
        if (HttpStatus.OK.value() == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
            JSONArray data = ((JSONObject)respEntity.getBody()).getJSONArray("data");
            log.info("uery user Info list success. param:{}, result:{}", (Object)JsonUtils.objectToString((Object)httpEntity), (Object)data);
            return JSONArray.toList((JSONArray)data, (Object)new IamUserDTO(), (JsonConfig)new JsonConfig());
        }
        log.error("query user Info list fail. url:{}, param:{}, result:{}", new Object[]{url, JsonUtils.objectToString((Object)httpEntity), respEntity});
        throw BusinessException.create((String)("query user Info list fail. param:" + JsonUtils.objectToString((Object)httpEntity) + ", result:" + respEntity));
    }

    public String getTenantCorpid() {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        String userToken = AppAuthContextHolder.getContext().getAuthoredUser().getToken();
        headers.add("digi-middleware-auth-user", userToken);
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
        StringBuilder url = new StringBuilder(this.envProperties.getIamUri()).append(TENANT_METADATA_CORPID);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url.toString(), HttpMethod.GET, requestEntity, JSONObject.class, new Object[0]);
            if (200 == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
                String data = ((JSONObject)respEntity.getBody()).getString("data");
                return data;
            }
        }
        catch (Exception ex) {
            log.error("\u4eceIAM\u83b7\u53d6\u5f53\u524d\u767b\u5165\u79df\u6237\u7684corpId\u5f02\u5e38, token: {}, errorMsg:{}", (Object)userToken, (Object)ex.getMessage());
            return "";
        }
        return "";
    }

    public List<PersonalizedDto> queryUserMetadataList(List<String> userIdList) {
        ArrayList<PersonalizedDto> result = new ArrayList<PersonalizedDto>();
        if (CollectionUtils.isEmpty(userIdList)) {
            return result;
        }
        userIdList = userIdList.stream().distinct().collect(Collectors.toList());
        List userIdListList = Lists.partition(userIdList, (int)MeesqgeConstant.MAX_QUERY_SIZE);
        String url = this.envProperties.getIamUri() + "/api/iam/v2/usermetadata/user/get/batch";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        headers.add("digi-middleware-auth-user", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tenantSid", AppAuthContextHolder.getContext().getAuthoredUser().getTenantSid());
        params.put("catalogId", CATALOG_ID_BASIC);
        params.put("key", MESSAGE_NOTICE_TYPE_KEY);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        userIdListList.forEach(userIds -> {
            ResponseEntity respEntity;
            params.put("userIdList", userIds);
            try {
                log.info("start query user metadata list. param:{}", (Object)httpEntity);
                respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, JSONObject.class, new Object[0]);
            }
            catch (Exception ex) {
                log.error("query user metadata list error. url:{}, param:{}", new Object[]{url, JsonUtils.objectToString((Object)httpEntity), ex});
                throw BusinessException.create((String)("query user metadata list error:" + ex.getMessage() + ", param:" + JsonUtils.objectToString((Object)httpEntity)));
            }
            if (HttpStatus.OK.value() != respEntity.getStatusCodeValue() || respEntity.getBody() == null || !CollectionUtils.isNotEmpty((Collection)((JSONObject)respEntity.getBody()).getJSONArray("data"))) {
                log.error("query user metadata list fail. url:{}, param:{}, result:{}", new Object[]{url, JsonUtils.objectToString((Object)httpEntity), respEntity});
                throw BusinessException.create((String)("query user metadata list fail. param:" + JsonUtils.objectToString((Object)httpEntity) + ", result:" + respEntity));
            }
            JSONArray data = ((JSONObject)respEntity.getBody()).getJSONArray("data");
            log.info("query user metadata list success. param:{}, result:{}", (Object)JsonUtils.objectToString((Object)httpEntity), (Object)data);
            result.addAll(JSONArray.toList((JSONArray)data, (Object)new PersonalizedDto(), (JsonConfig)new JsonConfig()));
        });
        return result;
    }

    public List<PersonalizedDto> queryUserLangMetadataList(List<String> userIdList) {
        ArrayList<PersonalizedDto> result = new ArrayList<PersonalizedDto>();
        if (CollectionUtils.isEmpty(userIdList)) {
            return result;
        }
        userIdList = userIdList.stream().distinct().collect(Collectors.toList());
        List userIdListList = Lists.partition(userIdList, (int)MeesqgeConstant.MAX_QUERY_SIZE);
        String url = this.envProperties.getIamUri() + "/api/iam/v2/usermetadata/user/get/batch";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        headers.add("digi-middleware-auth-user", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tenantSid", 0);
        params.put("catalogId", CATALOG_ID_BASIC);
        params.put("key", DAP_ACCEPT_LANGUAGE);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        userIdListList.forEach(userIds -> {
            ResponseEntity respEntity;
            params.put("userIdList", userIds);
            try {
                log.info("start query user metadata list. param:{}", (Object)httpEntity);
                respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, JSONObject.class, new Object[0]);
            }
            catch (Exception ex) {
                log.error("query user metadata list error. url:{}, param:{}", new Object[]{url, JsonUtils.objectToString((Object)httpEntity), ex});
                throw BusinessException.create((String)("query user metadata list error:" + ex.getMessage() + ", param:" + JsonUtils.objectToString((Object)httpEntity)));
            }
            if (HttpStatus.OK.value() != respEntity.getStatusCodeValue() || respEntity.getBody() == null || !CollectionUtils.isNotEmpty((Collection)((JSONObject)respEntity.getBody()).getJSONArray("data"))) {
                log.error("query user metadata list fail. url:{}, param:{}, result:{}", new Object[]{url, JsonUtils.objectToString((Object)httpEntity), respEntity});
                throw BusinessException.create((String)("query user metadata list fail. param:" + JsonUtils.objectToString((Object)httpEntity) + ", result:" + respEntity));
            }
            JSONArray data = ((JSONObject)respEntity.getBody()).getJSONArray("data");
            log.info("query user metadata list success. param:{}, result:{}", (Object)JsonUtils.objectToString((Object)httpEntity), (Object)data);
            result.addAll(JSONArray.toList((JSONArray)data, (Object)new PersonalizedDto(), (JsonConfig)new JsonConfig()));
        });
        return result;
    }
}

