/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.infrastructure.mongo;

import com.digiwin.athena.aim.domain.message.model.CiConstant;
import com.digiwin.athena.aim.domain.message.model.MessageDO;
import com.digiwin.athena.aim.util.DistributeUtils;
import com.digiwin.athena.aim.util.ValidateUtils;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.redis.core.RedisTemplate;

public abstract class AbstractMongoMessageMapper {
    protected static final String TEMPLATE_COLLECTION_NAME = "template-collection";
    protected static final String APP_EXPIRATION_MESSAGE_COLLECTION_NAME_SUFFIX = "-app-expire-message-collection";
    protected static final String MESSAGE_CENTER_RECORD_COLLECTION_NAME_SUFFIX = "-message-center-record-collection";
    protected static final String COLLECTION_NAME_SUFFIX = "-message-collection";
    private static final String LOCK_NAME_SUFFIX = ":createMongoCollection:lock";
    protected static final String ORDER_CREATETIME = "createDate";
    protected static final long DEFAULT_LIMIT = 2000L;
    private ConcurrentHashMap<String, String> existCollections = new ConcurrentHashMap();
    @Resource
    private RedisTemplate redisTemplate;
    @Resource
    protected MongoTemplate msgMongoTemplate;

    public String getCollectionNameForTempTemplate() {
        return TEMPLATE_COLLECTION_NAME;
    }

    public String getCollectionNameForAppExpirationMessage(String tenantId) {
        ValidateUtils.checkTenantId((String)tenantId);
        return StringUtils.trim((String)tenantId) + APP_EXPIRATION_MESSAGE_COLLECTION_NAME_SUFFIX;
    }

    public String getCollectionName(MessageDO messageDO) {
        return this.getCollectionName(messageDO.getTenantId());
    }

    public String getCollectionName(String tenantId) {
        ValidateUtils.checkTenantId((String)tenantId);
        return StringUtils.trim((String)tenantId) + COLLECTION_NAME_SUFFIX;
    }

    public String getCollectionNameForMessageCenterRecord(String tenantId) {
        ValidateUtils.checkTenantId((String)tenantId);
        return StringUtils.trim((String)tenantId) + MESSAGE_CENTER_RECORD_COLLECTION_NAME_SUFFIX;
    }

    protected void createCollectionNecessary(String collectionName, String collectionFlag) {
        if (this.existCollections.contains(collectionName)) {
            return;
        }
        if (this.msgMongoTemplate.collectionExists(collectionName)) {
            this.existCollections.put(collectionName, "1");
            return;
        }
        String lockName = collectionName + LOCK_NAME_SUFFIX;
        DistributeUtils.tryLock30s((RedisTemplate)this.redisTemplate, (String)lockName, () -> {
            if (this.msgMongoTemplate.collectionExists(collectionName)) {
                this.existCollections.put(collectionName, "1");
                return;
            }
            this.msgMongoTemplate.createCollection(collectionName);
            if (StringUtils.isBlank((String)collectionFlag)) {
                this.createIndex(collectionName);
            } else if (CiConstant.CollectionFlagEnum.TEMPLATE.getFlag().equals(collectionFlag)) {
                this.createIndexForTemplateCollection(collectionName);
            } else if (CiConstant.CollectionFlagEnum.APP_EXPIRATION_MESSAGE.getFlag().equals(collectionFlag)) {
                this.createIndexForAppExpirationCollection(collectionName);
            }
            this.existCollections.put(collectionName, "1");
        });
    }

    private void createIndex(String collectionName) {
        IndexOptions indexOptions = new IndexOptions().unique(true).background(true).name("UNIQUE_IDX_GID");
        this.msgMongoTemplate.getCollection(collectionName).createIndex((Bson)new Document("gid", (Object)-1), indexOptions);
        this.msgMongoTemplate.getCollection(collectionName).createIndex((Bson)new Document("userId", (Object)1));
        this.msgMongoTemplate.getCollection(collectionName).createIndex((Bson)new Document(ORDER_CREATETIME, (Object)-1));
        Bson index1 = Indexes.compoundIndex((Bson[])new Bson[]{Indexes.ascending((String[])new String[]{"userId"}), Indexes.descending((String[])new String[]{ORDER_CREATETIME})});
        IndexOptions indexOptions1 = new IndexOptions().background(true);
        this.msgMongoTemplate.getCollection(collectionName).createIndex(index1, indexOptions1);
        Bson index2 = Indexes.compoundIndex((Bson[])new Bson[]{Indexes.ascending((String[])new String[]{"userId"}), Indexes.ascending((String[])new String[]{"state"}), Indexes.descending((String[])new String[]{ORDER_CREATETIME})});
        IndexOptions indexOptions2 = new IndexOptions().background(true);
        this.msgMongoTemplate.getCollection(collectionName).createIndex(index2, indexOptions2);
    }

    private void createIndexForTemplateCollection(String collectionName) {
        IndexOptions indexOptions = new IndexOptions().unique(true).background(true).name("UNIQUE_IDX_GID");
        this.msgMongoTemplate.getCollection(collectionName).createIndex((Bson)new Document("gid", (Object)-1), indexOptions);
        this.msgMongoTemplate.getCollection(collectionName).createIndex((Bson)new Document("code", (Object)1));
    }

    private void createIndexForAppExpirationCollection(String collectionName) {
        IndexOptions indexOptions = new IndexOptions().unique(true).background(true).name("UNIQUE_IDX_GID");
        this.msgMongoTemplate.getCollection(collectionName).createIndex((Bson)new Document("gid", (Object)-1), indexOptions);
        this.msgMongoTemplate.getCollection(collectionName).createIndex((Bson)new Document("userId", (Object)1));
        this.msgMongoTemplate.getCollection(collectionName).createIndex((Bson)new Document(ORDER_CREATETIME, (Object)-1));
    }

    protected long countByCondition(String collectionName, Criteria criteria, long limit, String ... orderFields) {
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.sort((Sort.Direction)Sort.Direction.DESC, (String[])orderFields), Aggregation.limit((long)limit), Aggregation.count().as("total")});
        AggregationResults result = this.msgMongoTemplate.aggregate(aggregation, collectionName, Document.class);
        if (CollectionUtils.isNotEmpty((Collection)result.getMappedResults())) {
            Document document = (Document)result.getMappedResults().get(0);
            return MapUtils.getLong((Map)document, (Object)"total");
        }
        return 0L;
    }
}

