/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.infrastructure.mongo;

import com.digiwin.athena.aim.domain.message.model.MessageCenterRecordDO;
import com.digiwin.athena.aim.domain.message.model.MessageCenterRecordReq;
import com.digiwin.athena.aim.domain.message.repository.MessageCenterMapper;
import com.digiwin.athena.aim.infrastructure.mongo.AbstractMongoMessageMapper;
import com.digiwin.athena.aim.util.LanguageUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

@Component
public class MongoMessageCenterMapper
extends AbstractMongoMessageMapper
implements MessageCenterMapper {
    public MessageCenterRecordDO insert(MessageCenterRecordDO messageCenterRecordDO) {
        String collectionName = this.getCollectionNameForMessageCenterRecord(messageCenterRecordDO.getTenantId());
        return (MessageCenterRecordDO)this.msgMongoTemplate.insert((Object)messageCenterRecordDO, collectionName);
    }

    public PageImpl<MessageCenterRecordDO> pageMessageCenterRecord(MessageCenterRecordReq messageCenterSendReq) throws IllegalAccessException {
        if (StringUtils.isEmpty((String)messageCenterSendReq.getTenantId()) || StringUtils.isEmpty((String)messageCenterSendReq.getAppCode()) || StringUtils.isEmpty((String)messageCenterSendReq.getChannelType())) {
            return new PageImpl(new ArrayList(), (Pageable)PageRequest.of((int)messageCenterSendReq.getPageNum(), (int)messageCenterSendReq.getPageSize()), 0L);
        }
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)messageCenterSendReq.getTenantId()).and("appCode").is((Object)messageCenterSendReq.getAppCode()).and("channelType").is((Object)messageCenterSendReq.getChannelType());
        if (StringUtils.isNotBlank((String)messageCenterSendReq.getSceneName())) {
            String lang = LocaleContextHolder.getLocale().toString();
            criteria.and("lang.sceneName." + lang).regex(messageCenterSendReq.getSceneName());
        }
        if (StringUtils.isNotBlank((String)messageCenterSendReq.getReceiver())) {
            criteria.and("receivers").regex(messageCenterSendReq.getReceiver());
        }
        if (CollectionUtils.isNotEmpty((Collection)messageCenterSendReq.getMsgTypeList())) {
            criteria.and("msgType").in((Collection)messageCenterSendReq.getMsgTypeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)messageCenterSendReq.getStatuslist())) {
            criteria.and("status").in((Collection)messageCenterSendReq.getStatuslist());
        }
        long count = this.countByCondition(this.getCollectionNameForMessageCenterRecord(messageCenterSendReq.getTenantId()), criteria, 2000L, new String[]{"createDate"});
        PageRequest pageable = PageRequest.of((int)messageCenterSendReq.getPageNum(), (int)messageCenterSendReq.getPageSize());
        List messageList = this.msgMongoTemplate.find(new Query().addCriteria((CriteriaDefinition)criteria).with((Pageable)pageable).with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createDate"})), MessageCenterRecordDO.class, this.getCollectionNameForMessageCenterRecord(messageCenterSendReq.getTenantId()));
        LanguageUtil.processLocaleLanguage((Object)messageList, (String)LocaleContextHolder.getLocale().toString());
        return new PageImpl(messageList, (Pageable)pageable, count);
    }
}

